/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DMRFactory;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.AbstractDSP;
import dap4.dap4lib.XURI;
import dap4.dap4lib.netcdf.Nc4Cursor;
import dap4.dap4lib.netcdf.Nc4DMRCompiler;
import dap4.dap4lib.netcdf.Nc4Notes;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeTByReference;

public class Nc4DSP
extends AbstractDSP {
    public static final boolean DEBUG = false;
    public static final boolean DUMPDMR = false;
    static String PATHSUFFIX = "/src/data";
    public static String[] EXTENSIONS = new String[]{".nc", ".hdf5"};
    static final Pointer NC_NULL = Pointer.NULL;
    static final int NC_FALSE = 0;
    static final int NC_TRUE = 1;
    public static final int NC_GRPNULL = 0;
    public static final int NC_IDNULL = -1;
    public static final int NC_NOERR = 0;
    static int NC_INT_BYTES = 4;
    static int NC_LONG_BYTES = Native.LONG_SIZE;
    static int NC_POINTER_BYTES = Native.POINTER_SIZE;
    static int NC_SIZET_BYTES = Native.SIZE_T_SIZE;
    protected static Nc4prototypes nc4 = NetcdfClibrary.getForeignFunctionInterface();
    protected Map<Nc4Notes.NoteSort, Map<Long, Nc4Notes.Notes>> allnotes = null;
    protected boolean trace = false;
    protected boolean closed = false;
    protected int ncid = -1;
    protected int format = 0;
    protected int mode = 0;
    protected String filepath = null;
    protected DMRFactory dmrfactory = null;

    @Override
    public boolean dspMatch(String path, DapContext context) {
        for (String s2 : EXTENSIONS) {
            if (!path.endsWith(s2)) continue;
            return true;
        }
        return false;
    }

    void note(Nc4Notes.Notes note) {
        assert (this.allnotes != null);
        int gid = note.gid;
        int id = note.id;
        Nc4Notes.NoteSort sort = note.getSort();
        Map<Long, Nc4Notes.Notes> sortnotes = this.allnotes.get((Object)sort);
        assert (sortnotes != null);
        switch (sort) {
            case TYPE: 
            case GROUP: 
            case DIM: {
                assert (sortnotes.get(id) == null);
                sortnotes.put(Long.valueOf(id), note);
                break;
            }
            case VAR: {
                long gv = Nc4Notes.getVarId((Nc4Notes.VarNotes)note);
                assert (sortnotes.get(gv) == null);
                sortnotes.put(gv, note);
            }
        }
    }

    Nc4Notes.VarNotes findVar(int gid, int varid) {
        long gv = Nc4Notes.getVarId(gid, varid, -1);
        return (Nc4Notes.VarNotes)this.find(gv, Nc4Notes.NoteSort.VAR);
    }

    Nc4Notes.VarNotes findField(int gid, int varid, int fid) {
        long gv = Nc4Notes.getVarId(gid, varid, fid);
        return (Nc4Notes.VarNotes)this.find(gv, Nc4Notes.NoteSort.VAR);
    }

    public Nc4Notes.Notes find(long id, Nc4Notes.NoteSort sort) {
        assert (this.allnotes != null);
        Map<Long, Nc4Notes.Notes> sortnotes = this.allnotes.get((Object)sort);
        assert (sortnotes != null);
        return sortnotes.get(id);
    }

    Nc4Notes.Notes find(DapNode node) {
        Nc4Notes.NoteSort sort = this.noteSortFor(node);
        assert (this.allnotes != null);
        Map<Long, Nc4Notes.Notes> sortnotes = this.allnotes.get((Object)sort);
        assert (sortnotes != null);
        for (Map.Entry<Long, Nc4Notes.Notes> entries : sortnotes.entrySet()) {
            Nc4Notes.Notes note = entries.getValue();
            if (note.get() != node) continue;
            return note;
        }
        return null;
    }

    protected Nc4Notes.NoteSort noteSortFor(DapNode node) {
        switch (node.getSort()) {
            case ATOMICTYPE: 
            case STRUCTURE: 
            case SEQUENCE: {
                return Nc4Notes.NoteSort.TYPE;
            }
            case VARIABLE: {
                return Nc4Notes.NoteSort.VAR;
            }
            case GROUP: 
            case DATASET: {
                return Nc4Notes.NoteSort.GROUP;
            }
            case DIMENSION: {
                return Nc4Notes.NoteSort.DIM;
            }
        }
        return null;
    }

    protected void allnotesInit() {
        this.allnotes = new HashMap<Nc4Notes.NoteSort, Map<Long, Nc4Notes.Notes>>();
        for (Nc4Notes.NoteSort s2 : Nc4Notes.NoteSort.values()) {
            this.allnotes.put(s2, new HashMap());
        }
        Nc4Notes.Notes n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 1, this);
        n.set(DapType.INT8);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 2, this);
        n.set(DapType.CHAR);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 3, this);
        n.set(DapType.INT16);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 4, this);
        n.set(DapType.INT32);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 5, this);
        n.set(DapType.FLOAT32);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 6, this);
        n.set(DapType.FLOAT64);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 7, this);
        n.set(DapType.UINT8);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 8, this);
        n.set(DapType.UINT16);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 9, this);
        n.set(DapType.UINT32);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 10, this);
        n.set(DapType.INT64);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 11, this);
        n.set(DapType.UINT64);
        this.note(n);
        n = Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, 0, 12, this);
        n.set(DapType.STRING);
        this.note(n);
        for (int i = 1; i <= 12; ++i) {
            SizeTByReference sizep;
            Nc4Notes.TypeNotes tn;
            block6: {
                tn = (Nc4Notes.TypeNotes)this.find(i, Nc4Notes.NoteSort.TYPE);
                assert (tn != null);
                int ret = 0;
                byte[] namep = new byte[257];
                if (i == 12) {
                    tn.setSize(Native.POINTER_SIZE);
                    continue;
                }
                sizep = new SizeTByReference();
                try {
                    ret = nc4.nc_inq_type(0, i, namep, sizep);
                    Nc4Cursor.errcheck(this.getJNI(), ret);
                }
                catch (DapException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            tn.setSize(sizep.intValue());
        }
    }

    public Nc4DSP() throws DapException {
        if (nc4 == null) {
            throw new DapException("Could not load libnetcdf");
        }
        this.dmrfactory = new DMRFactory();
        this.allnotesInit();
    }

    @Override
    public Nc4DSP open(String filepath) throws DapException {
        if (filepath.startsWith("file:")) {
            try {
                XURI xuri = new XURI(filepath);
                filepath = xuri.getPath();
            }
            catch (URISyntaxException use) {
                throw new DapException("Malformed filepath: " + filepath).setCode(404);
            }
        }
        IntByReference ncidp = new IntByReference();
        this.filepath = filepath;
        try {
            int mode = 0;
            int ret = nc4.nc_open(this.filepath, mode, ncidp);
            Nc4Cursor.errcheck(nc4, ret);
            this.ncid = ncidp.getValue();
            IntByReference formatp = new IntByReference();
            ret = nc4.nc_inq_format(this.ncid, formatp);
            Nc4Cursor.errcheck(nc4, ret);
            this.format = formatp.getValue();
            Nc4DMRCompiler dmrcompiler = new Nc4DMRCompiler(this, this.ncid, this.dmrfactory);
            this.setDMR(dmrcompiler.compile());
            return this;
        }
        catch (Exception t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() throws DapException {
        if (this.closed) {
            return;
        }
        if (this.ncid < 0) {
            return;
        }
        int ret = nc4.nc_close(this.ncid);
        Nc4Cursor.errcheck(nc4, ret);
        this.closed = true;
        if (this.trace) {
            System.out.printf("Nc4DSP: closed: %s%n", this.filepath);
        }
    }

    @Override
    public Nc4Cursor getVariableData(DapVariable var) throws DapException {
        assert (var.isTopLevel());
        DapType type = var.getBaseType();
        Nc4Cursor vardata = (Nc4Cursor)super.getVariableData(var);
        if (vardata == null) {
            switch (type.getTypeSort()) {
                case Structure: {
                    vardata = new Nc4Cursor(DataCursor.Scheme.STRUCTARRAY, this, var, null);
                    break;
                }
                case Sequence: {
                    vardata = new Nc4Cursor(DataCursor.Scheme.SEQARRAY, this, var, null);
                    break;
                }
                default: {
                    if (!type.isAtomic()) {
                        throw new DapException("Unexpected cursor type: " + type);
                    }
                    vardata = new Nc4Cursor(DataCursor.Scheme.ATOMIC, this, var, null);
                }
            }
            super.addVariableData(var, vardata);
        }
        assert (var.isTopLevel());
        return vardata;
    }

    public Nc4prototypes getJNI() {
        return nc4;
    }

    @Override
    public String getLocation() {
        return this.filepath;
    }

    public static String makeString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, DapUtil.UTF8);
    }

    public static class Nc4Pointer {
        public Pointer p;
        public long size;

        public static Nc4Pointer allocate(long size) {
            if (size == 0L) {
                throw new IllegalArgumentException("Attempt to allocate zero bytes");
            }
            Memory m3 = new Memory(size);
            return new Nc4Pointer(m3, size);
        }

        public Nc4Pointer(Pointer p, long size) {
            this.p = p;
            this.size = size;
        }

        public Nc4Pointer share(long offset, long size) {
            try {
                Pointer ps = this.p.share(offset, size);
                Nc4Pointer newp = new Nc4Pointer(ps, size);
                return newp;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        public String toString() {
            return String.format("0x%016x/%d", Pointer.nativeValue(this.p), this.size);
        }

        public static boolean validate(Nc4Pointer mem, long require) {
            if (mem == null || mem.p == null || mem.size == 0L) {
                return false;
            }
            return mem.size > require;
        }
    }
}

