/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import ucar.httpservices.HTTPConnections;
import ucar.httpservices.HTTPMethod;

@ThreadSafe
class HTTPConnectionSimple
extends HTTPConnections {
    protected Map<HTTPMethod, HttpClientConnectionManager> methodmap = null;
    protected Map<HttpClientConnectionManager, HTTPMethod> mgrmap = new HashMap<HttpClientConnectionManager, HTTPMethod>();

    public HTTPConnectionSimple() {
        super(false);
        this.methodmap = new HashMap<HTTPMethod, HttpClientConnectionManager>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientConnectionManager newManager(HTTPMethod method) {
        BasicHttpClientConnectionManager mgr = null;
        while (true) {
            boolean await = true;
            HTTPConnectionSimple hTTPConnectionSimple = this;
            synchronized (hTTPConnectionSimple) {
                if (this.actualconnections < this.maxconnections) {
                    HttpClientConnectionManager old = this.methodmap.get(method);
                    if (old != null) {
                        throw new IllegalStateException("Method has previous Connection Manager");
                    }
                    mgr = new BasicHttpClientConnectionManager(this.getRegistry());
                    this.methodmap.put(method, mgr);
                    this.mgrmap.put(mgr, method);
                    ++this.actualconnections;
                    await = false;
                    if (TRACE) {
                        System.err.println("HTTPConnections: open connection: " + method.hashCode());
                    }
                } else if (TRACE) {
                    throw new IllegalStateException("HTTPConnections: too many connections");
                }
            }
            if (!await) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                mgr = null;
                break;
            }
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeManager(HTTPMethod method) {
        HTTPConnectionSimple hTTPConnectionSimple = this;
        synchronized (hTTPConnectionSimple) {
            HttpClientConnectionManager mgr = this.methodmap.get(method);
            if (mgr == null) {
                throw new IllegalStateException();
            }
            this.mgrmap.remove(mgr, method);
            this.methodmap.remove(method);
            ((BasicHttpClientConnectionManager)mgr).close();
            if (method.executed) {
                --this.actualconnections;
            }
            if (TRACE) {
                System.err.println("HTTPConnections: close connection: " + method.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HTTPConnectionSimple hTTPConnectionSimple = this;
        synchronized (hTTPConnectionSimple) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (TRACE) {
                System.err.println("HTTPConnections: close with open connections: " + this.methodmap.size());
            }
            for (HTTPMethod m3 : this.methodmap.keySet()) {
                this.freeManager(m3);
            }
            assert (this.methodmap.size() == 0);
            assert (this.mgrmap.size() == 0);
        }
    }

    @Override
    void validate() {
        assert (this.methodmap.size() == 0);
        assert (this.mgrmap.size() == 0);
        super.validate();
    }
}

