/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArrayVlen;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.array.Section;
import ucar.array.Storage;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureDataStorageBB;
import ucar.array.StructureMembers;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class GcdmConverter {
    private static final boolean debugSize = false;

    public static GcdmNetcdfProto.DataType convertDataType(ArrayType dtype) {
        switch (dtype) {
            case CHAR: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_CHAR;
            }
            case BYTE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_BYTE;
            }
            case SHORT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_SHORT;
            }
            case INT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_INT;
            }
            case LONG: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_LONG;
            }
            case FLOAT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_FLOAT;
            }
            case DOUBLE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_DOUBLE;
            }
            case STRING: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_STRING;
            }
            case STRUCTURE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_STRUCTURE;
            }
            case SEQUENCE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE;
            }
            case ENUM1: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM1;
            }
            case ENUM2: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM2;
            }
            case ENUM4: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM4;
            }
            case OPAQUE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_OPAQUE;
            }
            case UBYTE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_UBYTE;
            }
            case USHORT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_USHORT;
            }
            case UINT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_UINT;
            }
            case ULONG: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ULONG;
            }
        }
        throw new IllegalStateException("illegal data type " + dtype);
    }

    public static ArrayType convertDataType(GcdmNetcdfProto.DataType dtype) {
        switch (dtype) {
            case DATA_TYPE_CHAR: {
                return ArrayType.CHAR;
            }
            case DATA_TYPE_BYTE: {
                return ArrayType.BYTE;
            }
            case DATA_TYPE_SHORT: {
                return ArrayType.SHORT;
            }
            case DATA_TYPE_INT: {
                return ArrayType.INT;
            }
            case DATA_TYPE_LONG: {
                return ArrayType.LONG;
            }
            case DATA_TYPE_FLOAT: {
                return ArrayType.FLOAT;
            }
            case DATA_TYPE_DOUBLE: {
                return ArrayType.DOUBLE;
            }
            case DATA_TYPE_STRING: {
                return ArrayType.STRING;
            }
            case DATA_TYPE_STRUCTURE: {
                return ArrayType.STRUCTURE;
            }
            case DATA_TYPE_SEQUENCE: {
                return ArrayType.SEQUENCE;
            }
            case DATA_TYPE_ENUM1: {
                return ArrayType.ENUM1;
            }
            case DATA_TYPE_ENUM2: {
                return ArrayType.ENUM2;
            }
            case DATA_TYPE_ENUM4: {
                return ArrayType.ENUM4;
            }
            case DATA_TYPE_OPAQUE: {
                return ArrayType.OPAQUE;
            }
            case DATA_TYPE_UBYTE: {
                return ArrayType.UBYTE;
            }
            case DATA_TYPE_USHORT: {
                return ArrayType.USHORT;
            }
            case DATA_TYPE_UINT: {
                return ArrayType.UINT;
            }
            case DATA_TYPE_ULONG: {
                return ArrayType.ULONG;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    public static List<GcdmNetcdfProto.Attribute> encodeAttributes(AttributeContainer atts) {
        ArrayList<GcdmNetcdfProto.Attribute> result = new ArrayList<GcdmNetcdfProto.Attribute>();
        for (Attribute att : atts) {
            result.add(GcdmConverter.encodeAtt(att).build());
        }
        return result;
    }

    public static GcdmNetcdfProto.Group.Builder encodeGroup(Group g, int sizeToCache) throws IOException {
        GcdmNetcdfProto.Group.Builder groupBuilder = GcdmNetcdfProto.Group.newBuilder();
        groupBuilder.setName(g.getShortName());
        for (Dimension dim : g.getDimensions()) {
            groupBuilder.addDims(GcdmConverter.encodeDim(dim));
        }
        for (Attribute att : g.attributes()) {
            groupBuilder.addAtts(GcdmConverter.encodeAtt(att));
        }
        for (EnumTypedef enumType : g.getEnumTypedefs()) {
            groupBuilder.addEnumTypes(GcdmConverter.encodeEnumTypedef(enumType));
        }
        for (Variable var : g.getVariables()) {
            if (var instanceof Structure) {
                groupBuilder.addStructs(GcdmConverter.encodeStructure((Structure)var));
                continue;
            }
            groupBuilder.addVars(GcdmConverter.encodeVar(var, sizeToCache));
        }
        for (Group ng : g.getGroups()) {
            groupBuilder.addGroups(GcdmConverter.encodeGroup(ng, sizeToCache));
        }
        return groupBuilder;
    }

    public static GcdmNetcdfProto.Error encodeErrorMessage(String message) {
        GcdmNetcdfProto.Error.Builder builder = GcdmNetcdfProto.Error.newBuilder();
        builder.setMessage(message);
        return builder.build();
    }

    public static GcdmNetcdfProto.Section encodeSection(ucar.array.Section section) {
        GcdmNetcdfProto.Section.Builder sbuilder = GcdmNetcdfProto.Section.newBuilder();
        for (Range r : section.getRanges()) {
            GcdmNetcdfProto.Range.Builder rbuilder = GcdmNetcdfProto.Range.newBuilder();
            rbuilder.setStart(r.first());
            rbuilder.setSize(r.length());
            rbuilder.setStride(r.stride());
            sbuilder.addRanges(rbuilder);
        }
        return sbuilder.build();
    }

    private static GcdmNetcdfProto.Attribute.Builder encodeAtt(Attribute att) {
        GcdmNetcdfProto.Attribute.Builder attBuilder = GcdmNetcdfProto.Attribute.newBuilder();
        attBuilder.setName(att.getShortName());
        attBuilder.setDataType(GcdmConverter.convertDataType(att.getDataType().getArrayType()));
        attBuilder.setLength(att.getLength());
        if (att.getLength() > 0) {
            if (att.isString()) {
                GcdmNetcdfProto.Data.Builder datab = GcdmNetcdfProto.Data.newBuilder();
                for (int i = 0; i < att.getLength(); ++i) {
                    datab.addSdata(att.getStringValue(i));
                }
                datab.setDataType(GcdmConverter.convertDataType(att.getArrayType()));
                GcdmConverter.encodeShape(datab, new int[]{att.getLength()});
                attBuilder.setData(datab);
            } else {
                attBuilder.setData(GcdmConverter.encodePrimitiveData(att.getArrayType(), att.getArrayValues()));
            }
        }
        return attBuilder;
    }

    private static GcdmNetcdfProto.Dimension.Builder encodeDim(Dimension dim) {
        GcdmNetcdfProto.Dimension.Builder dimBuilder = GcdmNetcdfProto.Dimension.newBuilder();
        if (dim.getShortName() != null) {
            dimBuilder.setName(dim.getShortName());
        }
        if (!dim.isVariableLength()) {
            dimBuilder.setLength(dim.getLength());
        }
        dimBuilder.setIsPrivate(!dim.isShared());
        dimBuilder.setIsVlen(dim.isVariableLength());
        dimBuilder.setIsUnlimited(dim.isUnlimited());
        return dimBuilder;
    }

    private static GcdmNetcdfProto.EnumTypedef.Builder encodeEnumTypedef(EnumTypedef enumType) {
        GcdmNetcdfProto.EnumTypedef.Builder builder = GcdmNetcdfProto.EnumTypedef.newBuilder();
        builder.setName(enumType.getShortName());
        builder.setBaseType(GcdmConverter.convertDataType(enumType.getBaseType().getArrayType()));
        ImmutableMap map = enumType.getMap();
        GcdmNetcdfProto.EnumTypedef.EnumType.Builder b2 = GcdmNetcdfProto.EnumTypedef.EnumType.newBuilder();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            b2.clear();
            b2.setCode(code);
            b2.setValue((String)map.get(code));
            builder.addMaps(b2);
        }
        return builder;
    }

    private static GcdmNetcdfProto.Structure.Builder encodeStructure(Structure s) throws IOException {
        GcdmNetcdfProto.Structure.Builder builder = GcdmNetcdfProto.Structure.newBuilder();
        builder.setName(s.getShortName());
        builder.setDataType(GcdmConverter.convertDataType(s.getArrayType()));
        for (Dimension dim : s.getDimensions()) {
            builder.addShapes(GcdmConverter.encodeDim(dim));
        }
        for (Attribute att : s.attributes()) {
            builder.addAtts(GcdmConverter.encodeAtt(att));
        }
        for (Variable v : s.getVariables()) {
            if (v instanceof Structure) {
                builder.addStructs(GcdmConverter.encodeStructure((Structure)v));
                continue;
            }
            builder.addVars(GcdmConverter.encodeVar(v, -1));
        }
        return builder;
    }

    private static GcdmNetcdfProto.Variable.Builder encodeVar(Variable var, int sizeToCache) throws IOException {
        Object enumType;
        GcdmNetcdfProto.Variable.Builder builder = GcdmNetcdfProto.Variable.newBuilder();
        builder.setName(var.getShortName());
        builder.setDataType(GcdmConverter.convertDataType(var.getArrayType()));
        if (var.getDataType().isEnum() && (enumType = var.getEnumTypedef()) != null) {
            builder.setEnumType(enumType.getShortName());
        }
        for (Dimension dim : var.getDimensions()) {
            builder.addShapes(GcdmConverter.encodeDim(dim));
        }
        for (Attribute att : var.attributes()) {
            builder.addAtts(GcdmConverter.encodeAtt(att));
        }
        if (var.isCaching() && var.getArrayType().isNumeric() && (var.isCoordinateVariable() || var.getSize() * (long)var.getElementSize() < (long)sizeToCache)) {
            Array data = var.readArray();
            builder.setData(GcdmConverter.encodeData(var.getArrayType(), data));
        }
        return builder;
    }

    public static GcdmNetcdfProto.Data encodeData(ArrayType dataType, Array<?> data) {
        GcdmNetcdfProto.Data result = dataType == ArrayType.OPAQUE ? GcdmConverter.encodePrimitiveData(dataType, data) : (data.isVlen() ? GcdmConverter.encodeVlenData(dataType, (ArrayVlen)data) : (data instanceof StructureDataArray ? GcdmConverter.encodeStructureDataArray(dataType, (StructureDataArray)data) : GcdmConverter.encodePrimitiveData(dataType, data)));
        return result;
    }

    private static void encodeShape(GcdmNetcdfProto.Data.Builder data, int[] shape) {
        for (int j : shape) {
            data.addShapes(j);
        }
    }

    private static GcdmNetcdfProto.Data encodePrimitiveData(ArrayType dataType, Array<?> data) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, data.getShape());
        switch (dataType) {
            case OPAQUE: {
                ArrayVlen vlen = (ArrayVlen)data;
                int nelems = (int)Arrays.computeSize((int[])data.getShape());
                int i = 0;
                while (i < nelems) {
                    builder.addBdata(Arrays.getByteString((Array)vlen.get(new int[]{i++})));
                }
                break;
            }
            case CHAR: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                builder.addBdata(Arrays.getByteString(data));
                break;
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                Array<?> idata = data;
                idata.forEach(val -> builder.addIdata(val.shortValue()));
                break;
            }
            case INT: {
                Array<?> idata = data;
                idata.forEach(val -> builder.addIdata((int)val));
                break;
            }
            case ENUM4: 
            case UINT: {
                Array<?> idata = data;
                idata.forEach(val -> builder.addUidata((int)val));
                break;
            }
            case LONG: {
                Array<?> ldata = data;
                ldata.forEach(val -> builder.addLdata((long)val));
                break;
            }
            case ULONG: {
                Array<?> ldata = data;
                ldata.forEach(val -> builder.addUldata((long)val));
                break;
            }
            case FLOAT: {
                Array<?> fdata = data;
                fdata.forEach(val -> builder.addFdata(val.floatValue()));
                break;
            }
            case DOUBLE: {
                Array<?> ddata = data;
                ddata.forEach(val -> builder.addDdata((double)val));
                break;
            }
            case STRING: {
                Array<?> sdata = data;
                sdata.forEach(val -> builder.addSdata((String)val));
                break;
            }
            default: {
                throw new IllegalStateException("Unkown datatype " + dataType);
            }
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.Data encodeStructureDataArray(ArrayType dataType, StructureDataArray arrayStructure) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, arrayStructure.getShape());
        builder.setMembers(GcdmConverter.encodeStructureMembers(arrayStructure.getStructureMembers()));
        int count = 0;
        for (StructureData sdata : arrayStructure) {
            builder.addRows(GcdmConverter.encodeStructureData(sdata));
            ++count;
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.StructureDataProto encodeStructureData(StructureData structData) {
        GcdmNetcdfProto.StructureDataProto.Builder builder = GcdmNetcdfProto.StructureDataProto.newBuilder();
        int count = 0;
        for (StructureMembers.Member member : structData.getStructureMembers()) {
            Array data = structData.getMemberData(member);
            builder.addMemberData(GcdmConverter.encodeData(member.getArrayType(), data));
            ++count;
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.StructureMembersProto encodeStructureMembers(StructureMembers members) {
        GcdmNetcdfProto.StructureMembersProto.Builder builder = GcdmNetcdfProto.StructureMembersProto.newBuilder();
        builder.setName(members.getName());
        for (StructureMembers.Member member : members.getMembers()) {
            GcdmNetcdfProto.StructureMemberProto.Builder smBuilder = GcdmNetcdfProto.StructureMemberProto.newBuilder().setName(member.getName()).setDataType(GcdmConverter.convertDataType(member.getArrayType())).addAllShapes(Ints.asList((int[])member.getShape()));
            if (member.getStructureMembers() != null) {
                smBuilder.setMembers(GcdmConverter.encodeStructureMembers(member.getStructureMembers()));
            }
            builder.addMembers(smBuilder);
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.Data encodeVlenData(ArrayType dataType, ArrayVlen<?> vlenarray) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, vlenarray.getShape());
        for (Array one : vlenarray) {
            builder.addVlen(GcdmConverter.encodeData(vlenarray.getArrayType(), one));
        }
        return builder.build();
    }

    public static AttributeContainer decodeAttributes(String name, List<GcdmNetcdfProto.Attribute> atts) {
        AttributeContainerMutable builder = new AttributeContainerMutable(name);
        for (GcdmNetcdfProto.Attribute att : atts) {
            builder.addAttribute(GcdmConverter.decodeAtt(att));
        }
        return builder.toImmutable();
    }

    public static void decodeGroup(GcdmNetcdfProto.Group proto, Group.Builder g) {
        for (GcdmNetcdfProto.Dimension dim : proto.getDimsList()) {
            g.addDimension(GcdmConverter.decodeDim(dim));
        }
        for (GcdmNetcdfProto.Attribute att : proto.getAttsList()) {
            g.addAttribute(GcdmConverter.decodeAtt(att));
        }
        for (GcdmNetcdfProto.EnumTypedef enumType : proto.getEnumTypesList()) {
            g.addEnumTypedef(GcdmConverter.decodeEnumTypedef(enumType));
        }
        for (GcdmNetcdfProto.Variable var : proto.getVarsList()) {
            g.addVariable(GcdmConverter.decodeVar(var));
        }
        for (GcdmNetcdfProto.Structure s : proto.getStructsList()) {
            g.addVariable(GcdmConverter.decodeStructure(s));
        }
        for (GcdmNetcdfProto.Group gp : proto.getGroupsList()) {
            Group.Builder ng = Group.builder().setName(gp.getName());
            g.addGroup(ng);
            GcdmConverter.decodeGroup(gp, ng);
        }
    }

    private static Attribute decodeAtt(GcdmNetcdfProto.Attribute attp) {
        ArrayType dtUse = GcdmConverter.convertDataType(attp.getDataType());
        int len = attp.getLength();
        if (len == 0) {
            return Attribute.builder((String)attp.getName()).setDataType(dtUse.getDataType()).build();
        }
        Array attData = GcdmConverter.decodePrimitiveData(attp.getData());
        return Attribute.fromArray((String)attp.getName(), attData);
    }

    private static Dimension decodeDim(GcdmNetcdfProto.Dimension dim) {
        String name = dim.getName().isEmpty() ? null : dim.getName();
        int dimLen = dim.getIsVlen() ? -1 : (int)dim.getLength();
        return Dimension.builder().setName(name).setIsShared(!dim.getIsPrivate()).setIsUnlimited(dim.getIsUnlimited()).setIsVariableLength(dim.getIsVlen()).setLength(dimLen).build();
    }

    private static EnumTypedef decodeEnumTypedef(GcdmNetcdfProto.EnumTypedef enumType) {
        List<GcdmNetcdfProto.EnumTypedef.EnumType> list = enumType.getMapsList();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * list.size());
        for (GcdmNetcdfProto.EnumTypedef.EnumType et : list) {
            map.put(et.getCode(), et.getValue());
        }
        ArrayType basetype = GcdmConverter.convertDataType(enumType.getBaseType());
        return new EnumTypedef(enumType.getName(), map, basetype.getDataType());
    }

    private static Structure.Builder<?> decodeStructure(GcdmNetcdfProto.Structure s) {
        Sequence.Builder ncvar = s.getDataType() == GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE ? Sequence.builder() : Structure.builder();
        ((Structure.Builder)ncvar.setName(s.getName())).setDataType(GcdmConverter.convertDataType(s.getDataType()).getDataType());
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        for (GcdmNetcdfProto.Dimension dim : s.getShapesList()) {
            dims.add(GcdmConverter.decodeDim(dim));
        }
        ncvar.addDimensions(dims);
        for (GcdmNetcdfProto.Attribute att : s.getAttsList()) {
            ncvar.addAttribute(GcdmConverter.decodeAtt(att));
        }
        for (GcdmNetcdfProto.Variable vp : s.getVarsList()) {
            ncvar.addMemberVariable(GcdmConverter.decodeVar(vp));
        }
        for (GcdmNetcdfProto.Structure sp : s.getStructsList()) {
            ncvar.addMemberVariable(GcdmConverter.decodeStructure(sp));
        }
        return ncvar;
    }

    public static ucar.array.Section decodeSection(GcdmNetcdfProto.Section proto) {
        Section.Builder section = ucar.array.Section.builder();
        for (GcdmNetcdfProto.Range pr : proto.getRangesList()) {
            try {
                long stride = pr.getStride();
                if (stride == 0L) {
                    stride = 1L;
                }
                if (pr.getSize() == 0L) {
                    section.appendRange(Range.EMPTY);
                    continue;
                }
                section.appendRange((int)pr.getStart(), (int)(pr.getStart() + (pr.getSize() - 1L) * stride), (int)stride);
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException("Bad Section in Gcdm", e);
            }
        }
        return section.build();
    }

    public static Section decodeSection(GcdmNetcdfProto.Variable var) {
        Section.Builder section = Section.builder();
        for (GcdmNetcdfProto.Dimension dim : var.getShapesList()) {
            section.appendRange((int)dim.getLength());
        }
        return section.build();
    }

    private static int[] decodeShape(GcdmNetcdfProto.Data data) {
        int[] shape = new int[data.getShapesCount()];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = data.getShapes(i);
        }
        return shape;
    }

    private static Variable.Builder<?> decodeVar(GcdmNetcdfProto.Variable var) {
        ArrayType varType = GcdmConverter.convertDataType(var.getDataType());
        Variable.Builder ncvar = Variable.builder().setName(var.getName()).setDataType(varType.getDataType());
        if (varType.isEnum()) {
            ncvar.setEnumTypeName(var.getEnumType());
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        Section.Builder section = ucar.array.Section.builder();
        for (GcdmNetcdfProto.Dimension dim : var.getShapesList()) {
            dims.add(GcdmConverter.decodeDim(dim));
            section.appendRange((int)dim.getLength());
        }
        ncvar.addDimensions(dims);
        for (GcdmNetcdfProto.Attribute att : var.getAttsList()) {
            ncvar.addAttribute(GcdmConverter.decodeAtt(att));
        }
        if (var.hasData()) {
            Array data = GcdmConverter.decodePrimitiveData(var.getData());
            ncvar.setSourceData(data);
        }
        return ncvar;
    }

    public static <T> Array<T> decodeData(GcdmNetcdfProto.Data data) {
        if (data.getVlenCount() > 0) {
            return GcdmConverter.decodeVlenData(data);
        }
        if (data.hasMembers()) {
            return GcdmConverter.decodeStructureDataArray(data);
        }
        return GcdmConverter.decodePrimitiveData(data);
    }

    private static <T> Array<T> decodePrimitiveData(GcdmNetcdfProto.Data data) {
        ArrayType dataType = GcdmConverter.convertDataType(data.getDataType());
        int[] shape = GcdmConverter.decodeShape(data);
        switch (dataType) {
            case OPAQUE: {
                byte[][] ragged = new byte[data.getBdataCount()][];
                int countOuter = 0;
                for (ByteString nestedBytes : data.getBdataList()) {
                    ragged[countOuter++] = nestedBytes.toByteArray();
                }
                return ArrayVlen.factory((ArrayType)ArrayType.OPAQUE, (int[])shape, (Object)ragged);
            }
            case CHAR: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                byte[] array = data.getBdata(0).toByteArray();
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case SHORT: 
            case ENUM2: 
            case USHORT: {
                int i = 0;
                short[] array = new short[data.getIdataCount()];
                for (int val : data.getIdataList()) {
                    array[i++] = (short)val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case INT: {
                int i = 0;
                int[] array = new int[data.getIdataCount()];
                for (int val : data.getIdataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case ENUM4: 
            case UINT: {
                int i = 0;
                int[] array = new int[data.getUidataCount()];
                for (int val : data.getUidataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case LONG: {
                int i = 0;
                long[] array = new long[data.getLdataCount()];
                for (long val : data.getLdataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case ULONG: {
                int i = 0;
                long[] array = new long[data.getUldataCount()];
                for (long val : data.getUldataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case FLOAT: {
                int i = 0;
                float[] array = new float[data.getFdataCount()];
                for (float val : data.getFdataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case DOUBLE: {
                int i = 0;
                double[] array = new double[data.getDdataCount()];
                for (double val : data.getDdataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
            case STRING: {
                int i = 0;
                String[] array = new String[data.getSdataCount()];
                for (String val : data.getSdataList()) {
                    array[i++] = val;
                }
                return Arrays.factory((ArrayType)dataType, (int[])shape, (Object)array);
            }
        }
        throw new IllegalStateException("Unknown datatype " + dataType);
    }

    private static StructureDataArray decodeStructureDataArray(GcdmNetcdfProto.Data arrayStructureProto) {
        int nrows = arrayStructureProto.getRowsCount();
        int[] shape = GcdmConverter.decodeShape(arrayStructureProto);
        Preconditions.checkArgument((Arrays.computeSize((int[])shape) == (long)nrows ? 1 : 0) != 0);
        StructureMembers members = GcdmConverter.decodeStructureMembers(arrayStructureProto.getMembers()).build();
        ByteBuffer bbuffer = ByteBuffer.allocate(nrows * members.getStorageSizeBytes());
        StructureDataStorageBB storage = new StructureDataStorageBB(members, bbuffer, nrows);
        int row = 0;
        for (GcdmNetcdfProto.StructureDataProto structProto : arrayStructureProto.getRowsList()) {
            GcdmConverter.decodeStructureData(structProto, members, storage, bbuffer, row);
            ++row;
        }
        return new StructureDataArray(members, shape, (Storage)storage);
    }

    private static StructureMembers.Builder decodeStructureMembers(GcdmNetcdfProto.StructureMembersProto membersProto) {
        StructureMembers.Builder membersb = StructureMembers.builder();
        membersb.setName(membersProto.getName());
        for (GcdmNetcdfProto.StructureMemberProto memberProto : membersProto.getMembersList()) {
            StructureMembers.MemberBuilder mb = StructureMembers.memberBuilder();
            mb.setName(memberProto.getName());
            mb.setArrayType(GcdmConverter.convertDataType(memberProto.getDataType()));
            mb.setShape(Ints.toArray(memberProto.getShapesList()));
            if (memberProto.hasMembers()) {
                mb.setStructureMembers(GcdmConverter.decodeStructureMembers(memberProto.getMembers()));
            }
            membersb.addMember(mb);
        }
        membersb.setStandardOffsets(false);
        return membersb;
    }

    private static void decodeStructureData(GcdmNetcdfProto.StructureDataProto structDataProto, StructureMembers members, StructureDataStorageBB storage, ByteBuffer bbuffer, int rowidx) {
        for (int i = 0; i < structDataProto.getMemberDataCount(); ++i) {
            GcdmNetcdfProto.Data data = structDataProto.getMemberData(i);
            StructureMembers.Member member = members.getMember(i);
            int computed = members.getStorageSizeBytes() * rowidx + member.getOffset();
            bbuffer.position(computed);
            GcdmConverter.decodeNestedData(member, data, storage, bbuffer);
        }
    }

    private static void decodeNestedData(StructureMembers.Member member, GcdmNetcdfProto.Data data, StructureDataStorageBB storage, ByteBuffer bb) {
        if (data.getVlenCount() > 0) {
            ArrayVlen vlen = GcdmConverter.decodeVlenData(data);
            int index = storage.putOnHeap(vlen);
            bb.putInt(index);
            return;
        }
        ArrayType dataType = GcdmConverter.convertDataType(data.getDataType());
        switch (dataType) {
            case CHAR: 
            case BYTE: 
            case ENUM1: 
            case UBYTE: {
                ByteString bs = data.getBdata(0);
                ByteString.ByteIterator byteIterator = bs.iterator();
                while (byteIterator.hasNext()) {
                    byte val = (Byte)byteIterator.next();
                    bb.put(val);
                }
                return;
            }
            case OPAQUE: {
                for (int i = 0; i < data.getBdataCount(); ++i) {
                    ByteString byteString = data.getBdata(i);
                }
            }
            case SHORT: {
                for (int val : data.getIdataList()) {
                    bb.putShort((short)val);
                }
                return;
            }
            case INT: {
                for (int val : data.getIdataList()) {
                    bb.putInt(val);
                }
                return;
            }
            case ENUM2: 
            case USHORT: {
                for (int val : data.getIdataList()) {
                    bb.putShort((short)val);
                }
                return;
            }
            case ENUM4: 
            case UINT: {
                for (int val : data.getUidataList()) {
                    bb.putInt(val);
                }
                return;
            }
            case LONG: {
                for (long val : data.getLdataList()) {
                    bb.putLong(val);
                }
                return;
            }
            case ULONG: {
                for (long val : data.getUldataList()) {
                    bb.putLong(val);
                }
                return;
            }
            case FLOAT: {
                for (float val : data.getFdataList()) {
                    bb.putFloat(val);
                }
                return;
            }
            case DOUBLE: {
                for (double val : data.getDdataList()) {
                    bb.putDouble(val);
                }
                return;
            }
            case STRING: {
                String[] vals = new String[data.getSdataCount()];
                int idx = 0;
                for (String val : data.getSdataList()) {
                    vals[idx++] = val;
                }
                int index = storage.putOnHeap((Object)vals);
                bb.putInt(index);
                return;
            }
            case SEQUENCE: {
                StructureDataArray seqData = GcdmConverter.decodeStructureDataArray(data);
                int index = storage.putOnHeap((Object)seqData);
                bb.putInt(index);
                return;
            }
            case STRUCTURE: {
                Preconditions.checkArgument((member.getStructureMembers() != null ? 1 : 0) != 0);
                GcdmConverter.decodeNestedStructureDataArray(member.getStructureMembers(), data.getRowsList(), storage, bb);
                return;
            }
        }
        throw new IllegalStateException("Unkown datatype " + dataType);
    }

    private static void decodeNestedStructureDataArray(StructureMembers members, List<GcdmNetcdfProto.StructureDataProto> rows, StructureDataStorageBB storage, ByteBuffer bbuffer) {
        int offset = bbuffer.position();
        int rowidx = 0;
        for (GcdmNetcdfProto.StructureDataProto structProto : rows) {
            int memberIdx = 0;
            for (StructureMembers.Member nestedMember : members) {
                int computed = offset + members.getStorageSizeBytes() * rowidx + nestedMember.getOffset();
                bbuffer.position(computed);
                GcdmConverter.decodeNestedData(nestedMember, structProto.getMemberData(memberIdx), storage, bbuffer);
                ++memberIdx;
            }
            ++rowidx;
        }
    }

    private static <T> ArrayVlen<T> decodeVlenData(GcdmNetcdfProto.Data data) {
        Preconditions.checkArgument((data.getVlenCount() > 0 ? 1 : 0) != 0);
        int[] shape = GcdmConverter.decodeShape(data);
        int length = (int)Arrays.computeSize((int[])shape);
        Preconditions.checkArgument((length == data.getVlenCount() ? 1 : 0) != 0);
        ArrayType dataType = GcdmConverter.convertDataType(data.getDataType());
        ArrayVlen result = ArrayVlen.factory((ArrayType)dataType, (int[])shape);
        for (int index = 0; index < length; ++index) {
            GcdmNetcdfProto.Data inner = data.getVlen(index);
            result.set(index, GcdmConverter.decodePrimitiveData(inner));
        }
        return result;
    }
}

