/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IospHelper;

public class GcdmConverterMa2 {
    public static GcdmNetcdfProto.Group.Builder encodeGroup(Group g, int sizeToCache) throws IOException {
        GcdmNetcdfProto.Group.Builder groupBuilder = GcdmNetcdfProto.Group.newBuilder();
        groupBuilder.setName(g.getShortName());
        for (Dimension dim : g.getDimensions()) {
            groupBuilder.addDims(GcdmConverterMa2.encodeDim(dim));
        }
        for (Attribute att : g.attributes()) {
            groupBuilder.addAtts(GcdmConverterMa2.encodeAtt(att));
        }
        for (EnumTypedef enumType : g.getEnumTypedefs()) {
            groupBuilder.addEnumTypes(GcdmConverterMa2.encodeEnumTypedef(enumType));
        }
        for (Variable var : g.getVariables()) {
            if (var instanceof Structure) {
                groupBuilder.addStructs(GcdmConverterMa2.encodeStructure((Structure)var));
                continue;
            }
            groupBuilder.addVars(GcdmConverterMa2.encodeVar(var, sizeToCache));
        }
        for (Group ng : g.getGroups()) {
            groupBuilder.addGroups(GcdmConverterMa2.encodeGroup(ng, sizeToCache));
        }
        return groupBuilder;
    }

    public static GcdmNetcdfProto.Attribute.Builder encodeAtt(Attribute att) {
        GcdmNetcdfProto.Attribute.Builder attBuilder = GcdmNetcdfProto.Attribute.newBuilder();
        attBuilder.setName(att.getShortName());
        attBuilder.setDataType(GcdmConverterMa2.convertDataType(att.getDataType()));
        attBuilder.setLength(att.getLength());
        if (att.getLength() > 0) {
            if (att.isString()) {
                GcdmNetcdfProto.Data.Builder datab = GcdmNetcdfProto.Data.newBuilder();
                for (int i = 0; i < att.getLength(); ++i) {
                    datab.addSdata(att.getStringValue(i));
                }
                datab.setDataType(GcdmConverterMa2.convertDataType(att.getDataType()));
                attBuilder.setData(datab);
            } else {
                attBuilder.setData(GcdmConverterMa2.encodeData(att.getDataType(), att.getValues()));
            }
        }
        return attBuilder;
    }

    private static GcdmNetcdfProto.Dimension.Builder encodeDim(Dimension dim) {
        GcdmNetcdfProto.Dimension.Builder dimBuilder = GcdmNetcdfProto.Dimension.newBuilder();
        if (dim.getShortName() != null) {
            dimBuilder.setName(dim.getShortName());
        }
        if (!dim.isVariableLength()) {
            dimBuilder.setLength(dim.getLength());
        }
        dimBuilder.setIsPrivate(!dim.isShared());
        dimBuilder.setIsVlen(dim.isVariableLength());
        dimBuilder.setIsUnlimited(dim.isUnlimited());
        return dimBuilder;
    }

    private static GcdmNetcdfProto.EnumTypedef.Builder encodeEnumTypedef(EnumTypedef enumType) {
        GcdmNetcdfProto.EnumTypedef.Builder builder = GcdmNetcdfProto.EnumTypedef.newBuilder();
        builder.setName(enumType.getShortName());
        builder.setBaseType(GcdmConverterMa2.convertDataType(enumType.getBaseType()));
        ImmutableMap map = enumType.getMap();
        GcdmNetcdfProto.EnumTypedef.EnumType.Builder b2 = GcdmNetcdfProto.EnumTypedef.EnumType.newBuilder();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            b2.clear();
            b2.setCode(code);
            b2.setValue((String)map.get(code));
            builder.addMaps(b2);
        }
        return builder;
    }

    private static GcdmNetcdfProto.Variable.Builder encodeVar(Variable var, int sizeToCache) throws IOException {
        Object enumType;
        GcdmNetcdfProto.Variable.Builder builder = GcdmNetcdfProto.Variable.newBuilder();
        builder.setName(var.getShortName());
        builder.setDataType(GcdmConverterMa2.convertDataType(var.getDataType()));
        if (var.getDataType().isEnum() && (enumType = var.getEnumTypedef()) != null) {
            builder.setEnumType(enumType.getShortName());
        }
        for (Dimension dim : var.getDimensions()) {
            builder.addShapes(GcdmConverterMa2.encodeDim(dim));
        }
        for (Attribute att : var.attributes()) {
            builder.addAtts(GcdmConverterMa2.encodeAtt(att));
        }
        if (var.isCaching() && var.getDataType().isNumeric() && (var.isCoordinateVariable() || var.getSize() * (long)var.getElementSize() < (long)sizeToCache)) {
            Array data = var.read();
            builder.setData(GcdmConverterMa2.encodeData(var.getDataType(), data));
        }
        return builder;
    }

    private static GcdmNetcdfProto.Structure.Builder encodeStructure(Structure s) throws IOException {
        GcdmNetcdfProto.Structure.Builder builder = GcdmNetcdfProto.Structure.newBuilder();
        builder.setName(s.getShortName());
        builder.setDataType(GcdmConverterMa2.convertDataType(s.getDataType()));
        for (Dimension dim : s.getDimensions()) {
            builder.addShapes(GcdmConverterMa2.encodeDim(dim));
        }
        for (Attribute att : s.attributes()) {
            builder.addAtts(GcdmConverterMa2.encodeAtt(att));
        }
        for (Variable v : s.getVariables()) {
            if (v instanceof Structure) {
                builder.addStructs(GcdmConverterMa2.encodeStructure((Structure)v));
                continue;
            }
            builder.addVars(GcdmConverterMa2.encodeVar(v, -1));
        }
        return builder;
    }

    public static GcdmNetcdfProto.Error encodeErrorMessage(String message) {
        GcdmNetcdfProto.Error.Builder builder = GcdmNetcdfProto.Error.newBuilder();
        builder.setMessage(message);
        return builder.build();
    }

    public static GcdmNetcdfProto.Data encodeData(DataType dataType, Array data) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverterMa2.convertDataType(dataType));
        IndexIterator iiter = data.getIndexIterator();
        switch (dataType) {
            case CHAR: {
                byte[] cdata = IospHelper.convertCharToByte((char[])((char[])data.get1DJavaArray(DataType.CHAR)));
                builder.addBdata(ByteString.copyFrom((byte[])cdata));
                break;
            }
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                byte[] bdata = (byte[])data.get1DJavaArray(DataType.UBYTE);
                builder.addBdata(ByteString.copyFrom((byte[])bdata));
                break;
            }
            case SHORT: 
            case INT: {
                while (iiter.hasNext()) {
                    builder.addIdata(iiter.getIntNext());
                }
                break;
            }
            case ENUM2: 
            case ENUM4: 
            case USHORT: 
            case UINT: {
                while (iiter.hasNext()) {
                    builder.addUidata(iiter.getIntNext());
                }
                break;
            }
            case LONG: {
                while (iiter.hasNext()) {
                    builder.addLdata(iiter.getLongNext());
                }
                break;
            }
            case ULONG: {
                while (iiter.hasNext()) {
                    builder.addUldata(iiter.getLongNext());
                }
                break;
            }
            case FLOAT: {
                while (iiter.hasNext()) {
                    builder.addFdata(iiter.getFloatNext());
                }
                break;
            }
            case DOUBLE: {
                while (iiter.hasNext()) {
                    builder.addDdata(iiter.getDoubleNext());
                }
                break;
            }
            case STRING: {
                while (iiter.hasNext()) {
                    builder.addSdata((String)iiter.getObjectNext());
                }
                break;
            }
            case OPAQUE: {
                while (iiter.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)iiter.getObjectNext();
                    builder.addBdata(ByteString.copyFrom((byte[])bb.array()));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unkown datatype " + dataType);
            }
        }
        return builder.build();
    }

    public static GcdmNetcdfProto.Data encodeVlenData(DataType dataType, ArrayObject data) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverterMa2.convertDataType(dataType));
        IndexIterator objectIterator = data.getIndexIterator();
        block12: while (objectIterator.hasNext()) {
            Array array = (Array)objectIterator.next();
            IndexIterator iiter = array.getIndexIterator();
            switch (dataType) {
                case CHAR: {
                    byte[] cdata = IospHelper.convertCharToByte((char[])((char[])array.get1DJavaArray(DataType.CHAR)));
                    builder.addBdata(ByteString.copyFrom((byte[])cdata));
                    continue block12;
                }
                case ENUM1: 
                case UBYTE: 
                case BYTE: {
                    byte[] bdata = (byte[])array.get1DJavaArray(DataType.UBYTE);
                    builder.addBdata(ByteString.copyFrom((byte[])bdata));
                    continue block12;
                }
                case SHORT: 
                case INT: {
                    while (iiter.hasNext()) {
                        builder.addIdata(iiter.getIntNext());
                    }
                    continue block12;
                }
                case ENUM2: 
                case ENUM4: 
                case USHORT: 
                case UINT: {
                    while (iiter.hasNext()) {
                        builder.addUidata(iiter.getIntNext());
                    }
                    continue block12;
                }
                case LONG: {
                    while (iiter.hasNext()) {
                        builder.addLdata(iiter.getLongNext());
                    }
                    continue block12;
                }
                case ULONG: {
                    while (iiter.hasNext()) {
                        builder.addUldata(iiter.getLongNext());
                    }
                    continue block12;
                }
                case FLOAT: {
                    while (iiter.hasNext()) {
                        builder.addFdata(iiter.getFloatNext());
                    }
                    continue block12;
                }
                case DOUBLE: {
                    while (iiter.hasNext()) {
                        builder.addDdata(iiter.getDoubleNext());
                    }
                    continue block12;
                }
                case STRING: {
                    while (iiter.hasNext()) {
                        builder.addSdata((String)iiter.getObjectNext());
                    }
                    continue block12;
                }
                case OPAQUE: {
                    while (iiter.hasNext()) {
                        ByteBuffer bb = (ByteBuffer)iiter.getObjectNext();
                        builder.addBdata(ByteString.copyFrom((byte[])bb.array()));
                    }
                    continue block12;
                }
            }
            throw new IllegalStateException("Unkown datatype " + dataType);
        }
        return builder.build();
    }

    public static GcdmNetcdfProto.Section encodeSection(Section section) {
        GcdmNetcdfProto.Section.Builder sbuilder = GcdmNetcdfProto.Section.newBuilder();
        for (Range r : section.getRanges()) {
            GcdmNetcdfProto.Range.Builder rbuilder = GcdmNetcdfProto.Range.newBuilder();
            rbuilder.setStart(r.first());
            rbuilder.setSize(r.length());
            rbuilder.setStride(r.stride());
            sbuilder.addRanges(rbuilder);
        }
        return sbuilder.build();
    }

    public static GcdmNetcdfProto.Data encodeArrayStructureData(ArrayStructure arrayStructure) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverterMa2.convertDataType(DataType.STRUCTURE));
        StructureMembers sm = arrayStructure.getStructureMembers();
        for (StructureMembers.Member member : sm.getMembers()) {
            GcdmNetcdfProto.StructureMemberProto.Builder builder2 = GcdmNetcdfProto.StructureMemberProto.newBuilder().setName(member.getName()).setDataType(GcdmConverterMa2.convertDataType(member.getDataType())).addAllShapes(Ints.asList((int[])member.getShape()));
        }
        for (StructureData sdata : arrayStructure) {
            builder.addRows(GcdmConverterMa2.encodeStructureData(sdata));
        }
        return builder.build();
    }

    public static GcdmNetcdfProto.StructureDataProto encodeStructureData(StructureData structData) {
        GcdmNetcdfProto.StructureDataProto.Builder builder = GcdmNetcdfProto.StructureDataProto.newBuilder();
        for (StructureMembers.Member member : structData.getMembers()) {
            Array data = structData.getArray(member);
            builder.addMemberData(GcdmConverterMa2.encodeData(member.getDataType(), data));
        }
        return builder.build();
    }

    private static Dimension decodeDim(GcdmNetcdfProto.Dimension dim) {
        String name = dim.getName().isEmpty() ? null : dim.getName();
        int dimLen = dim.getIsVlen() ? -1 : (int)dim.getLength();
        return Dimension.builder().setName(name).setIsShared(!dim.getIsPrivate()).setIsUnlimited(dim.getIsUnlimited()).setIsVariableLength(dim.getIsVlen()).setLength(dimLen).build();
    }

    public static void decodeGroup(GcdmNetcdfProto.Group proto, Group.Builder g) {
        for (GcdmNetcdfProto.Dimension dim : proto.getDimsList()) {
            g.addDimension(GcdmConverterMa2.decodeDim(dim));
        }
        for (GcdmNetcdfProto.Attribute att : proto.getAttsList()) {
            g.addAttribute(GcdmConverterMa2.decodeAtt(att));
        }
        for (GcdmNetcdfProto.EnumTypedef enumType : proto.getEnumTypesList()) {
            g.addEnumTypedef(GcdmConverterMa2.decodeEnumTypedef(enumType));
        }
        for (GcdmNetcdfProto.Variable var : proto.getVarsList()) {
            g.addVariable(GcdmConverterMa2.decodeVar(var));
        }
        for (GcdmNetcdfProto.Structure s : proto.getStructsList()) {
            g.addVariable(GcdmConverterMa2.decodeStructure(s));
        }
        for (GcdmNetcdfProto.Group gp : proto.getGroupsList()) {
            Group.Builder ng = Group.builder().setName(gp.getName());
            g.addGroup(ng);
            GcdmConverterMa2.decodeGroup(gp, ng);
        }
    }

    private static EnumTypedef decodeEnumTypedef(GcdmNetcdfProto.EnumTypedef enumType) {
        List<GcdmNetcdfProto.EnumTypedef.EnumType> list = enumType.getMapsList();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * list.size());
        for (GcdmNetcdfProto.EnumTypedef.EnumType et : list) {
            map.put(et.getCode(), et.getValue());
        }
        DataType basetype = GcdmConverterMa2.convertDataType(enumType.getBaseType());
        return new EnumTypedef(enumType.getName(), map, basetype);
    }

    public static Attribute decodeAtt(GcdmNetcdfProto.Attribute attp) {
        DataType dtUse = GcdmConverterMa2.convertDataType(attp.getDataType());
        int len = attp.getLength();
        if (len == 0) {
            return Attribute.builder((String)attp.getName()).setDataType(dtUse).build();
        }
        GcdmNetcdfProto.Data attData = attp.getData();
        if (dtUse == DataType.STRING) {
            ProtocolStringList values = attData.getSdataList();
            if (values.size() != len) {
                throw new IllegalStateException();
            }
            if (values.size() == 1) {
                return new Attribute(attp.getName(), (String)values.get(0));
            }
            Array data = Array.factory((DataType)dtUse, (int[])new int[]{len});
            for (int i = 0; i < len; ++i) {
                data.setObject(i, values.get(i));
            }
            return Attribute.fromArray((String)attp.getName(), (Array)data);
        }
        Array array = GcdmConverterMa2.decodeData(attp.getData(), Section.builder().appendRange(len).build());
        return Attribute.fromArray((String)attp.getName(), (Array)array);
    }

    private static Variable.Builder<?> decodeVar(GcdmNetcdfProto.Variable var) {
        DataType varType = GcdmConverterMa2.convertDataType(var.getDataType());
        Variable.Builder ncvar = Variable.builder().setName(var.getName()).setDataType(varType);
        if (varType.isEnum()) {
            ncvar.setEnumTypeName(var.getEnumType());
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        Section.Builder section = Section.builder();
        for (GcdmNetcdfProto.Dimension dim : var.getShapesList()) {
            dims.add(GcdmConverterMa2.decodeDim(dim));
            section.appendRange((int)dim.getLength());
        }
        ncvar.addDimensions(dims);
        for (GcdmNetcdfProto.Attribute att : var.getAttsList()) {
            ncvar.addAttribute(GcdmConverterMa2.decodeAtt(att));
        }
        if (var.hasData()) {
            Array data = GcdmConverterMa2.decodeData(var.getData(), section.build());
            ncvar.setSourceData(data);
        }
        return ncvar;
    }

    private static Structure.Builder<?> decodeStructure(GcdmNetcdfProto.Structure s) {
        Sequence.Builder ncvar = s.getDataType() == GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE ? Sequence.builder() : Structure.builder();
        ((Structure.Builder)ncvar.setName(s.getName())).setDataType(GcdmConverterMa2.convertDataType(s.getDataType()));
        ArrayList<Dimension> dims = new ArrayList<Dimension>(6);
        for (GcdmNetcdfProto.Dimension dim : s.getShapesList()) {
            dims.add(GcdmConverterMa2.decodeDim(dim));
        }
        ncvar.addDimensions(dims);
        for (GcdmNetcdfProto.Attribute att : s.getAttsList()) {
            ncvar.addAttribute(GcdmConverterMa2.decodeAtt(att));
        }
        for (GcdmNetcdfProto.Variable vp : s.getVarsList()) {
            ncvar.addMemberVariable(GcdmConverterMa2.decodeVar(vp));
        }
        for (GcdmNetcdfProto.Structure sp : s.getStructsList()) {
            ncvar.addMemberVariable(GcdmConverterMa2.decodeStructure(sp));
        }
        return ncvar;
    }

    @Nonnull
    public static Section decodeSection(GcdmNetcdfProto.Section proto) {
        Section.Builder section = Section.builder();
        for (GcdmNetcdfProto.Range pr : proto.getRangesList()) {
            try {
                long stride = pr.getStride();
                if (stride == 0L) {
                    stride = 1L;
                }
                if (pr.getSize() == 0L) {
                    section.appendRange(Range.EMPTY);
                    continue;
                }
                section.appendRange((int)pr.getStart(), (int)(pr.getStart() + (pr.getSize() - 1L) * stride), (int)stride);
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException("Bad Section in Gcdm", e);
            }
        }
        return section.build();
    }

    public static Array decodeData(GcdmNetcdfProto.Data data, Section section) {
        DataType dataType = GcdmConverterMa2.convertDataType(data.getDataType());
        int[] shape = section.getShape();
        switch (dataType) {
            case CHAR: {
                byte[] array = data.getBdata(0).toByteArray();
                return Array.factory((DataType)dataType, (int[])shape, (Object)IospHelper.convertByteToChar((byte[])array));
            }
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                byte[] array = data.getBdata(0).toByteArray();
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case SHORT: {
                int i = 0;
                short[] array = new short[data.getIdataCount()];
                for (int val : data.getIdataList()) {
                    array[i++] = (short)val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case INT: {
                int i = 0;
                int[] array = new int[data.getIdataCount()];
                for (int val : data.getIdataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case ENUM2: 
            case USHORT: {
                int i = 0;
                short[] array = new short[data.getUidataCount()];
                for (int val : data.getUidataList()) {
                    array[i++] = (short)val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case ENUM4: 
            case UINT: {
                int i = 0;
                int[] array = new int[data.getUidataCount()];
                for (int val : data.getUidataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case LONG: {
                int i = 0;
                long[] array = new long[data.getLdataCount()];
                for (long val : data.getLdataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case ULONG: {
                int i = 0;
                long[] array = new long[data.getUldataCount()];
                for (long val : data.getUldataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case FLOAT: {
                int i = 0;
                float[] array = new float[data.getFdataCount()];
                for (float val : data.getFdataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case DOUBLE: {
                int i = 0;
                double[] array = new double[data.getDdataCount()];
                for (double val : data.getDdataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case STRING: {
                int i = 0;
                Object[] array = new Object[data.getSdataCount()];
                for (String val : data.getSdataList()) {
                    array[i++] = val;
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
            case SEQUENCE: 
            case STRUCTURE: {
                return GcdmConverterMa2.decodeArrayStructureData(data, new Section(shape));
            }
            case OPAQUE: {
                int i = 0;
                Object[] array = new Object[data.getBdataCount()];
                for (ByteString val : data.getBdataList()) {
                    array[i++] = ByteBuffer.wrap(val.toByteArray());
                }
                return Array.factory((DataType)dataType, (int[])shape, (Object)array);
            }
        }
        throw new IllegalStateException("Unkown datatype " + dataType);
    }

    public static Array decodeVlenData(GcdmNetcdfProto.Data data, Section section) {
        Preconditions.checkArgument((data.getVlenCount() > 0 ? 1 : 0) != 0);
        int[] shape = section.toBuilder().removeLast().build().getShape();
        int length = (int)Index.computeSize((int[])shape);
        Preconditions.checkArgument((length == data.getVlenCount() ? 1 : 0) != 0);
        Array[] storage = new Array[length];
        DataType dataType = GcdmConverterMa2.convertDataType(data.getDataType());
        int innerStart = 0;
        for (int index = 0; index < length; ++index) {
            int innerLength = 0;
            int innerEnd = innerStart + innerLength;
            int[] innerShape = new int[]{innerLength};
            switch (dataType) {
                case CHAR: {
                    byte[] array = data.getBdata(index).toByteArray();
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)IospHelper.convertByteToChar((byte[])array));
                    break;
                }
                case ENUM1: 
                case UBYTE: 
                case BYTE: {
                    byte[] array = data.getBdata(index).toByteArray();
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case SHORT: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new short[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getIdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case INT: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new int[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = data.getIdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case ENUM2: 
                case USHORT: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new short[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getUidata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case ENUM4: 
                case UINT: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new int[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = data.getUidata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case LONG: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new long[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getLdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case ULONG: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new long[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getUldata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case FLOAT: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new float[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getFdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case DOUBLE: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new double[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getDdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case STRING: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new Object[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        array[i++] = (short)data.getSdata(innerIndex);
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                case OPAQUE: {
                    int innerIndex;
                    int i = 0;
                    Object[] array = new Object[innerLength];
                    for (innerIndex = innerStart; innerIndex < innerEnd; ++innerIndex) {
                        ByteString val = data.getBdata(innerIndex);
                        array[i++] = (short)ByteBuffer.wrap(val.toByteArray());
                    }
                    storage[index] = Array.factory((DataType)dataType, (int[])innerShape, (Object)array);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unkown datatype " + dataType);
                }
            }
            innerStart = innerEnd;
        }
        return Array.makeVlenArray((int[])shape, (Array[])storage);
    }

    public static GcdmNetcdfProto.DataType convertDataType(DataType dtype) {
        switch (dtype) {
            case CHAR: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_CHAR;
            }
            case BYTE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_BYTE;
            }
            case SHORT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_SHORT;
            }
            case INT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_INT;
            }
            case LONG: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_LONG;
            }
            case FLOAT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_FLOAT;
            }
            case DOUBLE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_DOUBLE;
            }
            case STRING: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_STRING;
            }
            case STRUCTURE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_STRUCTURE;
            }
            case SEQUENCE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE;
            }
            case ENUM1: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM1;
            }
            case ENUM2: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM2;
            }
            case ENUM4: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ENUM4;
            }
            case OPAQUE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_OPAQUE;
            }
            case UBYTE: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_UBYTE;
            }
            case USHORT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_USHORT;
            }
            case UINT: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_UINT;
            }
            case ULONG: {
                return GcdmNetcdfProto.DataType.DATA_TYPE_ULONG;
            }
        }
        throw new IllegalStateException("illegal data type " + dtype);
    }

    public static DataType convertDataType(GcdmNetcdfProto.DataType dtype) {
        switch (dtype) {
            case DATA_TYPE_CHAR: {
                return DataType.CHAR;
            }
            case DATA_TYPE_BYTE: {
                return DataType.BYTE;
            }
            case DATA_TYPE_SHORT: {
                return DataType.SHORT;
            }
            case DATA_TYPE_INT: {
                return DataType.INT;
            }
            case DATA_TYPE_LONG: {
                return DataType.LONG;
            }
            case DATA_TYPE_FLOAT: {
                return DataType.FLOAT;
            }
            case DATA_TYPE_DOUBLE: {
                return DataType.DOUBLE;
            }
            case DATA_TYPE_STRING: {
                return DataType.STRING;
            }
            case DATA_TYPE_STRUCTURE: {
                return DataType.STRUCTURE;
            }
            case DATA_TYPE_SEQUENCE: {
                return DataType.SEQUENCE;
            }
            case DATA_TYPE_ENUM1: {
                return DataType.ENUM1;
            }
            case DATA_TYPE_ENUM2: {
                return DataType.ENUM2;
            }
            case DATA_TYPE_ENUM4: {
                return DataType.ENUM4;
            }
            case DATA_TYPE_OPAQUE: {
                return DataType.OPAQUE;
            }
            case DATA_TYPE_UBYTE: {
                return DataType.UBYTE;
            }
            case DATA_TYPE_USHORT: {
                return DataType.USHORT;
            }
            case DATA_TYPE_UINT: {
                return DataType.UINT;
            }
            case DATA_TYPE_ULONG: {
                return DataType.ULONG;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    public static ArrayStructure decodeArrayStructureData(GcdmNetcdfProto.Data arrayStructureProto, Section section) {
        int nrows = arrayStructureProto.getRowsCount();
        Preconditions.checkArgument((nrows > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((section.getSize() == (long)nrows ? 1 : 0) != 0);
        return null;
    }

    public static StructureData decodeStructureData(GcdmNetcdfProto.StructureDataProto structDataProto, StructureMembers members) {
        StructureDataW sdata = new StructureDataW(members);
        for (int i = 0; i < structDataProto.getMemberDataCount(); ++i) {
            GcdmNetcdfProto.Data data = structDataProto.getMemberData(i);
            StructureMembers.Member member = members.getMember(i);
            sdata.setMemberData(member, GcdmConverterMa2.decodeData(data, new Section(member.getShape())));
        }
        return sdata;
    }
}

