/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.client;

import com.google.common.base.Stopwatch;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGrpc;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Section;

public class GcdmClient {
    private static final Logger logger = LoggerFactory.getLogger(GcdmClient.class);
    private static final int MAX_MESSAGE = 99000000;
    private final GcdmGrpc.GcdmBlockingStub blockingStub;
    private static final String cdmUnitTestDir = "D:/testData/thredds-test-data/local/thredds-test-data/cdmUnitTest/";
    private static final String localFilename = "D:/testData/thredds-test-data/local/thredds-test-data/cdmUnitTest/formats/netcdf4/e562p1_fp.inst3_3d_asm_Nv.20100907_00z+20100909_1200z.nc4";

    public GcdmClient(Channel channel) {
        this.blockingStub = GcdmGrpc.newBlockingStub(channel);
    }

    private GcdmNetcdfProto.Header getHeader(String location) {
        System.out.printf("Header request %s%n", location);
        GcdmNetcdfProto.HeaderRequest request = GcdmNetcdfProto.HeaderRequest.newBuilder().setLocation(location).build();
        try {
            GcdmNetcdfProto.HeaderResponse response = this.blockingStub.getNetcdfHeader(request);
            return response.getHeader();
        }
        catch (StatusRuntimeException e) {
            logger.warn("getHeader failed: " + location, (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    private <T> Array<T> getData(String location, GcdmNetcdfProto.Variable v) {
        ArrayType dataType = GcdmConverter.convertDataType(v.getDataType());
        Section section = GcdmConverter.decodeSection(v);
        System.out.printf("Data request %s %s (%s)%n", new Object[]{v.getDataType(), v.getName(), section});
        if (dataType != ArrayType.DOUBLE && dataType != ArrayType.FLOAT) {
            System.out.printf("***skip%n", new Object[0]);
            return null;
        }
        GcdmNetcdfProto.DataRequest request = GcdmNetcdfProto.DataRequest.newBuilder().setLocation(location).setVariableSpec(v.getName()).build();
        try {
            Iterator<GcdmNetcdfProto.DataResponse> responses = ((GcdmGrpc.GcdmBlockingStub)this.blockingStub.withDeadlineAfter(30L, TimeUnit.SECONDS)).getNetcdfData(request);
            ArrayList results = new ArrayList();
            while (responses.hasNext()) {
                GcdmNetcdfProto.DataResponse response = responses.next();
                results.add(GcdmConverter.decodeData(response.getData()));
            }
            return Arrays.factoryCopy((ArrayType)dataType, (int[])section.getShape(), results);
        }
        catch (Throwable e) {
            logger.warn("getData failed: " + location, e);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String location = localFilename;
        String target = "localhost:16111";
        if (args.length > 0) {
            if ("--help".equals(args[0])) {
                System.err.printf("Usage: [name [target]]%n%n", new Object[0]);
                System.err.printf("  location Get Header for this location. Defaults to %s%n", location);
                System.err.printf("  target  The server to connect to. Defaults to %s%n", target);
                System.exit(1);
            }
            location = args[0];
        }
        if (args.length > 1) {
            target = args[1];
        }
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().enableFullStreamDecompression().maxInboundMessageSize(99000000).usePlaintext().build();
        try {
            Stopwatch stopwatchAll = Stopwatch.createStarted();
            GcdmClient client = new GcdmClient((Channel)channel);
            GcdmNetcdfProto.Header header = client.getHeader(location);
            long total = 0L;
            for (GcdmNetcdfProto.Variable v : header.getRoot().getVarsList()) {
                Stopwatch s2 = Stopwatch.createStarted();
                Array array = client.getData(location, v);
                s2.stop();
                if (array == null) continue;
                long size = array.length();
                double rate = (double)size / (double)s2.elapsed(TimeUnit.MICROSECONDS);
                System.out.printf("    size = %d, time = %s rate = %10.4f MB/sec%n", size, s2, rate);
                total += size;
            }
            stopwatchAll.stop();
            double rate = (double)total / (double)stopwatchAll.elapsed(TimeUnit.MICROSECONDS);
            System.out.printf("*** %d bytes took %s = %10.4f MB/sec%n", total, stopwatchAll, rate);
        }
        finally {
            channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
    }
}

