/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.ArrayType;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGridProto;
import ucar.gcdm.client.GcdmGridDataset;
import ucar.nc2.AttributeContainer;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.GridSubset;

public class GcdmGrid
implements Grid {
    private static final Logger log = LoggerFactory.getLogger(GcdmGrid.class);
    private final GcdmGridDataset gcdmGridDataset;
    private final GcdmGridProto.Grid proto;
    private final GridCoordinateSystem coordsys;

    public String getName() {
        return this.proto.getName();
    }

    public String getDescription() {
        return this.proto.getDescription();
    }

    public String getUnits() {
        return this.proto.getUnit();
    }

    public AttributeContainer attributes() {
        return GcdmConverter.decodeAttributes(this.getName(), this.proto.getAttributesList());
    }

    public ArrayType getArrayType() {
        return GcdmConverter.convertDataType(this.proto.getDataType());
    }

    public GridCoordinateSystem getCoordinateSystem() {
        return this.coordsys;
    }

    public boolean hasMissing() {
        return this.proto.getHasMissing();
    }

    public boolean isMissing(double val) {
        return Double.isNaN(val);
    }

    public GridReferencedArray readData(GridSubset subset) throws IOException {
        subset.setGridName(this.getName());
        return this.gcdmGridDataset.readData(subset);
    }

    private GcdmGrid(Builder builder, List<GridCoordinateSystem> coordsys) {
        this.gcdmGridDataset = builder.gcdmGridDataset;
        this.proto = builder.proto;
        Optional<GridCoordinateSystem> csopt = coordsys.stream().filter(cs -> cs.getName().equals(this.proto.getCoordSystem())).findFirst();
        if (!csopt.isPresent()) {
            throw new IllegalStateException("Cant find coordinate system " + this.proto.getCoordSystem());
        }
        this.coordsys = csopt.get();
    }

    public Builder toBuilder() {
        return this.addLocalFieldsToBuilder(GcdmGrid.builder());
    }

    private Builder addLocalFieldsToBuilder(Builder b) {
        return b.setProto(this.proto);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private GcdmGridDataset gcdmGridDataset;
        private GcdmGridProto.Grid proto;
        private boolean built;

        public Builder setDataset(GcdmGridDataset gcdmGridDataset) {
            this.gcdmGridDataset = gcdmGridDataset;
            return this;
        }

        public Builder setProto(GcdmGridProto.Grid proto) {
            this.proto = proto;
            return this;
        }

        public GcdmGrid build(List<GridCoordinateSystem> coordsys) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new GcdmGrid(this, coordsys);
        }
    }
}

