/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.server;

import com.google.common.base.Stopwatch;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.Section;
import ucar.array.StructureData;
import ucar.array.StructureDataArray;
import ucar.array.StructureMembers;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGridConverter;
import ucar.gcdm.GcdmGridProto;
import ucar.gcdm.GcdmGrpc;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedArraySectionSpec;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridDatasetFactory;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.util.Misc;
import ucar.nc2.write.ChunkingIndex;

public class GcdmServer {
    private static final Logger logger = LoggerFactory.getLogger(GcdmServer.class);
    private static final int MAX_MESSAGE = 50000000;
    private static final int SEQUENCE_CHUNK = 1000;
    private Server server;

    private void start() throws IOException {
        int port = 16111;
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)new GcdmImpl()).build().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.err.println("*** shutting down gRPC server since JVM is shutting down");
                try {
                    GcdmServer.this.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                System.err.println("*** server shut down");
            }
        });
        logger.info("Server started, listening on " + port);
        System.out.println("---> Server started, listening on " + port);
    }

    private void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Misc.showClassPath();
        GcdmServer server = new GcdmServer();
        server.start();
        server.blockUntilShutdown();
    }

    static class GcdmImpl
    extends GcdmGrpc.GcdmImplBase {
        GcdmImpl() {
        }

        @Override
        public void getNetcdfHeader(GcdmNetcdfProto.HeaderRequest req, StreamObserver<GcdmNetcdfProto.HeaderResponse> responseObserver) {
            System.out.printf("GcdmServer getHeader open %s%n", req.getLocation());
            GcdmNetcdfProto.HeaderResponse.Builder response = GcdmNetcdfProto.HeaderResponse.newBuilder();
            try (NetcdfFile ncfile = NetcdfDatasets.openFile((String)req.getLocation(), null);){
                GcdmNetcdfProto.Header.Builder header = GcdmNetcdfProto.Header.newBuilder().setLocation(req.getLocation()).setRoot(GcdmConverter.encodeGroup(ncfile.getRootGroup(), 100).build());
                response.setHeader(header);
                responseObserver.onNext((Object)response.build());
                responseObserver.onCompleted();
                logger.info("GcdmServer getHeader " + req.getLocation());
            }
            catch (Throwable t) {
                logger.warn("GcdmServer getHeader failed ", t);
                t.printStackTrace();
                response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(t.getMessage()).build());
            }
        }

        @Override
        public void getNetcdfData(GcdmNetcdfProto.DataRequest req, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) {
            System.out.printf("GcdmServer getData %s %s%n", req.getLocation(), req.getVariableSpec());
            Stopwatch stopwatch = Stopwatch.createStarted();
            long size = -1L;
            try (NetcdfFile ncfile = NetcdfDatasets.openFile((String)req.getLocation(), null);){
                ParsedArraySectionSpec varSection = ParsedArraySectionSpec.parseVariableSection((NetcdfFile)ncfile, (String)req.getVariableSpec());
                Variable var = varSection.getVariable();
                if (var instanceof Sequence) {
                    size = this.getSequenceData(ncfile, varSection, responseObserver);
                } else {
                    Section wantSection = varSection.getArraySection();
                    size = (long)var.getElementSize() * wantSection.computeSize();
                    this.getNetcdfData(ncfile, varSection, responseObserver);
                }
                responseObserver.onCompleted();
                logger.info("GcdmServer getData " + req.getLocation());
            }
            catch (Throwable t) {
                logger.warn("GcdmServer getData failed ", t);
                t.printStackTrace();
                GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(req.getLocation()).setVariableSpec(req.getVariableSpec());
                response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(t.getMessage() == null ? "N/A" : t.getMessage()).build());
                responseObserver.onNext((Object)response.build());
            }
            System.out.printf(" ** size=%d took=%s%n", size, stopwatch.stop());
        }

        private void getNetcdfData(NetcdfFile ncfile, ParsedArraySectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            Variable var = varSection.getVariable();
            Section wantSection = varSection.getArraySection();
            long size = (long)var.getElementSize() * wantSection.computeSize();
            if (size > 50000000L) {
                this.getDataInChunks(ncfile, varSection, responseObserver);
            } else {
                this.getOneChunk(ncfile, varSection, responseObserver);
            }
        }

        private void getDataInChunks(NetcdfFile ncfile, ParsedArraySectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            Variable var = varSection.getVariable();
            long maxChunkElems = 50000000 / var.getElementSize();
            ChunkingIndex index = new ChunkingIndex(var.getShape());
            while ((long)index.currentElement() < index.getSize()) {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                Section section = new Section(chunkOrigin, chunkShape);
                ParsedArraySectionSpec spec = new ParsedArraySectionSpec(var, section);
                this.getOneChunk(ncfile, spec, responseObserver);
                index.setCurrentCounter(index.currentElement() + (int)Arrays.computeSize((int[])chunkShape));
            }
        }

        private void getOneChunk(NetcdfFile ncfile, ParsedArraySectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws IOException, InvalidRangeException {
            String spec = varSection.makeSectionSpecString();
            Variable var = varSection.getVariable();
            Section wantSection = varSection.getArraySection();
            GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(ncfile.getLocation()).setVariableSpec(spec).setVarFullName(var.getFullName()).setSection(GcdmConverter.encodeSection(wantSection));
            Array data = var.readArray(wantSection);
            response.setData(GcdmConverter.encodeData(data.getArrayType(), data));
            responseObserver.onNext((Object)response.build());
            System.out.printf(" Send one chunk %s size=%d bytes%n", spec, data.length() * (long)varSection.getVariable().getElementSize());
        }

        private long getSequenceData(NetcdfFile ncfile, ParsedArraySectionSpec varSection, StreamObserver<GcdmNetcdfProto.DataResponse> responseObserver) throws InvalidRangeException {
            String spec = varSection.makeSectionSpecString();
            Sequence seq = (Sequence)varSection.getVariable();
            StructureMembers.Builder membersb = seq.makeStructureMembersBuilder();
            membersb.setStandardOffsets(false);
            StructureMembers members = membersb.build();
            StructureData[] sdata = new StructureData[1000];
            int start = 0;
            int count = 0;
            Iterator it = seq.iterator();
            while (it.hasNext()) {
                sdata[count++] = (StructureData)it.next();
                if (count < 1000 && it.hasNext()) continue;
                StructureDataArray sdataArray = new StructureDataArray(members, new int[]{count}, sdata);
                Section section = Section.builder().appendRange(start, start + count).build();
                GcdmNetcdfProto.DataResponse.Builder response = GcdmNetcdfProto.DataResponse.newBuilder().setLocation(ncfile.getLocation()).setVariableSpec(spec).setVarFullName(seq.getFullName()).setSection(GcdmConverter.encodeSection(section));
                response.setData(GcdmConverter.encodeData(ArrayType.SEQUENCE, sdataArray));
                responseObserver.onNext((Object)response.build());
                start = count;
                count = 0;
            }
            return (start + count) * members.getStorageSizeBytes();
        }

        @Override
        public void getGridDataset(GcdmGridProto.GridDatasetRequest request, StreamObserver<GcdmGridProto.GridDatasetResponse> responseObserver) {
            System.out.printf("GcdmServer getGridDataset open %s%n", request.getLocation());
            GcdmGridProto.GridDatasetResponse.Builder response = GcdmGridProto.GridDatasetResponse.newBuilder();
            Formatter errlog = new Formatter();
            try (GridDataset gridDataset = GridDatasetFactory.openGridDataset((String)request.getLocation(), (Formatter)errlog);){
                response.setDataset(GcdmGridConverter.encodeDataset(gridDataset));
                responseObserver.onNext((Object)response.build());
                responseObserver.onCompleted();
                logger.info("GcdmServer getGridDataset " + request.getLocation());
            }
            catch (Throwable t) {
                System.out.printf("GcdmServer getGridDataset failed %s %n%s%n", t.getMessage(), errlog);
                logger.warn("GcdmServer getGridDataset failed ", t);
                t.printStackTrace();
                response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(t.getMessage()).build());
            }
        }

        @Override
        public void getGridData(GcdmGridProto.GridDataRequest request, StreamObserver<GcdmGridProto.GridDataResponse> responseObserver) {
            System.out.printf("GcdmServer getData %s %s%n", request.getLocation(), request.getSubsetMap());
            GcdmGridProto.GridDataResponse.Builder response = GcdmGridProto.GridDataResponse.newBuilder();
            response.setLocation(request.getLocation()).putAllSubset(request.getSubsetMap());
            Stopwatch stopwatch = Stopwatch.createStarted();
            GridSubset gridSubset = new GridSubset(request.getSubsetMap());
            if (gridSubset.getGridName() == null) {
                this.makeError(response, "GridName is not set");
                responseObserver.onNext((Object)response.build());
                return;
            }
            Formatter errlog = new Formatter();
            try (GridDataset gridDataset = GridDatasetFactory.openGridDataset((String)request.getLocation(), (Formatter)errlog);){
                if (gridDataset == null) {
                    this.makeError(response, String.format("GridDataset '%s' not found", request.getLocation()));
                } else {
                    String wantGridName = gridSubset.getGridName();
                    Grid wantGrid = gridDataset.findGrid(wantGridName).orElse(null);
                    if (wantGrid == null) {
                        this.makeError(response, String.format("GridDataset '%s' does not have Grid '%s", request.getLocation(), wantGridName));
                    } else {
                        GridReferencedArray geoReferencedArray = wantGrid.readData(gridSubset);
                        response.setData(GcdmGridConverter.encodeGridReferencedArray(geoReferencedArray));
                        System.out.printf(" ** size=%d shape=%s%n", geoReferencedArray.data().length(), java.util.Arrays.toString(geoReferencedArray.data().getShape()));
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("GcdmServer getGridData failed ", t);
                t.printStackTrace();
                errlog.format("%n%s", t.getMessage() == null ? "" : t.getMessage());
                this.makeError(response, errlog.toString());
            }
            responseObserver.onNext((Object)response.build());
            System.out.printf(" ** took=%s%n", stopwatch.stop());
        }

        void makeError(GcdmGridProto.GridDataResponse.Builder response, String message) {
            response.setError(GcdmNetcdfProto.Error.newBuilder().setMessage(message).build());
        }
    }

    static class MyServerInterceptor
    implements ServerInterceptor {
        MyServerInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
            System.out.printf("***ServerCall %s%n", call);
            System.out.printf("   Attributes %s%n", call.getAttributes());
            System.out.printf("   MethodDesc %s%n", call.getMethodDescriptor());
            System.out.printf("   Authority %s%n", call.getAuthority());
            System.out.printf("   Metadata %s%n", requestHeaders);
            return next.startCall(call, requestHeaders);
        }
    }
}

