/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.client;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.gcdm.GcdmConverter;
import ucar.gcdm.GcdmGridConverter;
import ucar.gcdm.GcdmGridProto;
import ucar.gcdm.GcdmGrpc;
import ucar.gcdm.client.GcdmGrid;
import ucar.gcdm.client.GcdmVerticalTransform;
import ucar.nc2.AttributeContainer;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.GridSubset;

public class GcdmGridDataset
implements GridDataset {
    private static final Logger log = LoggerFactory.getLogger(GcdmGridDataset.class);
    private static final int MAX_DATA_WAIT_SECONDS = 30;
    private static final int MAX_MESSAGE = 101000000;
    private final String remoteURI;
    private final String path;
    private final ManagedChannel channel;
    private final GcdmGrpc.GcdmBlockingStub blockingStub;
    private final GcdmGridProto.GridDataset proto;
    private final ImmutableList<GridAxis<?>> axes;
    private final ImmutableList<GridCoordinateSystem> coordsys;
    private final ImmutableList<Grid> grids;

    public String getName() {
        return this.proto.getName();
    }

    public String getLocation() {
        return this.proto.getLocation();
    }

    public AttributeContainer attributes() {
        return GcdmConverter.decodeAttributes(this.getName(), this.proto.getAttributesList());
    }

    public FeatureType getFeatureType() {
        return GcdmGridConverter.convertFeatureType(this.proto.getFeatureType());
    }

    public ImmutableList<GridCoordinateSystem> getGridCoordinateSystems() {
        return this.coordsys;
    }

    public ImmutableList<GridAxis<?>> getGridAxes() {
        return this.axes;
    }

    public ImmutableList<Grid> getGrids() {
        return this.grids;
    }

    public void close() {
        try {
            this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            log.warn("GcdmGridDataset shutdown interrupted");
        }
    }

    GridReferencedArray readData(GridSubset subset) throws IOException {
        GridReferencedArray result;
        log.info("GcdmGridDataset request data subset " + subset);
        GcdmGridProto.GridDataRequest.Builder requestb = GcdmGridProto.GridDataRequest.newBuilder().setLocation(this.path);
        for (Map.Entry entry : subset.getEntries()) {
            requestb.putSubset((String)entry.getKey(), entry.getValue().toString());
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        long size = 0L;
        ArrayList<GridReferencedArray> results = new ArrayList<GridReferencedArray>();
        try {
            Iterator<GcdmGridProto.GridDataResponse> responses = ((GcdmGrpc.GcdmBlockingStub)this.blockingStub.withDeadlineAfter(30L, TimeUnit.SECONDS)).getGridData(requestb.build());
            GcdmGridProto.GridDataResponse response = responses.next();
            if (response.hasError()) {
                throw new IOException(response.getError().getMessage());
            }
            Formatter errlog = new Formatter();
            result = GcdmGridConverter.decodeGridReferencedArray(response.getData(), errlog);
            results.add(result);
        }
        catch (StatusRuntimeException e) {
            log.warn("readSection requestData failed failed: ", (Throwable)e);
            throw new IOException(e);
        }
        catch (Throwable t) {
            System.out.printf(" ** failed after %s%n", stopwatch);
            log.warn("readSection requestData failed failed: ", t);
            throw new IOException(t);
        }
        System.out.printf(" ** size=%d took=%s%n", size += result.data().length(), stopwatch.stop());
        if (results.size() == 1) {
            return (GridReferencedArray)results.get(0);
        }
        throw new UnsupportedOperationException("multiple responses not supported");
    }

    Array<Number> getVerticalTransform(int id, String name, int timeIndex) {
        log.info("GcdmGridDataset request getVerticalTransform {} {} {}", new Object[]{id, name, timeIndex});
        Stopwatch stopwatch = Stopwatch.createStarted();
        GcdmGridProto.VerticalTransformRequest request = GcdmGridProto.VerticalTransformRequest.newBuilder().setId(id).setLocation(this.path).setVerticalTransform(name).setTimeIndex(timeIndex).build();
        GcdmGridProto.VerticalTransformResponse response = this.blockingStub.getVerticalTransform(request);
        if (response.hasError()) {
            throw new RuntimeException(response.getError().getMessage());
        }
        log.info("GcdmGridDataset request getVerticalTransform took {}", (Object)stopwatch.stop().elapsed());
        return GcdmConverter.decodeData(response.getData3D());
    }

    private GcdmGridDataset(Builder builder) {
        this.remoteURI = builder.remoteURI;
        this.path = builder.path;
        this.channel = builder.channel;
        this.blockingStub = builder.blockingStub;
        this.proto = builder.proto;
        this.axes = ImmutableList.copyOf(builder.axes);
        this.coordsys = ImmutableList.copyOf(builder.coordsys);
        ImmutableList.Builder gridsb = ImmutableList.builder();
        for (GcdmGrid.Builder b : builder.grids) {
            gridsb.add((Object)b.setDataset(this).build((List<GridCoordinateSystem>)this.coordsys));
        }
        this.grids = gridsb.build();
        for (GcdmVerticalTransform vt : builder.vts) {
            vt.setDataset(this);
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        this.toString(f);
        return f.toString();
    }

    public Builder toBuilder() {
        return this.addLocalFieldsToBuilder(GcdmGridDataset.builder());
    }

    private Builder addLocalFieldsToBuilder(Builder b) {
        b.setRemoteURI(this.remoteURI);
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String remoteURI;
        private ManagedChannel channel;
        private GcdmGrpc.GcdmBlockingStub blockingStub;
        private String path;
        private GcdmGridProto.GridDataset proto;
        public final ArrayList<GridAxis<?>> axes = new ArrayList();
        private final ArrayList<GridCoordinateSystem> coordsys = new ArrayList();
        private final ArrayList<GcdmGrid.Builder> grids = new ArrayList();
        public final ArrayList<GcdmVerticalTransform> vts = new ArrayList();
        private boolean built;

        public Builder setRemoteURI(String remoteURI) {
            this.remoteURI = remoteURI;
            return this;
        }

        public Builder addGridAxis(GridAxis<?> axis) {
            this.axes.add(axis);
            return this;
        }

        public Builder addCoordSys(GridCoordinateSystem sys) {
            this.coordsys.add(sys);
            return this;
        }

        public Builder addGrid(GcdmGrid.Builder grid) {
            this.grids.add(grid);
            return this;
        }

        public Builder addVerticalTransform(GcdmVerticalTransform vtb) {
            this.vts.add(vtb);
            return this;
        }

        public Builder setProto(GcdmGridProto.GridDataset proto) {
            this.proto = proto;
            return this;
        }

        public GcdmGridDataset build(boolean open) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            if (open) {
                this.openChannel();
            }
            return new GcdmGridDataset(this);
        }

        private void openChannel() {
            URI uri = URI.create(this.remoteURI);
            String target = uri.getAuthority();
            this.path = uri.getPath();
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            this.channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().enableFullStreamDecompression().maxInboundMessageSize(101000000).build();
            Formatter errlog = new Formatter();
            try {
                this.blockingStub = GcdmGrpc.newBlockingStub((Channel)this.channel);
                this.readDataset(errlog);
            }
            catch (Exception e) {
                try {
                    this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Shutdown interrupted ", (Throwable)e);
                }
                e.printStackTrace();
                System.out.printf("%nerrlog = %s%n", errlog);
                throw new RuntimeException("Cant open Gcdm url " + this.remoteURI, e);
            }
        }

        private void readDataset(Formatter errlog) {
            log.info("GcdmGridDataset request header for " + this.path);
            GcdmGridProto.GridDatasetRequest request = GcdmGridProto.GridDatasetRequest.newBuilder().setLocation(this.path).build();
            GcdmGridProto.GridDatasetResponse response = this.blockingStub.getGridDataset(request);
            if (response.hasError()) {
                throw new RuntimeException(response.getError().getMessage());
            }
            this.proto = response.getDataset();
            GcdmGridConverter.decodeGridDataset(this.proto, this, errlog);
        }
    }
}

