/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm.client;

import java.io.IOException;
import javax.annotation.Nullable;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.Range;
import ucar.gcdm.client.GcdmGridDataset;
import ucar.nc2.geoloc.vertical.VerticalTransform;

public class GcdmVerticalTransform
implements VerticalTransform {
    private GcdmGridDataset gridDataset;
    private final int id;
    private final String name;
    private final String ctvName;
    private final String units;

    public GcdmVerticalTransform(int id, String name, String ctvName, String units) {
        this.id = id;
        this.name = name;
        this.ctvName = ctvName;
        this.units = units;
    }

    void setDataset(GcdmGridDataset gridDataset) {
        this.gridDataset = gridDataset;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCtvName() {
        return this.ctvName;
    }

    @Nullable
    public String getUnitString() {
        return this.units;
    }

    public Array<Number> getCoordinateArray3D(int timeIndex) throws IOException, InvalidRangeException {
        return this.gridDataset.getVerticalTransform(this.id, this.name, timeIndex);
    }

    public Array<Number> getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array<Number> array3D = this.getCoordinateArray3D(timeIndex);
        int nz = array3D.getShape()[0];
        double[] result = new double[nz];
        int count = 0;
        int z = 0;
        while (z < nz) {
            result[count++] = ((Number)array3D.get(new int[]{z++, yIndex, xIndex})).doubleValue();
        }
        return Arrays.factory((ArrayType)ArrayType.DOUBLE, (int[])new int[]{nz}, (Object)result);
    }

    public VerticalTransform subset(Range t_range, Range z_range, Range y_range, Range x_range) {
        return null;
    }
}

