/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFcFmrc;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import thredds.inventory.DatasetCollectionMFiles;
import thredds.inventory.FeatureCollectionConfig;
import thredds.inventory.TimePartitionCollection;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.TimePartitionBuilder;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Iosp;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFcFmrc.class);
    private static final String COLLECTION = "collection";
    private final FeatureCollectionConfig.GribConfig gribConfig;
    private final AtomicBoolean needsUpdate = new AtomicBoolean();
    private final AtomicBoolean needsProto = new AtomicBoolean();

    public InvDatasetFcGrib(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        super(parent, name, path, featureType, config);
        Formatter errlog = new Formatter();
        if (config.useIndexOnly) {
            this.dcm = TimePartitionCollection.fromExistingIndices((FeatureCollectionConfig)config, (Formatter)errlog);
        } else if (config.timePartition != null) {
            this.dcm = TimePartitionCollection.factory((FeatureCollectionConfig)config, (Formatter)errlog);
        } else {
            this.dcm = new DatasetCollectionMFiles(config, errlog);
            this.dcm.setChangeChecker(Grib2Index.getChangeChecker());
        }
        String errs = errlog.toString();
        if (errs.length() > 0) {
            logger.debug("DatasetCollectionManager parse error = {} ", (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        this.finish();
        this.gribConfig = config.gribConfig;
    }

    private void init(StateGrib localState) {
        try {
            if (this.config.timePartition != null) {
                TimePartition previous = localState.timePartition;
                localState.timePartition = TimePartitionBuilder.factory((TimePartitionCollection)this.dcm, this.config.updateConfig.force, new Formatter());
                localState.gribCollection = null;
                if (previous != null) {
                    previous.close();
                }
            } else {
                GribCollection previous = localState.gribCollection;
                localState.gribCollection = Grib2CollectionBuilder.factory(this.dcm, this.config.updateConfig.force, new Formatter());
                localState.timePartition = null;
                if (previous != null) {
                    previous.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("Cant init " + this.dcm, (Throwable)e);
        }
        logger.info("Collection was recreated=" + this.getName());
    }

    public void update() {
        this.needsUpdate.set(true);
    }

    public void updateProto() {
        this.needsProto.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateGrib checkState() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                this.firstInit();
            } else if (!this.needsUpdate.get()) {
                return (StateGrib)this.state;
            }
            StateGrib localState = new StateGrib((StateGrib)this.state);
            this.init(localState);
            this.makeTopDatasets(localState);
            localState.lastInvChange = System.currentTimeMillis();
            this.needsUpdate.set(false);
            this.needsProto.set(false);
            this.state = localState;
            return localState;
        }
    }

    public InvCatalogImpl makeCatalog(String match, String orgPath, URI baseURI) {
        logger.debug("FcGrib make catalog for " + match + " " + baseURI);
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                InvCatalogImpl main = this.makeCatalogTop(baseURI, localState);
                main.addService(this.virtualService);
                main.getDataset().getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
                main.finish();
                return main;
            }
            if (localState.timePartition == null) {
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                GribCollection.GroupHcs group = localState.gribCollection.findGroup(path[0]);
                if (group != null) {
                    return this.makeFilesCatalog(localState.gribCollection, group, baseURI, localState);
                }
            } else {
                if (match.equals(COLLECTION)) {
                    return this.makeGribCollectionCatalog(localState.timePartition, baseURI, localState);
                }
                TimePartition.Partition dc = localState.timePartition.getCollection(match);
                if (dc != null) {
                    return this.makeGribCollectionCatalog(dc.getGribCollection(), baseURI, localState);
                }
                String[] path = match.split("/");
                if (path.length < 2) {
                    return null;
                }
                dc = localState.timePartition.getCollection(path[0]);
                if (dc != null) {
                    GribCollection gc = dc.getGribCollection();
                    GribCollection.GroupHcs group = gc.findGroup(path[1]);
                    if (group == null) {
                        return null;
                    }
                    return this.makeFilesCatalog(gc, group, baseURI, localState);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error making catalog for " + this.path, (Throwable)e);
        }
        return null;
    }

    private void makeTopDatasets(StateGrib localState) {
        ArrayList<Object> datasets = new ArrayList<Object>();
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        if (localState.timePartition == null) {
            for (GribCollection.GroupHcs group : localState.gribCollection.getGroups()) {
                String name = group.getGroupName();
                InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, name);
                name = StringUtil2.replace((String)name, (char)' ', (String)"_");
                ds.setUrlPath(this.path + "/" + name);
                ds.setID(id + "/" + name);
                this.addFileDatasets(ds, name);
                ds.tmi.addVariables(this.extractThreddsVariables(localState.gribCollection, group));
                ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
                CalendarDateRange cdr = this.extractCalendarDateRange(group);
                if (cdr != null) {
                    ds.tmi.setTimeCoverage(cdr);
                }
                ds.finish();
                datasets.add(ds);
            }
        } else {
            InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, COLLECTION, this.getCatalogHref(COLLECTION));
            ds.setUrlPath(this.path + "/" + COLLECTION);
            ds.setID(id + "/" + COLLECTION);
            ds.finish();
            datasets.add(ds);
            for (TimePartition.Partition dc : localState.timePartition.getPartitions()) {
                String dname = dc.getName();
                ds = new InvCatalogRef((InvDatasetImpl)this, dname, this.getCatalogHref(dname));
                dname = StringUtil2.replace((String)dname, (char)' ', (String)"_");
                ds.setUrlPath(this.path + "/" + dname);
                ds.setID(id + "/" + dname);
                ds.finish();
                datasets.add(ds);
            }
        }
        localState.datasets = datasets;
        this.datasets = datasets;
        this.finish();
    }

    private ThreddsMetadata.Variables extractThreddsVariables(GribCollection gribCollection, GribCollection.GroupHcs group) {
        ThreddsMetadata.Variables vars = new ThreddsMetadata.Variables(DataFormatType.GRIB2.toString());
        for (GribCollection.VariableIndex vindex : group.varIndex) {
            String paramCategory;
            ThreddsMetadata.Variable tv = new ThreddsMetadata.Variable();
            VertCoord vc = vindex.vertIdx < 0 ? null : group.vertCoords.get(vindex.vertIdx);
            Grib2Tables tables = Grib2Tables.factory(gribCollection.getCenter(), gribCollection.getSubcenter(), gribCollection.getMaster(), gribCollection.getLocal());
            tv.setName(Grib2Iosp.makeVariableName(tables, gribCollection, vindex));
            tv.setDescription(Grib2Iosp.makeVariableLongName(tables, vindex));
            tv.setUnits(Grib2Iosp.makeVariableUnits(tables, vindex));
            tv.setVocabularyId("2-" + vindex.discipline + "-" + vindex.category + "-" + vindex.parameter);
            String paramDisc = tables.getTableValue("0.0", vindex.discipline);
            if (paramDisc == null) {
                paramDisc = "Unknown";
            }
            if ((paramCategory = tables.getTableValue("4.1." + vindex.discipline, vindex.category)) == null) {
                paramCategory = "Unknown";
            }
            String paramName = tables.getVariableName(vindex.discipline, vindex.category, vindex.parameter);
            tv.setVocabularyName(paramDisc + " / " + paramCategory + " / " + paramName);
            vars.addVariable(tv);
        }
        vars.sort();
        return vars;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollection.GroupHcs group) {
        GdsHorizCoordSys gdsCoordSys = group.hcs;
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox((Projection)gdsCoordSys.proj, (double)gdsCoordSys.getStartX(), (double)gdsCoordSys.getStartY(), (double)gdsCoordSys.getEndX(), (double)gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (group.hcs.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(GribCollection.GroupHcs group) {
        TimeCoord max = null;
        for (TimeCoord tc : group.timeCoords) {
            if (tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
            max = tc;
        }
        if (max == null) {
            for (TimeCoord tc : group.timeCoords) {
                if (!tc.isInterval() || max != null && max.getSize() >= tc.getSize()) continue;
                max = tc;
            }
        }
        return max == null ? null : max.getCalendarRange();
    }

    private InvCatalogImpl makeGribCollectionCatalog(GribCollection gribCollection, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String collectionName = gribCollection.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(collectionName));
        InvCatalogImpl partCatalog = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName(collectionName);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        partCatalog.addDataset(top);
        partCatalog.addService(this.virtualService);
        top.getLocalMetadataInheritable().setServiceName(this.virtualService.getName());
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (GribCollection.GroupHcs group : gribCollection.getGroups()) {
            String name = group.getGroupName();
            InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, name + "_" + COLLECTION);
            name = StringUtil2.replace((String)name, (char)' ', (String)"_");
            ds.setUrlPath(this.path + "/" + collectionName + "/" + name);
            ds.setID(id + "/" + collectionName + "/" + name);
            ds.tmi.addVariables(this.extractThreddsVariables(gribCollection, group));
            ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
            CalendarDateRange cdr = this.extractCalendarDateRange(group);
            if (cdr != null) {
                ds.tmi.setTimeCoverage(cdr);
            }
            if (!(gribCollection instanceof TimePartition)) {
                this.addFileDatasets(ds, collectionName + "/" + name);
            }
            ds.finish();
            top.addDataset(ds);
        }
        partCatalog.finish();
        return partCatalog;
    }

    private void addFileDatasets(InvDatasetImpl parent, String prefix) {
        String name = prefix + "/" + "files";
        InvCatalogRef ds = new InvCatalogRef((InvDatasetImpl)this, "files", this.getCatalogHref(name));
        ds.finish();
        parent.addDataset((InvDatasetImpl)ds);
    }

    private InvCatalogImpl makeFilesCatalog(GribCollection gc, GribCollection.GroupHcs group, URI baseURI, InvDatasetFeatureCollection.State localState) throws IOException {
        String collectionName = gc.getName();
        InvCatalogImpl parent = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getCatalogHref(collectionName));
        InvCatalogImpl result = new InvCatalogImpl(this.getFullName(), parent.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl((InvDatasetImpl)this);
        top.setParent(null);
        top.transferMetadata((InvDatasetImpl)this.getParent(), true);
        top.setName("files");
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        result.addDataset(top);
        result.addService(this.orgService);
        top.getLocalMetadataInheritable().setServiceName(this.orgService.getName());
        String id = this.getID();
        if (id == null) {
            id = this.getPath();
        }
        for (String f : group.getFilenames()) {
            int pos = f.lastIndexOf("/");
            String fname = f.substring(pos + 1);
            String path = collectionName + "/" + group.getGroupName() + "/" + fname;
            InvDatasetImpl ds = new InvDatasetImpl((InvDataset)this, fname);
            ds.setUrlPath(this.path + "/" + path);
            ds.setID(id + "/" + path);
            File file = new File(f);
            ds.tm.setDataSize((double)file.length());
            ds.finish();
            top.addDataset(ds);
        }
        result.finish();
        return result;
    }

    public GridDataset getGridDataset(String matchPath) throws IOException {
        String filename;
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        String string = filename = paths.length == 2 ? paths[1] : null;
        if (localState.timePartition == null) {
            return localState.gribCollection.getGridDataset(paths[0], filename);
        }
        if (paths.length < 2) {
            return null;
        }
        if (paths[0].equals(localState.timePartition.getName())) {
            return localState.timePartition.getGridDataset(paths[1]);
        }
        TimePartition.Partition dcm = localState.timePartition.getCollection(paths[0]);
        if (dcm != null) {
            return dcm.getGribCollection().getGridDataset(paths[1], filename);
        }
        return null;
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        StateGrib localState = null;
        try {
            localState = this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
            return null;
        }
        if (matchPath == null || matchPath.length() == 0) {
            return null;
        }
        String[] paths = matchPath.split("/");
        if (paths.length < 1) {
            return null;
        }
        if (localState.timePartition == null) {
            int n = paths.length;
            if (n >= 2) {
                String group = paths[n - 2];
                String filename = paths[n - 1];
                return localState.gribCollection.getNetcdfDataset(group, filename);
            }
            return localState.gribCollection.getNetcdfDataset(paths[0], null);
        }
        if (paths.length < 2) {
            return null;
        }
        if (paths[0].equals(localState.timePartition.getName())) {
            return localState.timePartition.getNetcdfDataset(paths[1]);
        }
        TimePartition.Partition dcm = localState.timePartition.getCollection(paths[0]);
        if (dcm != null) {
            String filename = paths.length > 2 ? paths[2] : null;
            return dcm.getGribCollection().getNetcdfDataset(paths[1], filename);
        }
        return null;
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        TimePartition timePartition;
        GribCollection gribCollection;

        protected StateGrib(StateGrib from) {
            super((InvDatasetFeatureCollection)InvDatasetFcGrib.this, (InvDatasetFeatureCollection.State)from);
            if (from != null) {
                this.timePartition = from.timePartition;
                this.gribCollection = from.gribCollection;
            }
        }
    }
}

