/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import thredds.inventory.CollectionManager;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.unidata.io.RandomAccessFile;

public abstract class GribIndex {
    public static final String IDX_EXT = ".gbx9";
    public static final boolean debug = false;

    public GribCollection makeCollection(RandomAccessFile raf, CollectionManager.Force force, Formatter f, int edition) throws IOException {
        boolean readOk;
        boolean write = false;
        boolean rewrite = false;
        String filename = raf.getLocation();
        File dataFile = new File(filename);
        try {
            readOk = this.readIndex(filename, dataFile.lastModified(), force);
        }
        catch (IOException ioe) {
            readOk = false;
        }
        if (!readOk) {
            this.makeIndex(filename, f);
            f.format("  Index written: %s%n", filename + IDX_EXT);
        }
        if (edition == 1) {
            return Grib1CollectionBuilder.createFromSingleFile(dataFile, f);
        }
        return Grib2CollectionBuilder.createFromSingleFile(dataFile, f);
    }

    public abstract boolean readIndex(String var1, long var2, CollectionManager.Force var4) throws IOException;

    public abstract boolean makeIndex(String var1, Formatter var2) throws IOException;
}

