/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.unidata.util.StringUtil2;

public class GribUtils {
    public static String cleanupUnits(String unit) {
        if (unit == null) {
            return null;
        }
        if (unit.equalsIgnoreCase("-")) {
            unit = "";
        } else {
            if (unit.startsWith("/")) {
                unit = "1" + unit;
            }
            unit = unit.trim();
            unit = StringUtil2.remove((String)unit, (String)"**");
            StringBuilder sb = new StringBuilder(unit);
            StringUtil2.remove((StringBuilder)sb, (String)"^[]");
            StringUtil2.substitute((StringBuilder)sb, (String)" / ", (String)"/");
            StringUtil2.replace((StringBuilder)sb, (char)' ', (String)".");
            StringUtil2.replace((StringBuilder)sb, (char)'*', (String)".");
            unit = sb.toString();
        }
        return unit;
    }

    public static String cleanupDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.remove((StringBuilder)sb, (String)".;,=[]()/");
        return sb.toString().trim();
    }

    public static String makeNameFromDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.remove((StringBuilder)sb, (String)".;,=[]()/");
        StringUtil2.replace((StringBuilder)sb, (char)' ', (String)"_");
        return sb.toString();
    }
}

