/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class TimeCoord {
    private CalendarDate runDate;
    private CalendarPeriod timeUnit;
    protected List<Integer> coords;
    protected List<Tinv> intervals;
    private String units;
    private int code = -1;

    public static int getOffset(CalendarDate refDate, CalendarDate cd, CalendarPeriod timeUnit) {
        long msecs = cd.getDifferenceInMsecs(refDate);
        return (int)Math.round((double)msecs / timeUnit.getValueInMillisecs());
    }

    public TimeCoord(int code, String units, List coords) {
        Object atom;
        this.code = code;
        this.units = units;
        CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)units);
        this.runDate = cdu.getBaseCalendarDate();
        this.timeUnit = cdu.getTimeUnit();
        Object v0 = atom = coords.size() > 0 ? coords.get(0) : null;
        if (atom instanceof Tinv) {
            this.coords = null;
            this.intervals = coords;
        } else {
            this.coords = coords;
            this.intervals = null;
        }
    }

    public TimeCoord(CalendarDate runDate, CalendarPeriod timeUnit, List coords) {
        Object atom;
        this.runDate = runDate;
        this.timeUnit = timeUnit;
        Object v0 = atom = coords == null || coords.size() == 0 ? null : coords.get(0);
        if (atom instanceof CalendarDate) {
            ArrayList<Integer> offsets = new ArrayList<Integer>(coords.size());
            double duration = timeUnit.getValueInMillisecs();
            for (Object coord : coords) {
                CalendarDate cd = (CalendarDate)coord;
                long msecs = cd.getDifferenceInMsecs(runDate);
                int val = (int)Math.round((double)msecs / duration);
                offsets.add(val);
            }
            this.coords = offsets;
            this.intervals = null;
        } else if (atom instanceof Tinv) {
            this.intervals = coords;
            this.coords = null;
        } else {
            this.coords = coords;
            this.intervals = null;
        }
    }

    public CalendarDate getRunDate() {
        return this.runDate;
    }

    public CalendarDateRange getCalendarRange() {
        CalendarDate rd = this.getRunDate();
        if (this.coords != null) {
            CalendarDate start = rd.add(this.timeUnit.multiply(this.coords.get(0).intValue()));
            CalendarDate end = rd.add(this.timeUnit.multiply(this.coords.get(this.coords.size() - 1).intValue()));
            return CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
        }
        CalendarDate start = rd.add(this.timeUnit.multiply(this.intervals.get(0).b1));
        CalendarDate end = rd.add(this.timeUnit.multiply(this.intervals.get(this.intervals.size() - 1).b2));
        return CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
    }

    public boolean isInterval() {
        return this.intervals != null;
    }

    public List<Integer> getCoords() {
        return this.coords;
    }

    public List<Tinv> getIntervals() {
        return this.intervals;
    }

    public String getUnits() {
        if (this.units != null) {
            return this.units;
        }
        return this.timeUnit.getField().toString() + " since " + this.runDate;
    }

    public double getTimeUnitScale() {
        return this.timeUnit.getValue();
    }

    public CalendarPeriod getTimeUnit() {
        return this.timeUnit;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.code == 0 ? "time" : "time" + this.code;
    }

    public String getType() {
        return this.isInterval() ? "interval" : "integers";
    }

    public int getSize() {
        return this.isInterval() ? this.intervals.size() : this.coords.size();
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format(" type=%-10s timeUnit=%s runDate= %-26s%n    ", this.getType(), this.timeUnit, this.runDate);
        if (this.isInterval()) {
            for (Tinv tinv : this.intervals) {
                out.format("%s, ", tinv);
            }
        } else {
            for (Integer val : this.coords) {
                out.format("%d, ", val);
            }
            out.format(" units (%s) since %s", this.timeUnit, this.runDate);
        }
        return out.toString();
    }

    public boolean equalsData(TimeCoord tother) {
        if (!this.runDate.equals((Object)tother.runDate)) {
            return false;
        }
        if (!this.timeUnit.equals((Object)tother.timeUnit)) {
            return false;
        }
        if (this.isInterval() != tother.isInterval()) {
            return false;
        }
        if (this.isInterval()) {
            if (this.intervals.size() != tother.intervals.size()) {
                return false;
            }
            for (int i = 0; i < this.intervals.size(); ++i) {
                if (this.intervals.get(i).equals(tother.intervals.get(i))) continue;
                return false;
            }
            return true;
        }
        if (this.coords.size() != tother.coords.size()) {
            return false;
        }
        for (int i = 0; i < this.coords.size(); ++i) {
            if (this.coords.get(i).equals(tother.coords.get(i))) continue;
            return false;
        }
        return true;
    }

    public int findInterval(Tinv tinv) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (!this.intervals.get(i).equals(tinv)) continue;
            return i;
        }
        return -1;
    }

    public int findIdx(int offsetHour) {
        for (int i = 0; i < this.coords.size(); ++i) {
            if (!this.coords.get(i).equals(offsetHour)) continue;
            return i;
        }
        return -1;
    }

    public static int findCoord(List<TimeCoord> timeCoords, TimeCoord want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < timeCoords.size(); ++i) {
            if (!want.equalsData(timeCoords.get(i))) continue;
            return i;
        }
        timeCoords.add(want);
        return timeCoords.size() - 1;
    }

    public static class Tinv
    implements Comparable<Tinv> {
        private final int b1;
        private final int b2;

        public Tinv(int b1, int b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public int getBounds1() {
            return this.b1;
        }

        public int getBounds2() {
            return this.b2;
        }

        public Tinv convertReferenceDate(CalendarDate fromDate, CalendarPeriod fromUnit, CalendarDate toDate, CalendarPeriod toUnit) {
            CalendarDate start = fromDate.add(fromUnit.multiply(this.b1));
            CalendarDate end = fromDate.add(fromUnit.multiply(this.b2));
            int startOffset = TimeCoord.getOffset(toDate, start, toUnit);
            int endOffset = TimeCoord.getOffset(toDate, end, toUnit);
            return new Tinv(startOffset, endOffset);
        }

        public boolean equals(Object o) {
            Tinv tinv = (Tinv)o;
            if (this.b1 != tinv.b1) {
                return false;
            }
            return this.b2 == tinv.b2;
        }

        public int hashCode() {
            int result = this.b1;
            result = 31 * result + this.b2;
            return result;
        }

        @Override
        public int compareTo(Tinv o) {
            int c1 = this.b2 - o.b2;
            return c1 == 0 ? this.b1 - o.b1 : c1;
        }

        public String toString() {
            Formatter out = new Formatter();
            out.format("(%d,%d)", this.b1, this.b2);
            return out.toString();
        }
    }
}

