/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2Collection;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Iosp;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class TimePartition
extends Grib2Collection {
    private static final Logger logger = LoggerFactory.getLogger(TimePartition.class);
    Map<String, Partition> partitionMap;
    List<Partition> partitions;

    TimePartition(String name, File directory) {
        super(name, directory);
    }

    @Override
    public File getIndexFile() {
        return new File(this.directory, this.name + ".ncx");
    }

    Partition makePartition(CollectionManager dcm) {
        return new Partition(dcm);
    }

    Partition makePartition(String name, String filename) {
        return new Partition(name, filename);
    }

    public Partition getCollection(String name) {
        return this.partitionMap.get(name);
    }

    GribCollection.VariableIndex makeVariableIndex(GribCollection.GroupHcs group, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, int ensDerivedType, int probType, String probabilityName, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen, List<Integer> groupnoList, List<Integer> varnoList) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, discipline, category, parameter, levelType, isLayer, intvType, ensDerivedType, probType, probabilityName, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        int nparts = varnoList.size();
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = groupnoList.get(i);
            vip.varno[i] = varnoList.get(i);
        }
        return vip;
    }

    VariableIndexPartitioned makeVariableIndexPartitioned(GribCollection.VariableIndex vi, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(vi.group, vi.discipline, vi.category, vi.parameter, vi.levelType, vi.isLayer, vi.intvType, vi.ensDerivedType, vi.probType, vi.probabilityName, vi.cdmHash, vi.timeIdx, vi.vertIdx, vi.ensIdx, vi.recordsPos, vi.recordsLen);
        vip.groupno = new int[nparts];
        vip.varno = new int[nparts];
        for (int i = 0; i < nparts; ++i) {
            vip.groupno[i] = -1;
            vip.varno[i] = -1;
        }
        return vip;
    }

    public List<Partition> getPartitions() {
        if (this.partitions == null) {
            ArrayList<Partition> c = new ArrayList<Partition>(this.partitionMap.values());
            Collections.sort(c);
            this.partitions = c;
        }
        return this.partitions;
    }

    public void removePartition(Partition p) {
        this.partitions.remove(p);
        if (null != p.getDcm()) {
            this.partitionMap.remove(p.getDcm().getCollectionName());
        }
    }

    public void updateProto() {
    }

    public boolean checkInvState(long lastInvChange) throws IOException {
        return false;
    }

    public boolean checkProtoState(long lastProtoChanged) throws IOException {
        return false;
    }

    public void checkNeeded(boolean force) {
    }

    public NetcdfDataset getNetcdfDataset(String groupName) throws IOException {
        GribCollection.GroupHcs want = this.findGroup(groupName);
        if (want == null) {
            return null;
        }
        Grib2Iosp iosp = new Grib2Iosp(want);
        GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
        return new NetcdfDataset((NetcdfFile)ncfile);
    }

    public ucar.nc2.dt.GridDataset getGridDataset(String groupName) throws IOException {
        GribCollection.GroupHcs want = this.findGroup(groupName);
        if (want == null) {
            return null;
        }
        Grib2Iosp iosp = new Grib2Iosp(want);
        GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
        NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
        return new GridDataset(ncd);
    }

    @Override
    public void showIndex(Formatter f) {
        List<Partition> plist = this.getPartitions();
        f.format("Partitions (%d)%n", plist.size());
        for (Partition p : plist) {
            f.format("  %s%n", p);
        }
        f.format("%n", new Object[0]);
        super.showIndex(f);
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartitions().get(partno);
        return part.gribCollection.getRaf(fileno);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        for (Partition part : this.getPartitions()) {
            if (part.gribCollection == null) continue;
            part.gribCollection.close();
        }
    }

    public static void main(String[] args) throws IOException {
        Formatter f = new Formatter();
        RandomAccessFile raf = new RandomAccessFile("G:/nomads/cfsr/timeseries/collection.ncx", "r");
        TimePartition gtc = TimePartitionBuilder.createFromIndex("test", null, raf);
        gtc.showIndex(f);
        System.out.printf("%s%n", f);
        raf.close();
    }

    public class VariableIndexPartitioned
    extends GribCollection.VariableIndex {
        int[] groupno;
        int[] varno;

        public VariableIndexPartitioned(GribCollection.GroupHcs g, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, int ensDerivedType, int probType, String probabilityName, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
            super(g, 0, discipline, category, parameter, levelType, isLayer, intvType, ensDerivedType, probType, probabilityName, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
        }

        void setPartitionIndex(int partno, int groupIdx, int varIdx) {
            this.groupno[partno] = groupIdx;
            this.varno[partno] = varIdx;
        }

        public GribCollection.VariableIndex getVindex(int partno) throws IOException {
            Partition p = TimePartition.this.getPartitions().get(partno);
            GribCollection gc = p.getGribCollection();
            GribCollection.GroupHcs g = gc.groups.get(this.groupno[partno]);
            GribCollection.VariableIndex vindex = g.varIndex.get(this.varno[partno]);
            vindex.readRecords();
            return vindex;
        }
    }

    public class Partition
    implements Comparable<Partition> {
        protected CollectionManager dcm;
        private GribCollection gribCollection;
        private String name;
        private String filename;
        private RandomAccessFile raf;

        public Partition(String name, String filename) {
            this.name = name;
            this.filename = filename;
        }

        public Partition(CollectionManager dcm) {
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
        }

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public CollectionManager getDcm() {
            return this.dcm;
        }

        public GribCollection getGribCollection() throws IOException {
            return this.getGribCollection(new Formatter());
        }

        public GribCollection getGribCollection(Formatter f) throws IOException {
            if (this.gribCollection == null) {
                GribCollection gc;
                if (this.dcm != null) {
                    gc = Grib2CollectionBuilder.factory(this.dcm, CollectionManager.Force.test, f);
                } else {
                    this.raf = new RandomAccessFile(this.filename, "r");
                    TimePartition.this.rafLocation = this.filename;
                    gc = Grib2CollectionBuilder.createFromIndex(this.name, null, this.raf);
                }
                this.gribCollection = gc;
                this.filename = gc.getIndexFile().getPath();
            }
            return this.gribCollection;
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", filename='" + this.filename + '\'' + '}';
        }
    }
}

