/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import net.jcip.annotations.Immutable;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;

@Immutable
public class Grib1ParamLevel {
    private final int center;
    private final int subcenter;
    private final int levelType;
    private final float value1;
    private final float value2;

    public static String getLevelDescription(int levelType) {
        switch (levelType) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Ground or water surface";
            }
            case 2: {
                return "Cloud base level";
            }
            case 3: {
                return "Level of cloud tops";
            }
            case 4: {
                return "Level of 0deg C isotherm";
            }
            case 5: {
                return "Level of adiabatic condensation lifted from the surface";
            }
            case 6: {
                return "Maximum wind level";
            }
            case 7: {
                return "Tropopause";
            }
            case 8: {
                return "Nominal top of the atmosphere";
            }
            case 9: {
                return "Sea bottom";
            }
            case 20: {
                return "Isothermal level";
            }
            case 100: {
                return "Isobaric surface";
            }
            case 101: {
                return "Layer between 2 isobaric levels";
            }
            case 102: {
                return "Mean sea level";
            }
            case 103: {
                return "Altitude above mean sea level";
            }
            case 104: {
                return "Layer between 2 altitudes above msl";
            }
            case 105: {
                return "Specified height level above ground";
            }
            case 106: {
                return "Layer between 2 specified height level above ground";
            }
            case 107: {
                return "Sigma level";
            }
            case 108: {
                return "Layer between 2 sigma levels";
            }
            case 109: {
                return "Hybrid level";
            }
            case 110: {
                return "Layer between 2 hybrid levels";
            }
            case 111: {
                return "Depth below land surface";
            }
            case 112: {
                return "Layer between 2 depths below land surface";
            }
            case 113: {
                return "Isentropic theta level";
            }
            case 114: {
                return "Layer between 2 isentropic levels";
            }
            case 115: {
                return "Level at specified pressure difference from ground to level";
            }
            case 116: {
                return "Layer between 2 level at pressure difference from ground to level";
            }
            case 117: {
                return "Potential vorticity surface";
            }
            case 119: {
                return "Eta level";
            }
            case 120: {
                return "Layer between 2 Eta levels";
            }
            case 121: {
                return "Layer between 2 isobaric levels";
            }
            case 125: {
                return "Specified height level above ground";
            }
            case 126: {
                return "Isobaric level";
            }
            case 128: {
                return "Layer between 2 sigma levels (hi precision)";
            }
            case 141: {
                return "Layer between 2 isobaric surfaces";
            }
            case 160: {
                return "Depth below sea level";
            }
            case 200: {
                return "Entire atmosphere";
            }
            case 201: {
                return "Entire ocean";
            }
            case 204: {
                return "Highest tropospheric freezing level";
            }
            case 206: {
                return "Grid scale cloud bottom level";
            }
            case 207: {
                return "Grid scale cloud top level";
            }
            case 209: {
                return "Boundary layer cloud bottom level";
            }
            case 210: {
                return "Boundary layer cloud top level";
            }
            case 211: {
                return "Boundary layer cloud layer";
            }
            case 212: {
                return "Low cloud bottom level";
            }
            case 213: {
                return "Low cloud top level";
            }
            case 214: {
                return "Low Cloud Layer";
            }
            case 222: {
                return "Middle cloud bottom level";
            }
            case 223: {
                return "Middle cloud top level";
            }
            case 224: {
                return "Middle Cloud Layer";
            }
            case 232: {
                return "High cloud bottom level";
            }
            case 233: {
                return "High cloud top level";
            }
            case 234: {
                return "High Cloud Layer";
            }
            case 242: {
                return "Convective cloud bottom level";
            }
            case 243: {
                return "Convective cloud top level";
            }
            case 244: {
                return "Convective cloud layer";
            }
            case 245: {
                return "Lowest level of the wet bulb zero";
            }
            case 246: {
                return "Maximum equivalent potential temperature level";
            }
            case 247: {
                return "Equilibrium level";
            }
            case 248: {
                return "Shallow convective cloud bottom level";
            }
            case 249: {
                return "Shallow convective cloud top level";
            }
            case 251: {
                return "Deep convective cloud bottom level";
            }
            case 252: {
                return "Deep convective cloud top level";
            }
            case 255: {
                return "Missing";
            }
        }
        return "Unknown=" + levelType;
    }

    public static String getNameShort(int levelType) {
        switch (levelType) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "isobaric";
            }
            case 101: {
                return "layer_between_two_isobaric";
            }
            case 102: {
                return "msl";
            }
            case 103: {
                return "altitude_above_msl";
            }
            case 104: {
                return "layer_between_two_altitudes_above_msl";
            }
            case 105: {
                return "height_above_ground";
            }
            case 106: {
                return "layer_between_two_heights_above_ground";
            }
            case 107: {
                return "sigma";
            }
            case 108: {
                return "layer_between_two_sigmas";
            }
            case 109: {
                return "hybrid";
            }
            case 110: {
                return "layer_between_two_hybrids";
            }
            case 111: {
                return "depth_below_surface";
            }
            case 112: {
                return "layer_between_two_depths_below_surface";
            }
            case 113: {
                return "isentrope";
            }
            case 114: {
                return "layer_between_two_isentrope";
            }
            case 115: {
                return "pressure_difference";
            }
            case 116: {
                return "layer_between_two_pressure_difference_from_ground";
            }
            case 117: {
                return "potential_vorticity_surface";
            }
            case 119: {
                return "eta";
            }
            case 120: {
                return "layer_between_two_eta";
            }
            case 121: {
                return "layer_between_two_isobaric_surfaces";
            }
            case 125: {
                return "height_above_ground";
            }
            case 126: {
                return "isobaric";
            }
            case 128: {
                return "layer_between_two_sigmas_hi";
            }
            case 141: {
                return "layer_between_two_isobaric_surfaces";
            }
            case 160: {
                return "depth_below_sea";
            }
            case 200: {
                return "entire_atmosphere";
            }
            case 201: {
                return "entire_ocean";
            }
            case 204: {
                return "highest_tropospheric_freezing";
            }
            case 206: {
                return "grid_scale_cloud bottom";
            }
            case 207: {
                return "grid_scale_cloud_top";
            }
            case 209: {
                return "boundary_layer_cloud_bottom";
            }
            case 210: {
                return "boundary_layer_cloud_top";
            }
            case 211: {
                return "boundary_layer_cloud_layer";
            }
            case 212: {
                return "low_cloud_bottom";
            }
            case 213: {
                return "low_cloud_top";
            }
            case 214: {
                return "low_cloud_layer";
            }
            case 222: {
                return "middle_cloud_bottom";
            }
            case 223: {
                return "middle_cloud_top";
            }
            case 224: {
                return "middle_cloud_layer";
            }
            case 232: {
                return "high_cloud_bottom";
            }
            case 233: {
                return "high_cloud_top";
            }
            case 234: {
                return "high_cloud_layer";
            }
            case 242: {
                return "convective_cloud_bottom";
            }
            case 243: {
                return "convective_cloud_top";
            }
            case 244: {
                return "convective_cloud_layer";
            }
            case 245: {
                return "lowest_level_of_wet_bulb_zero";
            }
            case 246: {
                return "maximum_equivalent_potential_temperature";
            }
            case 247: {
                return "equilibrium";
            }
            case 248: {
                return "shallow_convective_cloud_bottom";
            }
            case 249: {
                return "shallow_convective_cloud_top";
            }
            case 251: {
                return "deep_convective_cloud_bottom";
            }
            case 252: {
                return "deep_convective_cloud_top";
            }
            case 255: {
                return "";
            }
        }
        return "Unknown" + levelType;
    }

    public static String getUnits(int levelType) {
        switch (levelType) {
            case 20: 
            case 113: 
            case 114: {
                return "K";
            }
            case 100: 
            case 101: 
            case 115: 
            case 116: 
            case 121: 
            case 141: {
                return "hPa";
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 160: {
                return "m";
            }
            case 107: 
            case 108: 
            case 128: {
                return "sigma";
            }
            case 111: 
            case 112: 
            case 125: {
                return "cm";
            }
            case 117: {
                return "10-6Km2/kgs";
            }
            case 126: {
                return "Pa";
            }
        }
        return "";
    }

    public static boolean isVerticalCoordinate(int levelType) {
        if (levelType == 20) {
            return true;
        }
        if (levelType == 100) {
            return true;
        }
        if (levelType == 101) {
            return true;
        }
        if (levelType >= 103 && levelType <= 128) {
            return true;
        }
        if (levelType == 141) {
            return true;
        }
        return levelType == 160;
    }

    public static String getDatum(int levelType) {
        switch (levelType) {
            case 103: {
                return "mean sea level";
            }
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 125: {
                return "ground";
            }
            case 160: {
                return "sea level";
            }
        }
        return null;
    }

    public static boolean isPositiveUp(int levelType) {
        if (levelType == 103) {
            return true;
        }
        if (levelType == 104) {
            return true;
        }
        if (levelType == 105) {
            return true;
        }
        if (levelType == 106) {
            return true;
        }
        if (levelType == 111) {
            return true;
        }
        if (levelType == 112) {
            return true;
        }
        return levelType == 125;
    }

    public static boolean isLayer(int levelType) {
        if (levelType == 101) {
            return true;
        }
        if (levelType == 104) {
            return true;
        }
        if (levelType == 106) {
            return true;
        }
        if (levelType == 108) {
            return true;
        }
        if (levelType == 110) {
            return true;
        }
        if (levelType == 112) {
            return true;
        }
        if (levelType == 114) {
            return true;
        }
        if (levelType == 116) {
            return true;
        }
        if (levelType == 120) {
            return true;
        }
        if (levelType == 121) {
            return true;
        }
        if (levelType == 128) {
            return true;
        }
        return levelType == 141;
    }

    public static VertCoord.VertUnit getLevelUnit(int code) {
        return new VertCoord.VertUnit(code, Grib1ParamLevel.getUnits(code), Grib1ParamLevel.getDatum(code), Grib1ParamLevel.isPositiveUp(code));
    }

    public Grib1ParamLevel(Grib1SectionProductDefinition pds) {
        this.center = pds.getCenter();
        this.subcenter = pds.getSubCenter();
        this.levelType = pds.getLevelType();
        int pds11 = pds.getLevelValue1();
        int pds12 = pds.getLevelValue2();
        int pds1112 = pds11 << 8 | pds12;
        switch (this.levelType) {
            default: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 20: {
                this.value1 = (float)((double)pds1112 * 0.01);
                this.value2 = 255.0f;
                break;
            }
            case 100: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 101: {
                this.value1 = pds11 * 10;
                this.value2 = pds12 * 10;
                break;
            }
            case 103: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 104: {
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                break;
            }
            case 105: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 106: {
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                break;
            }
            case 107: {
                this.value1 = (float)((double)pds1112 * 1.0E-4);
                this.value2 = 255.0f;
                break;
            }
            case 108: {
                this.value1 = (float)((double)pds11 * 0.01);
                this.value2 = (float)((double)pds12 * 0.01);
                break;
            }
            case 109: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 110: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 111: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 112: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 113: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 114: {
                this.value1 = 475 - pds11;
                this.value2 = 475 - pds12;
                break;
            }
            case 115: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 116: {
                this.value1 = pds11;
                this.value2 = pds12;
                break;
            }
            case 117: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 119: {
                this.value1 = (float)((double)pds1112 * 1.0E-4);
                this.value2 = 255.0f;
                break;
            }
            case 120: {
                this.value1 = (float)((double)pds11 * 0.01);
                this.value2 = (float)((double)pds12 * 0.01);
                break;
            }
            case 121: {
                this.value1 = 1100 - pds11;
                this.value2 = 1100 - pds12;
                break;
            }
            case 125: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 126: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 128: {
                this.value1 = (float)(1.1 - (double)pds11 * 0.001);
                this.value2 = (float)(1.1 - (double)pds12 * 0.001);
                break;
            }
            case 141: {
                this.value1 = pds11;
                this.value2 = 1100 - pds12;
                break;
            }
            case 160: {
                this.value1 = pds1112;
                this.value2 = 255.0f;
                break;
            }
            case 236: {
                this.value1 = pds11;
                this.value2 = pds12;
            }
        }
    }

    public int getLevelType() {
        return this.levelType;
    }

    public float getValue1() {
        return this.value1;
    }

    public float getValue2() {
        return this.value2;
    }

    public boolean isLayer() {
        return Grib1ParamLevel.isLayer(this.levelType);
    }

    public boolean isPositiveUp() {
        return Grib1ParamLevel.isPositiveUp(this.levelType);
    }

    public String getUnits() {
        return Grib1ParamLevel.getUnits(this.levelType);
    }
}

