/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class Grib1ParamTime {
    private final int timeType;
    private final int p1;
    private final int p2;
    private final boolean isInterval;
    private int start;
    private int end;
    private int forecastTime;

    public static CalendarPeriod getCalendarPeriod(int timeUnit) {
        switch (timeUnit) {
            case 0: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
            case 1: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 2: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Day);
            }
            case 3: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Month);
            }
            case 4: {
                return CalendarPeriod.of((int)1, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 5: {
                return CalendarPeriod.of((int)10, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 6: {
                return CalendarPeriod.of((int)30, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 7: {
                return CalendarPeriod.of((int)100, (CalendarPeriod.Field)CalendarPeriod.Field.Year);
            }
            case 10: {
                return CalendarPeriod.of((int)3, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 11: {
                return CalendarPeriod.of((int)6, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 12: {
                return CalendarPeriod.of((int)12, (CalendarPeriod.Field)CalendarPeriod.Field.Hour);
            }
            case 13: {
                return CalendarPeriod.of((int)15, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
            case 14: {
                return CalendarPeriod.of((int)30, (CalendarPeriod.Field)CalendarPeriod.Field.Minute);
            }
        }
        throw new UnsupportedOperationException("Unknown time unit = " + timeUnit);
    }

    public static StatType getStatType(int timeType) {
        switch (timeType) {
            case 3: 
            case 6: 
            case 7: 
            case 51: 
            case 113: 
            case 115: 
            case 117: 
            case 123: {
                return StatType.Average;
            }
            case 4: 
            case 114: 
            case 116: 
            case 124: {
                return StatType.Accumulation;
            }
            case 5: {
                return StatType.Difference;
            }
            case 118: {
                return StatType.Variance;
            }
            case 119: 
            case 125: {
                return StatType.StdDev;
            }
        }
        return null;
    }

    public static String getTimeTypeName(int timeType, int p1, int p2) {
        String timeRange;
        switch (timeType) {
            case 0: {
                timeRange = p1 == 0 ? "Uninitialized analysis or image product for reference time" : "Forecast product valid for RT + P1";
                break;
            }
            case 1: {
                timeRange = "Initialized analysis product for reference time";
                break;
            }
            case 2: {
                timeRange = "product valid, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 3: {
                timeRange = "Average, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 4: {
                timeRange = "Accumulation, interval = (RT + P1) to (RT + P2)";
                break;
            }
            case 5: {
                timeRange = "Difference, interval = (RT + P2) - (RT + P1)";
                break;
            }
            case 6: {
                timeRange = "Average, interval = (RT - P1) to (RT - P2)";
                break;
            }
            case 7: {
                timeRange = "Average, interval = (RT - P1) to (RT + P2)";
                break;
            }
            case 10: {
                timeRange = "product valid at RT + P1";
                break;
            }
            case 51: {
                timeRange = "Climatological mean values from RT to (RT + P2)";
                break;
            }
            case 113: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 114: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime + i * P2, refTime + i * P2 + P1)";
                break;
            }
            case 115: {
                timeRange = "Average of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 116: {
                timeRange = "Accumulation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            case 117: {
                timeRange = "Average of N forecasts, intervals = (refTime + i * P2, refTime + P1)";
                break;
            }
            case 118: {
                timeRange = "Temporal variance or covariance of N initialized analyses, timeCoord = (refTime + i * P2)";
                break;
            }
            case 119: {
                timeRange = "Standard Deviation of N forecasts, timeCoord = (refTime + P1 + i * P2)";
                break;
            }
            case 123: {
                timeRange = "Average of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 124: {
                timeRange = "Accumulation of N uninitialized analyses, intervals = (refTime, refTime + i * P2)";
                break;
            }
            case 125: {
                timeRange = "Standard deviation of N forecasts, intervals = (refTime, refTime + P1 + i * P2)";
                break;
            }
            default: {
                timeRange = "Unknown Time Range Indicator " + timeType;
            }
        }
        return timeRange;
    }

    public Grib1ParamTime(Grib1SectionProductDefinition pds) {
        this.timeType = pds.getTimeType();
        this.p1 = pds.getTimeValue1();
        this.p2 = pds.getTimeValue2();
        int n = pds.getNincluded();
        switch (this.timeType) {
            case 0: {
                this.forecastTime = this.p1;
                this.isInterval = false;
                break;
            }
            case 1: {
                this.forecastTime = 0;
                this.isInterval = false;
                break;
            }
            case 2: {
                this.start = this.p1;
                this.end = this.p2;
                this.isInterval = true;
                break;
            }
            case 3: {
                this.start = this.p1;
                this.end = this.p2;
                this.isInterval = true;
                break;
            }
            case 4: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = this.p2;
                this.isInterval = true;
                break;
            }
            case 5: {
                this.start = this.p1;
                this.end = this.p2;
                this.forecastTime = this.p2;
                this.isInterval = true;
                break;
            }
            case 6: {
                this.start = -this.p1;
                this.end = -this.p2;
                this.isInterval = true;
                break;
            }
            case 7: {
                this.start = -this.p1;
                this.end = this.p2;
                this.isInterval = true;
                break;
            }
            case 10: {
                this.forecastTime = GribNumbers.int2(this.p1, this.p2);
                this.isInterval = false;
                break;
            }
            case 51: {
                this.forecastTime = this.p2;
                this.isInterval = false;
                break;
            }
            case 113: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            case 114: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            case 115: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            case 116: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            case 117: {
                this.start = 0;
                this.end = this.p1;
                this.isInterval = true;
                break;
            }
            case 118: {
                this.start = 0;
                this.end = n * this.p2;
                this.isInterval = true;
                break;
            }
            case 119: {
                this.start = this.p1;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            case 123: {
                this.start = 0;
                this.end = n * this.p2;
                this.isInterval = true;
                break;
            }
            case 124: {
                this.start = 0;
                this.end = n * this.p2;
                this.isInterval = true;
                break;
            }
            case 125: {
                this.start = 0;
                this.end = this.p1 + n * this.p2;
                this.isInterval = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("PDS: Unknown Time Range Indicator " + this.timeType);
            }
        }
    }

    public int[] getInterval() {
        int[] nArray;
        if (this.isInterval) {
            int[] nArray2 = new int[2];
            nArray2[0] = this.start;
            nArray = nArray2;
            nArray2[1] = this.end;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public int getForecastTime() {
        return this.forecastTime;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public String getTimeTypeName() {
        return Grib1ParamTime.getTimeTypeName(this.timeType, this.p1, this.p2);
    }

    public StatType getStatType() {
        return Grib1ParamTime.getStatType(this.timeType);
    }

    public String getTimeCoord() {
        if (this.isInterval()) {
            int[] intv = this.getInterval();
            return intv[0] + "-" + intv[1];
        }
        return Integer.toString(this.getForecastTime());
    }

    public static enum StatType {
        Average,
        Accumulation,
        Difference,
        StdDev,
        Variance;

    }
}

