/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Utils;
import ucar.nc2.grib.grib1.tables.Grib1ParamTable;
import ucar.nc2.grib.grib1.tables.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1Tables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public final class Grib1SectionProductDefinition {
    private byte[] rawData;

    public Grib1SectionProductDefinition(RandomAccessFile raf) throws IOException {
        int length = GribNumbers.uint3(raf);
        this.rawData = new byte[length];
        raf.skipBytes(-3);
        raf.read(this.rawData);
    }

    public Grib1SectionProductDefinition(byte[] rawData) {
        this.rawData = rawData;
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public final int getTableVersion() {
        return this.getOctet(4);
    }

    public final int getCenter() {
        return this.getOctet(5);
    }

    public final int getGenProcess() {
        return this.getOctet(6);
    }

    public final int getGridDefinition() {
        return this.getOctet(7);
    }

    public final int getFlag() {
        return this.getOctet(8);
    }

    public final int getParameterNumber() {
        return this.getOctet(9);
    }

    public final int getLevelType() {
        return this.getOctet(10);
    }

    public final int getLevelValue1() {
        return this.getOctet(11);
    }

    public final int getLevelValue2() {
        return this.getOctet(12);
    }

    public final CalendarDate getReferenceDate() {
        int century = this.getReferenceCentury() - 1;
        if (century == -1) {
            century = 20;
        }
        int year = this.getOctet(13);
        int month = this.getOctet(14);
        int day = this.getOctet(15);
        int hour = this.getOctet(16);
        int minute = this.getOctet(17);
        return CalendarDate.of(null, (int)(century * 100 + year), (int)month, (int)day, (int)hour, (int)minute, (int)0);
    }

    public final int getTimeUnit() {
        return this.getOctet(18);
    }

    public final int getTimeValue1() {
        return this.getOctet(19);
    }

    public final int getTimeValue2() {
        return this.getOctet(20);
    }

    public final int getTimeType() {
        return this.getOctet(21);
    }

    public final int getNincluded() {
        return GribNumbers.int2(this.getOctet(22), this.getOctet(23));
    }

    public final int getNmissing() {
        return this.getOctet(24);
    }

    public final int getReferenceCentury() {
        return this.getOctet(25);
    }

    public final int getSubCenter() {
        return this.getOctet(26);
    }

    public final int getDecimalScale() {
        return GribNumbers.int2(this.getOctet(27), this.getOctet(28));
    }

    public final boolean gdsExists() {
        return (this.getFlag() & 0x80) == 128;
    }

    public final boolean bmsExists() {
        return (this.getFlag() & 0x40) == 64;
    }

    private final int getOctet(int index) {
        if (index > this.rawData.length) {
            return -9999;
        }
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib1ParamLevel getParamLevel() {
        return new Grib1ParamLevel(this);
    }

    public Grib1ParamTime getParamTime() {
        return new Grib1ParamTime(this);
    }

    public void showPds(Grib1Tables tables, Formatter f) {
        f.format("            Originating Center : (%d) %s%n", this.getCenter(), CommonCodeTable.getCenterName((int)this.getCenter(), (int)1));
        f.format("         Originating SubCenter : (%d) %s%n", this.getSubCenter(), Grib1Utils.getSubCenterName(this.getCenter(), this.getSubCenter()));
        f.format("                 Table Version : %d%n", this.getTableVersion());
        Grib1Parameter parameter = tables.getParameter(this.getCenter(), this.getSubCenter(), this.getTableVersion(), this.getParameterNumber());
        if (parameter != null) {
            Grib1ParamTable ptable = parameter.getTable();
            f.format("               Parameter_table : (%d-%d-%d) %s%n", this.getCenter(), this.getSubCenter(), this.getTableVersion(), ptable == null ? "MISSING" : ptable.getPath());
            f.format("                Parameter Name : (%d) %s%n", this.getParameterNumber(), parameter.getName());
            f.format("                Parameter Desc : %s%n", parameter.getDescription());
            f.format("               Parameter Units : %s%n", parameter.getUnit());
            f.format("               Parameter Table : %s%n", parameter.getTable().getName());
        } else {
            f.format("               Parameter %d not found%n", this.getParameterNumber());
        }
        f.format("       Generating Process Type : (%d) %s%n", this.getGenProcess(), tables.getTypeGenProcessName(this.getCenter(), this.getGenProcess()));
        f.format("                Reference Time : %s%n", this.getReferenceDate());
        f.format("                    Time Units : (%d) %s%n", this.getTimeUnit(), Grib1ParamTime.getCalendarPeriod(this.getTimeUnit()));
        Grib1ParamTime ptime = this.getParamTime();
        f.format("          Time Range Indicator : (%d) %s%n", this.getTimeType(), ptime.getTimeTypeName());
        f.format("                   Time 1 (P1) : %d%n", this.getTimeValue1());
        f.format("                   Time 2 (P2) : %d%n", this.getTimeValue2());
        f.format("                   Time  coord : %s%n", ptime.getTimeCoord());
        Grib1ParamLevel plevel = this.getParamLevel();
        f.format("                    Level Type : (%d) %s%n", this.getLevelType(), tables.getLevelNameShort(plevel.getLevelType()));
        f.format("             Level Description : %s%n", tables.getLevelDescription(plevel.getLevelType()));
        f.format("                 Level Value 1 : %f%n", Float.valueOf(plevel.getValue1()));
        f.format("                 Level Value 2 : %f%n", Float.valueOf(plevel.getValue2()));
        f.format("               Grid Definition : %d%n", this.getGridDefinition());
        f.format("                    GDS Exists : %s%n", this.gdsExists());
        f.format("                    BMS Exists : %s%n", this.bmsExists());
    }

    public boolean isEnsemble() {
        return false;
    }

    public final int getPerturbationType() {
        return 0;
    }

    public final int getPerturbationNumber() {
        return 0;
    }
}

