/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribResourceReader;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.tables.Grib1ParamTable;
import ucar.nc2.grib.grib1.tables.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1StandardTables;

@Immutable
public class Grib1Tables
implements GribTables {
    private static final Logger logger = LoggerFactory.getLogger(Grib1ParamTable.class);
    private Grib1StandardTables.Lookup lookup;
    private Grib1ParamTable override;
    private Map<Integer, String> ncepGenProcess;

    public static Grib1Tables factory(String paramTablePath, String lookupTablePath) throws IOException {
        if (paramTablePath == null && lookupTablePath == null) {
            return new Grib1Tables();
        }
        Grib1Tables result = new Grib1Tables();
        if (paramTablePath != null) {
            result.override = new Grib1ParamTable(paramTablePath);
            if (result.override == null) {
                throw new FileNotFoundException("cant read parameter table=" + paramTablePath);
            }
        }
        if (lookupTablePath != null) {
            result.lookup = new Grib1StandardTables.Lookup();
            if (!result.lookup.readLookupTable(lookupTablePath)) {
                throw new FileNotFoundException("cant read lookup table=" + lookupTablePath);
            }
        }
        return result;
    }

    public static Grib1Tables factory(Element paramTableElem) throws IOException {
        if (paramTableElem == null) {
            return new Grib1Tables();
        }
        Grib1Tables result = new Grib1Tables();
        result.override = new Grib1ParamTable(paramTableElem);
        return result;
    }

    @Override
    public String getLevelNameShort(int code) {
        return Grib1ParamLevel.getNameShort(code);
    }

    public String getLevelDescription(int levelType) {
        return Grib1ParamLevel.getLevelDescription(levelType);
    }

    public Grib1Parameter getParameter(int center, int subcenter, int tableVersion, int param_number) {
        Grib1Parameter param = null;
        if (this.override != null) {
            param = this.override.getParameter(param_number);
        }
        if (param == null && this.lookup != null) {
            param = this.lookup.getParameter(center, subcenter, tableVersion, param_number);
        }
        if (param == null) {
            param = Grib1StandardTables.getParameter(center, subcenter, tableVersion, param_number);
        }
        return param;
    }

    public Grib1ParamTable getParameterTable(int center, int subcenter, int tableVersion) {
        Grib1ParamTable result = null;
        if (this.lookup != null) {
            result = this.lookup.getParameterTable(center, subcenter, tableVersion);
        }
        if (result == null) {
            result = Grib1StandardTables.getParameterTable(center, subcenter, tableVersion);
        }
        return result;
    }

    public String getTypeGenProcessName(int center, int genProcess) {
        if (center == 7) {
            if (this.ncepGenProcess == null) {
                this.readNcepGenProcess("resources/grib1/ncep/ncepTableA.xml");
            }
            if (this.ncepGenProcess == null) {
                return null;
            }
            return this.ncepGenProcess.get(genProcess);
        }
        if (center == 9) {
            switch (genProcess) {
                case 150: {
                    return "NWS River Forecast System (NWSRFS)";
                }
                case 151: {
                    return "NWS Flash Flood Guidance System (NWSFFGS)";
                }
                case 152: {
                    return "Quantitative Precipitation Estimation (QPE) - 1 hr dur";
                }
                case 154: {
                    return "Quantitative Precipitation Estimation (QPE) - 6 hr dur";
                }
                case 155: {
                    return "Quantitative Precipitation Estimation (QPE) - 24hr dur";
                }
                case 156: {
                    return "Process 1 (P1) Precipitation Estimation - automatic";
                }
                case 157: {
                    return "Process 1 (P1) Precipitation Estimation - manual";
                }
                case 158: {
                    return "Process 2 (P2) Precipitation Estimation - automatic";
                }
                case 159: {
                    return "Process 2 (P2) Precipitation Estimation - manual";
                }
                case 160: {
                    return "Multisensor Precipitation Estimation (MPE) - automatic";
                }
                case 161: {
                    return "Multisensor Precipitation Estimation (MPE) - manual";
                }
                case 165: {
                    return "Enhanced MPE - automatic";
                }
                case 166: {
                    return "Bias Enhanced MPE - automatic";
                }
                case 170: {
                    return "Post Analysis of Precipitation Estimation (aggregate)";
                }
                case 171: {
                    return "XNAV Aggregate Precipitation Estimation";
                }
                case 172: {
                    return "Mountain Mapper Precipitation Estimation";
                }
                case 180: {
                    return "Quantitative Precipitation Forecast (QPF)";
                }
                case 185: {
                    return "NOHRSC_OPPS";
                }
                case 190: {
                    return "Satellite Autoestimator Precipitation";
                }
                case 191: {
                    return "Satellite Interactive Flash Flood Analyzer (IFFA)";
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNcepGenProcess(String path) {
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(path);
            if (is == null) {
                logger.error("Cant find NCEP Table 1 = " + path);
                return;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            HashMap<Integer, String> result = new HashMap<Integer, String>(200);
            List params = root.getChildren("parameter");
            for (Element elem1 : params) {
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description");
                result.put(code, desc);
            }
            this.ncepGenProcess = result;
        }
        catch (IOException ioe) {
            logger.error("Cant read NCEP Table 1 = " + path, (Throwable)ioe);
            return;
        }
        catch (JDOMException e) {
            logger.error("Cant parse NCEP Table 1 = " + path, (Throwable)e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return;
    }
}

