/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import thredds.inventory.DatasetCollectionMFiles;
import thredds.inventory.MFile;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimePartitionBuilder;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2Collection;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Rectilyser;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class Grib2CollectionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GribCollection.class);
    public static final String MAGIC_START = "Grib2CollectionIndex";
    protected static final int version = 5;
    private static final boolean debug = false;
    private final List<CollectionManager> collections = new ArrayList<CollectionManager>();
    protected GribCollection gc;

    public static GribCollection createFromSingleFile(File file, Formatter f) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(file, f);
        builder.init(CollectionManager.Force.nocheck, f);
        return builder.gc;
    }

    public static GribCollection factory(CollectionManager dcm, CollectionManager.Force force, Formatter f) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm);
        builder.init(force, f);
        return builder.gc;
    }

    public static GribCollection createFromIndex(String name, File directory, RandomAccessFile raf) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(name, directory);
        if (builder.readIndex(raf)) {
            return builder.gc;
        }
        throw new IOException("Reading index failed");
    }

    public static boolean writeIndexFile(File indexFile, CollectionManager dcm, Formatter f) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm);
        return builder.createIndex(indexFile, CollectionManager.Force.always, f);
    }

    private Grib2CollectionBuilder(File file, Formatter f) throws IOException {
        try {
            String spec = StringUtil2.substitute((String)file.getPath(), (String)"\\", (String)"/");
            DatasetCollectionMFiles dcm = DatasetCollectionMFiles.open((String)spec, null, (Formatter)f);
            this.collections.add((CollectionManager)dcm);
            this.gc = new Grib2Collection(file.getName(), new File(dcm.getRoot()));
        }
        catch (Exception e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            e.printStackTrace(new PrintStream(bos));
            f.format("%s", bos.toString());
            throw new IOException(e);
        }
    }

    private Grib2CollectionBuilder(CollectionManager dcm) {
        this.collections.add(dcm);
        this.gc = new Grib2Collection(dcm.getCollectionName(), new File(dcm.getRoot()));
    }

    private Grib2CollectionBuilder(String name, File directory) {
        this.gc = new Grib2Collection(name, directory);
    }

    protected Grib2CollectionBuilder() {
        this.gc = null;
    }

    protected int getVersion() {
        return 5;
    }

    private void init(CollectionManager.Force ff, Formatter f) throws IOException {
        boolean force = ff == CollectionManager.Force.always || ff == CollectionManager.Force.test && this.needsUpdate();
        File idx = this.gc.getIndexFile();
        if (force || !idx.exists() || !this.readIndex(idx.getPath())) {
            logger.info("GribCollection createIndex {}", (Object)idx.getPath());
            this.createIndex(idx, ff, f);
            this.gc.rafLocation = idx.getPath();
            this.gc.raf = new RandomAccessFile(idx.getPath(), "r");
            this.readIndex(this.gc.raf);
        }
    }

    public boolean needsUpdate() {
        File idx = this.gc.getIndexFile();
        return !idx.exists() || this.needsUpdate(idx.lastModified());
    }

    private boolean needsUpdate(long idxLastModified) {
        CollectionManager.ChangeChecker cc = Grib2Index.getChangeChecker();
        for (CollectionManager dcm : this.collections) {
            for (MFile mfile : dcm.getFiles()) {
                if (!cc.hasChangedSince(mfile, idxLastModified)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean readIndex(String filename) throws IOException {
        return this.readIndex(new RandomAccessFile(filename, "r"));
    }

    public boolean readIndex(RandomAccessFile raf) throws IOException {
        this.gc.raf = raf;
        try {
            int i;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest((RandomAccessFile)raf, (byte[])MAGIC_START.getBytes())) {
                logger.error("GribCollection {} invalid index", (Object)this.gc.getName());
                throw new IOException("GribCollection " + this.gc.getName() + " invalid index");
            }
            int v = raf.readInt();
            if (v != this.getVersion()) {
                logger.warn("GribCollection {} index found version={}, want version= {} on file {}", new Object[]{this.gc.getName(), v, 5, raf.getLocation()});
                return false;
            }
            long skip = raf.readLong();
            raf.skipBytes(skip);
            int size = NcStream.readVInt((RandomAccessFile)raf);
            if (size < 0 || size > 100000000) {
                logger.warn("GribCollection {} invalid index ", (Object)this.gc.getName());
                return false;
            }
            byte[] m = new byte[size];
            raf.readFully(m);
            GribCollectionProto.GribCollectionIndex proto = GribCollectionProto.GribCollectionIndex.parseFrom(m);
            this.gc.center = proto.getCenter();
            this.gc.subcenter = proto.getSubcenter();
            this.gc.master = proto.getMaster();
            this.gc.local = proto.getLocal();
            this.gc.genProcessType = proto.getGenProcessType();
            this.gc.genProcessId = proto.getGenProcessId();
            this.gc.backProcessId = proto.getBackProcessId();
            this.gc.local = proto.getLocal();
            this.gc.filenames = new ArrayList<String>(proto.getFilesCount());
            for (i = 0; i < proto.getFilesCount(); ++i) {
                this.gc.filenames.add(proto.getFiles(i));
            }
            if (proto.getFilesCount() == 0 && !(this instanceof TimePartitionBuilder)) {
                logger.warn("GribCollection {} has no files, force recreate ", (Object)this.gc.getName());
                return false;
            }
            this.gc.groups = new ArrayList<GribCollection.GroupHcs>(proto.getGroupsCount());
            for (i = 0; i < proto.getGroupsCount(); ++i) {
                this.gc.groups.add(this.readGroup(proto.getGroups(i), this.gc.makeGroup()));
            }
            Collections.sort(this.gc.groups);
            this.gc.params = new ArrayList<Parameter>(proto.getParamsCount());
            for (i = 0; i < proto.getParamsCount(); ++i) {
                this.gc.params.add(this.readParam(proto.getParams(i)));
            }
            if (!this.readPartitions(proto)) {
                logger.warn("TimePartition {} has no partitions, force recreate ", (Object)this.gc.getName());
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            logger.error("Error reading index " + raf.getLocation(), t);
            return false;
        }
    }

    protected boolean readPartitions(GribCollectionProto.GribCollectionIndex proto) {
        return true;
    }

    protected void readTimePartitions(GribCollection.GroupHcs group, GribCollectionProto.Group proto) {
    }

    GribCollection.GroupHcs readGroup(GribCollectionProto.Group p, GribCollection.GroupHcs group) throws IOException {
        int i;
        Grib2SectionGridDefinition gdss = new Grib2SectionGridDefinition(p.getGds().toByteArray());
        Grib2Gds gds = gdss.getGDS();
        group.setHorizCoordSystem(gds.makeHorizCoordSys());
        group.varIndex = new ArrayList<GribCollection.VariableIndex>();
        for (i = 0; i < p.getVariablesCount(); ++i) {
            group.varIndex.add(this.readVariable(p.getVariables(i), group));
        }
        Collections.sort(group.varIndex);
        group.timeCoords = new ArrayList<TimeCoord>(p.getTimeCoordsCount());
        for (i = 0; i < p.getTimeCoordsCount(); ++i) {
            group.timeCoords.add(this.readTimeCoord(p.getTimeCoords(i)));
        }
        group.vertCoords = new ArrayList<VertCoord>(p.getVertCoordsCount());
        for (i = 0; i < p.getVertCoordsCount(); ++i) {
            group.vertCoords.add(this.readVertCoord(p.getVertCoords(i)));
        }
        group.ensCoords = new ArrayList<EnsCoord>(p.getEnsCoordsCount());
        for (i = 0; i < p.getEnsCoordsCount(); ++i) {
            group.ensCoords.add(this.readEnsCoord(p.getEnsCoords(i)));
        }
        group.filenose = new int[p.getFilenoCount()];
        for (i = 0; i < p.getFilenoCount(); ++i) {
            group.filenose[i] = p.getFileno(i);
        }
        this.readTimePartitions(group, p);
        for (GribCollection.VariableIndex vi : group.varIndex) {
            TimeCoord tc = group.timeCoords.get(vi.timeIdx);
            vi.ntimes = tc.getSize();
            VertCoord vc = vi.vertIdx < 0 ? null : group.vertCoords.get(vi.vertIdx);
            vi.nverts = vc == null ? 0 : vc.getSize();
            EnsCoord ec = vi.ensIdx < 0 ? null : group.ensCoords.get(vi.ensIdx);
            vi.nens = ec == null ? 0 : ec.getSize();
        }
        return group;
    }

    private Parameter readParam(GribCollectionProto.Parameter pp) throws IOException {
        if (pp.hasSdata()) {
            return new Parameter(pp.getName(), pp.getSdata());
        }
        int count = 0;
        double[] vals = new double[pp.getDataCount()];
        for (double val : pp.getDataList()) {
            vals[count++] = val;
        }
        return new Parameter(pp.getName(), vals);
    }

    private TimeCoord readTimeCoord(GribCollectionProto.Coord pc) throws IOException {
        if (pc.getBoundCount() > 0) {
            ArrayList<TimeCoord.Tinv> coords = new ArrayList<TimeCoord.Tinv>(pc.getValuesCount());
            for (int i = 0; i < pc.getValuesCount(); ++i) {
                coords.add(new TimeCoord.Tinv((int)pc.getValues(i), (int)pc.getBound(i)));
            }
            return new TimeCoord(pc.getCode(), pc.getUnit(), coords);
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(pc.getValuesCount());
        for (float value : pc.getValuesList()) {
            coords.add((int)value);
        }
        return new TimeCoord(pc.getCode(), pc.getUnit(), coords);
    }

    private VertCoord readVertCoord(GribCollectionProto.Coord pc) throws IOException {
        boolean isLayer = pc.getBoundCount() > 0;
        ArrayList<VertCoord.Level> coords = new ArrayList<VertCoord.Level>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); ++i) {
            coords.add(new VertCoord.Level(pc.getValues(i), isLayer ? (double)pc.getBound(i) : 0.0));
        }
        return new VertCoord(pc.getCode(), coords, isLayer);
    }

    private EnsCoord readEnsCoord(GribCollectionProto.Coord pc) throws IOException {
        ArrayList<EnsCoord.Coord> coords = new ArrayList<EnsCoord.Coord>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); i += 2) {
            coords.add(new EnsCoord.Coord((int)pc.getValues(i), (int)pc.getValues(i + 1)));
        }
        return new EnsCoord(coords);
    }

    protected GribCollection.VariableIndex readVariable(GribCollectionProto.Variable pv, GribCollection.GroupHcs group) {
        int discipline = pv.getDiscipline();
        int category = pv.getCategory();
        int param = pv.getParameter();
        int levelType = pv.getLevelType();
        int intvType = pv.getIntervalType();
        boolean isLayer = pv.getIsLayer();
        int ensDerivedType = pv.getEnsDerivedType();
        int probType = pv.getProbabilityType();
        String probabilityName = pv.getProbabilityName();
        int cdmHash = pv.getCdmHash();
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        int timeIdx = pv.getTimeIdx();
        int vertIdx = pv.getVertIdx();
        int ensIdx = pv.getEnsIdx();
        int tableVersion = pv.getTableVersion();
        return this.gc.makeVariableIndex(group, tableVersion, discipline, category, param, levelType, isLayer, intvType, ensDerivedType, probType, probabilityName, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
    }

    private boolean createIndex(File indexFile, CollectionManager.Force ff, Formatter f) throws IOException {
        long start = System.currentTimeMillis();
        ArrayList<String> filenames = new ArrayList<String>();
        List<Group> groups = this.makeAggregatedGroups(filenames, ff, f);
        this.createIndex(indexFile, groups, filenames, f);
        long took = System.currentTimeMillis() - start;
        f.format("That took %d msecs%n", took);
        return true;
    }

    public List<Group> makeAggregatedGroups(ArrayList<String> filenames, CollectionManager.Force force, Formatter f) throws IOException {
        HashMap<Integer, Group> gdsMap = new HashMap<Integer, Group>();
        f.format("GribCollection %s: makeAggregatedGroups%n", this.gc.getName());
        int total = 0;
        int fileno = 0;
        for (CollectionManager dcm : this.collections) {
            dcm.scanIfNeeded();
            f.format(" dcm= %s%n", dcm);
            Map gdsConvert = (Map)dcm.getAuxInfo("gdsHash");
            for (MFile mfile : dcm.getFiles()) {
                Grib2Index index;
                block8: {
                    filenames.add(mfile.getPath());
                    index = new Grib2Index();
                    try {
                        if (index.readIndex(mfile.getPath(), mfile.getLastModified(), force)) break block8;
                        index.makeIndex(mfile.getPath(), f);
                        f.format("  Index written: %s == %d records %n", mfile.getName() + ".gbx9", index.getRecords().size());
                    }
                    catch (IOException ioe) {
                        f.format("GribCollectionBuilder: reading/Creating gbx9 index failed err=%s%n  skipping %s%n", ioe.getMessage(), mfile.getPath() + ".gbx9");
                        continue;
                    }
                }
                for (Grib2Record gr : index.getRecords()) {
                    Group g;
                    gr.setFile(fileno);
                    int gdsHash = gr.getGDSsection().getGDS().hashCode();
                    if (gdsConvert != null && gdsConvert.get(gdsHash) != null) {
                        gdsHash = (Integer)gdsConvert.get(gdsHash);
                    }
                    if ((g = (Group)gdsMap.get(gdsHash)) == null) {
                        g = new Group(gr.getGDSsection(), gdsHash);
                        gdsMap.put(gdsHash, g);
                    }
                    g.records.add(gr);
                    ++total;
                }
                ++fileno;
            }
        }
        f.format(" total grib records= %d%n", total);
        Grib2Rectilyser.Counter c = new Grib2Rectilyser.Counter();
        ArrayList<Group> result = new ArrayList<Group>(gdsMap.values());
        for (Group g : result) {
            g.rect = new Grib2Rectilyser(g.records, g.gdsHash);
            f.format(" GDS hash %d == ", g.gdsHash);
            g.rect.make(f, c);
        }
        f.format(" Rectilyser: nvars=%d records unique=%d total=%d dups=%d (%f) %n", c.vars, c.recordsUnique, c.records, c.dups, Float.valueOf((float)c.dups / (float)c.records));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(File indexFile, List<Group> groups, ArrayList<String> filenames, Formatter f) throws IOException {
        Grib2Record first = null;
        if (indexFile.exists()) {
            indexFile.delete();
        }
        f.format(" createIndex for %s%n", indexFile.getPath());
        RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "rw");
        raf.order(0);
        try {
            raf.write(MAGIC_START.getBytes("UTF-8"));
            raf.writeInt(5);
            long lenPos = raf.getFilePointer();
            raf.writeLong(0L);
            long countBytes = 0L;
            int countRecords = 0;
            for (Group g : groups) {
                g.fileSet = new HashSet<Integer>();
                for (Grib2Rectilyser.VariableBag vb : g.rect.getGribvars()) {
                    if (first == null) {
                        first = vb.first;
                    }
                    GribCollectionProto.VariableRecords vr = this.writeRecordsProto(vb, g.fileSet);
                    byte[] b = vr.toByteArray();
                    vb.pos = raf.getFilePointer();
                    vb.length = b.length;
                    raf.write(b);
                    countBytes += (long)b.length;
                    countRecords += vb.recordMap.length;
                }
            }
            long bytesPerRecord = countBytes / (long)(countRecords == 0 ? 1 : countRecords);
            f.format("  write RecordMaps: bytes = %d record = %d bytesPerRecord=%d%n", countBytes, countRecords, bytesPerRecord);
            if (first == null) {
                logger.error("GribCollection {} has no files\n{}", (Object)this.gc.getName(), (Object)f.toString());
                throw new IllegalArgumentException("GribCollection " + this.gc.getName() + " has no files");
            }
            long pos = raf.getFilePointer();
            raf.seek(lenPos);
            raf.writeLong(countBytes);
            raf.seek(pos);
            GribCollectionProto.GribCollectionIndex.Builder indexBuilder = GribCollectionProto.GribCollectionIndex.newBuilder();
            indexBuilder.setName(this.gc.getName());
            for (String fn : filenames) {
                indexBuilder.addFiles(fn);
            }
            for (Group g : groups) {
                indexBuilder.addGroups(this.writeGroupProto(g));
            }
            Grib2SectionIdentification ids = first.getId();
            indexBuilder.setCenter(ids.getCenter_id());
            indexBuilder.setSubcenter(ids.getSubcenter_id());
            indexBuilder.setMaster(ids.getMaster_table_version());
            indexBuilder.setLocal(ids.getLocal_table_version());
            Grib2Pds pds = first.getPDS();
            indexBuilder.setGenProcessType(pds.getGenProcessType());
            indexBuilder.setGenProcessId(pds.getGenProcessId());
            indexBuilder.setBackProcessId(pds.getBackProcessId());
            GribCollectionProto.GribCollectionIndex index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((RandomAccessFile)raf, (int)b.length);
            raf.write(b);
            f.format("  write GribCollectionIndex= %d bytes%n", b.length);
        }
        catch (Throwable throwable) {
            f.format("  file size =  %d bytes%n", raf.length());
            raf.close();
            if (raf != null) {
                raf.close();
            }
            throw throwable;
        }
        f.format("  file size =  %d bytes%n", raf.length());
        raf.close();
        if (raf != null) {
            raf.close();
        }
    }

    private GribCollectionProto.VariableRecords writeRecordsProto(Grib2Rectilyser.VariableBag vb, Set<Integer> fileSet) throws IOException {
        GribCollectionProto.VariableRecords.Builder b = GribCollectionProto.VariableRecords.newBuilder();
        b.setCdmHash(vb.first.cdmVariableHash(0));
        for (Grib2Rectilyser.Record ar : vb.recordMap) {
            GribCollectionProto.Record.Builder br = GribCollectionProto.Record.newBuilder();
            if (ar == null || ar.gr == null) {
                br.setFileno(0);
                br.setPos(0L);
            } else {
                br.setFileno(ar.gr.getFile());
                fileSet.add(ar.gr.getFile());
                Grib2SectionDataRepresentation drs = ar.gr.getDataRepresentationSection();
                br.setPos(drs.getStartingPosition());
            }
            b.addRecords(br);
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(Group g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGds(ByteString.copyFrom((byte[])g.gdss.getRawBytes()));
        for (Grib2Rectilyser.VariableBag vb : g.rect.getGribvars()) {
            b.addVariables(this.writeVariableProto(vb));
        }
        List<TimeCoord> timeCoords = g.rect.getTimeCoords();
        for (int i = 0; i < timeCoords.size(); ++i) {
            b.addTimeCoords(this.writeCoordProto(timeCoords.get(i), i));
        }
        List<VertCoord> vertCoords = g.rect.getVertCoords();
        for (int i = 0; i < vertCoords.size(); ++i) {
            b.addVertCoords(this.writeCoordProto(vertCoords.get(i), i));
        }
        List<EnsCoord> ensCoords = g.rect.getEnsCoords();
        for (int i = 0; i < ensCoords.size(); ++i) {
            b.addEnsCoords(this.writeCoordProto(ensCoords.get(i), i));
        }
        for (Integer aFileSet : g.fileSet) {
            b.addFileno(aFileSet);
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(Grib2Rectilyser.VariableBag vb) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vb.first.getDiscipline());
        Grib2Pds pds = vb.first.getPDS();
        b.setCategory(pds.getParameterCategory());
        b.setParameter(pds.getParameterNumber());
        b.setLevelType(pds.getLevelType1());
        b.setIsLayer(Grib2Utils.isLayer(vb.first));
        b.setIntervalType(pds.getStatisticalProcessType());
        b.setCdmHash(vb.first.cdmVariableHash(0));
        b.setRecordsPos(vb.pos);
        b.setRecordsLen(vb.length);
        b.setTimeIdx(vb.timeCoordIndex);
        if (vb.vertCoordIndex >= 0) {
            b.setVertIdx(vb.vertCoordIndex);
        }
        if (vb.ensCoordIndex >= 0) {
            b.setEnsIdx(vb.ensCoordIndex);
        }
        if (pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds);
            b.setEnsDerivedType(pdsDerived.getDerivedForecastType());
        }
        if (pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
            b.setProbabilityName(pdsProb.getProbabilityName());
            b.setProbabilityType(pdsProb.getProbabilityType());
        }
        return b.build();
    }

    protected GribCollectionProto.Parameter writeParamProto(Parameter param) throws IOException {
        GribCollectionProto.Parameter.Builder b = GribCollectionProto.Parameter.newBuilder();
        b.setName(param.getName());
        if (param.isString()) {
            b.setSdata(param.getStringValue());
        } else {
            for (int i = 0; i < param.getLength(); ++i) {
                b.addData(param.getNumericValue(i));
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(TimeCoord tc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setCode(index);
        b.setUnit(tc.getUnits());
        float scale = (float)tc.getTimeUnitScale();
        if (tc.isInterval()) {
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                b.addValues((float)tinv.getBounds1() * scale);
                b.addBound((float)tinv.getBounds2() * scale);
            }
        } else {
            for (int value : tc.getCoords()) {
                b.addValues((float)value * scale);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(VertCoord vc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setCode(vc.getCode());
        b.setUnit(vc.getUnits());
        for (VertCoord.Level coord : vc.getCoords()) {
            if (vc.isLayer()) {
                b.addValues((float)coord.getValue1());
                b.addBound((float)coord.getValue2());
                continue;
            }
            b.addValues((float)coord.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(EnsCoord ec, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setCode(0);
        b.setUnit("");
        for (EnsCoord.Coord coord : ec.getCoords()) {
            b.addValues(coord.getCode());
            b.addValues(coord.getEnsMember());
        }
        return b.build();
    }

    private class Group {
        public Grib2SectionGridDefinition gdss;
        public int gdsHash;
        public Grib2Rectilyser rect;
        public List<Grib2Record> records = new ArrayList<Grib2Record>();
        public String name;
        public Set<Integer> fileSet;

        private Group(Grib2SectionGridDefinition gdss, int gdsHash) {
            this.gdss = gdss;
            this.gdsHash = gdsHash;
            Grib2Gds gds = gdss.getGDS();
            this.name = gds.getNameShort() + "-" + gds.ny + "X" + gds.nx;
        }
    }
}

