/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.TimePartitionBuilder;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class Grib2Iosp
extends AbstractIOServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private static final boolean debugTime = false;
    private static final boolean debugRead = false;
    private static final boolean debugName = false;
    private TimePartition timePartition;
    private GribCollection gribCollection;
    private Grib2Tables tables;
    private GribCollection.GroupHcs gHcs;
    private boolean isTimePartitioned;
    private boolean owned;

    public static String makeVariableName(Grib2Tables tables, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        Formatter f = new Formatter();
        GribTables.Parameter param = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        if (param == null) {
            f.format("VAR%d-%d-%d_FROM%d-%d-%d", vindex.discipline, vindex.category, vindex.parameter, gribCollection.center, gribCollection.subcenter, vindex.tableVersion);
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getName()));
        }
        if (vindex.levelType != -9999) {
            f.format("_%s", tables.getLevelNameShort(vindex.levelType));
            if (vindex.isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (vindex.intvType >= 0) {
            f.format("_%s", tables.getIntervalNameShort(vindex.intvType));
        }
        if (vindex.ensDerivedType >= 0) {
            f.format("_D%d", vindex.ensDerivedType);
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            String s = StringUtil2.substitute((String)vindex.probabilityName, (String)".", (String)"p");
            f.format("_Prob_%s", s);
        }
        return f.toString();
    }

    public static String makeVariableLongName(Grib2Tables tables, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = vindex.probabilityName != null && vindex.probabilityName.length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((gp = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter)) == null) {
            f.format("Unknown Parameter %d-%d-%d", vindex.discipline, vindex.category, vindex.parameter);
        } else {
            f.format("%s", gp.getName());
        }
        if (vindex.intvType >= 0) {
            f.format(" (%s)", tables.getTableValue("4.10", vindex.intvType));
        }
        if (vindex.ensDerivedType >= 0) {
            f.format(" (%s)", tables.getTableValue("4.7", vindex.ensDerivedType));
        } else if (isProb) {
            f.format(" %s %s", vindex.probabilityName, Grib2Iosp.getVindexUnits(tables, vindex));
        }
        if (vindex.levelType != -9999) {
            f.format(" @ %s", tables.getTableValue("4.5", vindex.levelType));
            if (vindex.isLayer) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    public static String makeVariableUnits(Grib2Tables tables, GribCollection.VariableIndex vindex) {
        if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            return "%";
        }
        return Grib2Iosp.getVindexUnits(tables, vindex);
    }

    private static String getVindexUnits(Grib2Tables tables, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        String val = gp == null ? "" : gp.getUnit();
        return val == null ? "" : val;
    }

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] b = new byte["Grib2CollectionIndex".length()];
        raf.readFully(b);
        String magic = new String(b);
        if (magic.equals("Grib2CollectionIndex")) {
            return true;
        }
        return Grib2RecordScanner.isValidFile(raf);
    }

    public String getFileTypeId() {
        return "GRIB2collection";
    }

    public String getFileTypeDescription() {
        return "GRIB2 Collection";
    }

    public Grib2Iosp() {
    }

    public Grib2Iosp(GribCollection.GroupHcs gHcs) {
        this.gHcs = gHcs;
        this.owned = true;
    }

    public Grib2Iosp(GribCollection gc) {
        this.gribCollection = gc;
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        boolean isGrib = Grib2RecordScanner.isValidFile(raf);
        if (isGrib) {
            Grib2Index index = new Grib2Index();
            Formatter f = new Formatter();
            this.gribCollection = index.makeCollection(raf, CollectionManager.Force.test, f, 2);
        }
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (TimePartition)this.gribCollection;
            }
            this.tables = Grib2Tables.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            this.addGroup(ncfile, this.gHcs, false);
        } else if (this.gribCollection != null) {
            if (this.gribCollection instanceof TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (TimePartition)this.gribCollection;
            }
            this.tables = Grib2Tables.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            boolean useGroups = this.gribCollection.getGroups().size() > 1;
            for (GribCollection.GroupHcs g : this.gribCollection.getGroups()) {
                this.addGroup(ncfile, g, useGroups);
            }
        } else {
            String name;
            raf.seek(0L);
            byte[] b = new byte["GribCollectionIndexTimePartitioned".length()];
            raf.readFully(b);
            String magic = new String(b);
            this.isTimePartitioned = magic.equals("GribCollectionIndexTimePartitioned");
            String location = raf.getLocation();
            File f = new File(location);
            int pos = f.getName().lastIndexOf(".");
            String string = name = pos > 0 ? f.getName().substring(0, pos) : f.getName();
            if (this.isTimePartitioned) {
                this.timePartition = TimePartitionBuilder.createFromIndex(name, f.getParentFile(), raf);
                this.gribCollection = this.timePartition;
            } else {
                this.gribCollection = Grib2CollectionBuilder.createFromIndex(name, f.getParentFile(), raf);
            }
            this.tables = Grib2Tables.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            boolean useGroups = this.gribCollection.getGroups().size() > 1;
            for (GribCollection.GroupHcs g : this.gribCollection.getGroups()) {
                this.addGroup(ncfile, g, useGroups);
            }
        }
        String val = CommonCodeTable.getCenterName((int)this.gribCollection.getCenter(), (int)2);
        ncfile.addAttribute(null, new Attribute("Originating/generating Center", val == null ? Integer.toString(this.gribCollection.getCenter()) : val));
        val = CommonCodeTable.getSubCenterName((int)this.gribCollection.getCenter(), (int)this.gribCollection.getSubcenter());
        ncfile.addAttribute(null, new Attribute("Originating/generating Subcenter", val == null ? Integer.toString(this.gribCollection.getSubcenter()) : val));
        ncfile.addAttribute(null, new Attribute("GRIB table version (master/local)", this.gribCollection.getMaster() + "/" + this.gribCollection.getLocal()));
        val = this.tables.getTableValue("4.3", this.gribCollection.getGenProcessType());
        if (val != null) {
            ncfile.addAttribute(null, new Attribute("Type of generating process", val));
        }
        if ((val = this.tables.getTableValue("ProcessId", this.gribCollection.getGenProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Analysis or forecast generating process identifier (defined by originating centre)", val));
        }
        if ((val = this.tables.getTableValue("ProcessId", this.gribCollection.getBackProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Background generating process identifier (defined by originating centre)", val));
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.6"));
        ncfile.addAttribute(null, new Attribute("history", "Read using CDM IOSP Grib2Collection"));
        ncfile.addAttribute(null, new Attribute("featureType", "GRID"));
        for (Parameter p : this.gribCollection.getParams()) {
            ncfile.addAttribute(null, new Attribute(p));
        }
    }

    private void addGroup(NetcdfFile ncfile, GribCollection.GroupHcs gHcs, boolean useGroups) {
        Variable v;
        String horizDims;
        Group g;
        GdsHorizCoordSys hcs = gHcs.hcs;
        String grid_mapping = hcs.getName() + "_Projection";
        VertCoord.assignVertNames(gHcs.vertCoords, this.tables);
        if (useGroups) {
            g = new Group(ncfile, null, gHcs.getGroupName());
            try {
                ncfile.addGroup(null, g);
            }
            catch (Exception e) {
                logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = ncfile.getRootGroup();
        }
        if (hcs == null) {
            logger.error("No GdsHorizCoordSys for gds template {} center {}", (Object)gHcs.hcs.template, (Object)this.gribCollection.getCenter());
            throw new IllegalStateException();
        }
        boolean is2D = Grib2Utils.isLatLon2D(gHcs.hcs.template, this.gribCollection.getCenter());
        if (is2D) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
        } else if (Grib2Utils.isLatLon(gHcs.hcs.template, this.gribCollection.getCenter())) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            cv.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.gaussLats != null) {
                cv.setCachedData(hcs.gaussLats);
            } else {
                cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            cv.addAttribute(new Attribute("units", "degrees_east"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx));
        } else {
            Variable hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            cv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            cv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy));
        }
        for (VertCoord vc : gHcs.vertCoords) {
            int count;
            float[] data;
            int n = vc.getSize();
            String vcName = vc.getName().toLowerCase();
            ncfile.addDimension(g, new Dimension(vcName, n));
            v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
            v.addAttribute(new Attribute("units", vc.getUnits()));
            v.addAttribute(new Attribute("long_name", this.tables.getTableValue("4.5", vc.getCode())));
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
            v.addAttribute(new Attribute("GRIB2_level_type", (Number)vc.getCode()));
            VertCoord.VertUnit vu = Grib2Utils.getLevelUnit(vc.getCode());
            if (vu != null && vu.datum != null) {
                v.addAttribute(new Attribute("datum", vu.datum));
            }
            if (vc.isLayer()) {
                data = new float[n];
                count = 0;
                for (VertCoord.Level val : vc.getCoords()) {
                    data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
                }
                v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data));
                Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
                v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
                bounds.addAttribute(new Attribute("units", vc.getUnits()));
                bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
                data = new float[2 * n];
                count = 0;
                for (VertCoord.Level level : vc.getCoords()) {
                    data[count++] = (float)level.getValue1();
                    data[count++] = (float)level.getValue2();
                }
                bounds.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n, 2}, (Object)data));
                continue;
            }
            data = new float[n];
            count = 0;
            for (VertCoord.Level val : vc.getCoords()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data));
        }
        for (TimeCoord tc : gHcs.timeCoords) {
            int n = tc.getSize();
            String tcName = tc.getName();
            ncfile.addDimension(g, new Dimension(tcName, n));
            v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.INT, tcName));
            v.addAttribute(new Attribute("units", tc.getUnits()));
            v.addAttribute(new Attribute("standard_name", "time"));
            int[] data = new int[n];
            int count = 0;
            if (tc.isInterval()) {
                for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                    data[count++] = tinv.getBounds2();
                }
            } else {
                Iterator<Comparable<TimeCoord.Tinv>> i$ = tc.getCoords().iterator();
                while (i$.hasNext()) {
                    int val = (Integer)i$.next();
                    data[count++] = val;
                }
            }
            v.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[]{n}, (Object)data));
            if (!tc.isInterval()) continue;
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName + "_bounds", DataType.INT, tcName + " 2"));
            v.addAttribute(new Attribute("bounds", tcName + "_bounds"));
            bounds.addAttribute(new Attribute("units", tc.getUnits()));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            data = new int[2 * n];
            count = 0;
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                data[count++] = tinv.getBounds1();
                data[count++] = tinv.getBounds2();
            }
            bounds.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[]{n, 2}, (Object)data));
        }
        int ccount = 0;
        for (EnsCoord ec : gHcs.ensCoords) {
            int n = ec.getSize();
            String ecName = "ens" + ccount;
            ncfile.addDimension(g, new Dimension(ecName, n));
            Variable v2 = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
            ncfile.addVariable(g, v2);
            ++ccount;
            v2.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
            int[] data = new int[n];
            int count = 0;
            for (EnsCoord.Coord ecc : ec.getCoords()) {
                data[count++] = ecc.getEnsMember();
            }
            v2.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[]{n}, (Object)data));
        }
        for (GribCollection.VariableIndex vindex : gHcs.varIndex) {
            TimeCoord tc = gHcs.timeCoords.get(vindex.timeIdx);
            VertCoord vc = vindex.vertIdx < 0 ? null : gHcs.vertCoords.get(vindex.vertIdx);
            EnsCoord ec = vindex.ensIdx < 0 ? null : gHcs.ensCoords.get(vindex.ensIdx);
            StringBuilder dims = new StringBuilder();
            String tcName = tc.getName();
            dims.append(tcName);
            if (ec != null) {
                dims.append(" ").append("ens").append(vindex.ensIdx);
            }
            if (vc != null) {
                dims.append(" ").append(vc.getName().toLowerCase());
            }
            dims.append(" ").append(horizDims);
            String vname = Grib2Iosp.makeVariableName(this.tables, this.gribCollection, vindex);
            Variable v3 = new Variable(ncfile, g, null, vname, DataType.FLOAT, dims.toString());
            ncfile.addVariable(g, v3);
            String desc = Grib2Iosp.makeVariableLongName(this.tables, vindex);
            v3.addAttribute(new Attribute("long_name", desc));
            v3.addAttribute(new Attribute("units", Grib2Iosp.makeVariableUnits(this.tables, vindex)));
            v3.addAttribute(new Attribute("missing_value", (Number)Float.valueOf(Float.NaN)));
            if (is2D) {
                String s = this.searchCoord(this.gribCollection, Grib2Utils.getLatLon2DcoordType(desc), gHcs.varIndex);
                if (s == null) {
                    v3.setDimensions(horizDims);
                    String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                    v3.addAttribute(new Attribute("units", units));
                } else {
                    v3.addAttribute(new Attribute("coordinates", s));
                }
            } else {
                v3.addAttribute(new Attribute("grid_mapping", grid_mapping));
            }
            int[] param = new int[]{vindex.discipline, vindex.category, vindex.parameter};
            v3.addAttribute(new Attribute("Grib_Parameter", Array.factory((Object)param)));
            v3.addAttribute(new Attribute("Grib_Level_Type", (Number)vindex.levelType));
            if (vindex.intvType >= 0) {
                v3.addAttribute(new Attribute("Grib_Statistical_Interval_Type", (Number)vindex.intvType));
                CF.CellMethods cm = this.tables.convertTable4_10(vindex.intvType);
                if (cm != null) {
                    v3.addAttribute(new Attribute("cell_methods", tcName + ": " + cm.toString()));
                }
            }
            if (vindex.ensDerivedType >= 0) {
                v3.addAttribute(new Attribute("Grib_Ensemble_Derived_Type", (Number)vindex.ensDerivedType));
            } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
                v3.addAttribute(new Attribute("Grib_Probability_Type", vindex.probabilityName));
            }
            v3.setSPobject((Object)vindex);
        }
    }

    private String searchCoord(GribCollection gc, Grib2Utils.LatLonCoordType type, List<GribCollection.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 198);
                GribCollection.VariableIndex lon = this.searchCoord(list, 199);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.tables, gc, lat) + " " + Grib2Iosp.makeVariableName(this.tables, gc, lon) : null;
            }
            case V: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 200);
                GribCollection.VariableIndex lon = this.searchCoord(list, 201);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.tables, gc, lat) + " " + Grib2Iosp.makeVariableName(this.tables, gc, lon) : null;
            }
            case P: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 202);
                GribCollection.VariableIndex lon = this.searchCoord(list, 203);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.tables, gc, lat) + "  " + Grib2Iosp.makeVariableName(this.tables, gc, lon) : null;
            }
        }
        return null;
    }

    private GribCollection.VariableIndex searchCoord(List<GribCollection.VariableIndex> list, int p) {
        for (GribCollection.VariableIndex vindex : list) {
            if (vindex.discipline != 0 || vindex.category != 2 || vindex.parameter != p) continue;
            return vindex;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.gribCollection != null) {
            this.gribCollection.close();
        }
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array result = this.isTimePartitioned ? this.readDataFromPartition(v2, section) : this.readDataFromCollection(v2, section);
        long took = System.currentTimeMillis() - start;
        return result;
    }

    private Array readDataFromPartition(Variable v2, Section section) throws IOException, InvalidRangeException {
        TimePartition.VariableIndexPartitioned vindexP = (TimePartition.VariableIndexPartitioned)v2.getSPobject();
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindexP.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindexP.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReaderPartitioned dataReader = new DataReaderPartitioned();
        TimeCoordUnion timeCoordP = (TimeCoordUnion)vindexP.getTimeCoord();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            TimeCoordUnion.Val val = timeCoordP.getVal(timeIdx);
            GribCollection.VariableIndex vindex = vindexP.getVindex(val.getPartition());
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    int recordIndex = GribCollection.calcIndex(val.getIndex(), ensIdx, levelIdx, vindex.nens, vindex.nverts);
                    GribCollection.Record record = vindex.records[recordIndex];
                    dataReader.addRecord(vindex, val.getPartition(), record.fileno, record.pos, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private Array readDataFromCollection(Variable v, Section section) throws IOException, InvalidRangeException {
        GribCollection.VariableIndex vindex = (GribCollection.VariableIndex)v.getSPobject();
        if (vindex.records == null) {
            vindex.readRecords();
        }
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindex.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindex.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReader dataReader = new DataReader(vindex);
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    dataReader.addRecord(ensIdx, timeIdx, levelIdx, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private class DataReceiver {
        Array dataArray;
        Range yRange;
        Range xRange;
        int horizSize;

        DataReceiver(Section section, Range yRange, Range xRange) {
            this.dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
            IndexIterator iter = this.dataArray.getIndexIterator();
            while (iter.hasNext()) {
                iter.setFloatNext(Float.NaN);
            }
        }

        void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        Array getArray() {
            return this.dataArray;
        }
    }

    private class DataReader {
        GribCollection.VariableIndex vindex;
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReader(GribCollection.VariableIndex vindex) {
            this.vindex = vindex;
        }

        void addRecord(int ensIdx, int timeIdx, int levIdx, int resultIndex) {
            int recordIndex = GribCollection.calcIndex(timeIdx, ensIdx, levIdx, this.vindex.nens, this.vindex.nverts);
            GribCollection.Record record = this.vindex.records[recordIndex];
            this.records.add(new DataRecord(timeIdx, ensIdx, levIdx, resultIndex, record.fileno, record.pos));
        }

        void read(DataReceiver dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib2Iosp.this.gribCollection.getRaf(dr.fileno);
                    currFile = dr.fileno;
                }
                if (dr.drsPos == -1L) continue;
                float[] data = Grib2Record.readData(rafData, dr.drsPos, this.vindex.group.hcs.gdsNumberPoints, this.vindex.group.hcs.scanMode, this.vindex.group.hcs.nx);
                dataReceiver.addData(data, dr.resultIndex, this.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int ensIdx;
            int timeIdx;
            int levIdx;
            int resultIndex;
            int fileno;
            long drsPos;

            DataRecord(int timeIdx, int ensIdx, int levIdx, int resultIndex, int fileno, long drsPos) {
                this.ensIdx = ensIdx;
                this.timeIdx = timeIdx;
                this.levIdx = levIdx;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.drsPos = drsPos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = this.fileno - o.fileno;
                return r == 0 ? (int)(this.drsPos - o.drsPos) : r;
            }
        }
    }

    private class DataReaderPartitioned {
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReaderPartitioned() {
        }

        void addRecord(GribCollection.VariableIndex vindex, int partno, int fileno, long drsPos, int resultIndex) {
            this.records.add(new DataRecord(partno, vindex, resultIndex, fileno, drsPos));
        }

        void read(DataReceiver dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currPartno = -1;
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.partno != currPartno || dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib2Iosp.this.timePartition.getRaf(dr.partno, dr.fileno);
                    currFile = dr.fileno;
                    currPartno = dr.partno;
                }
                if (dr.drsPos == -1L) continue;
                float[] data = Grib2Record.readData(rafData, dr.drsPos, dr.vindex.group.hcs.gdsNumberPoints, dr.vindex.group.hcs.scanMode, dr.vindex.group.hcs.nx);
                dataReceiver.addData(data, dr.resultIndex, dr.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int partno;
            GribCollection.VariableIndex vindex;
            int resultIndex;
            int fileno;
            long drsPos;

            DataRecord(int partno, GribCollection.VariableIndex vindex, int resultIndex, int fileno, long drsPos) {
                this.partno = partno;
                this.vindex = vindex;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.drsPos = drsPos == 0L ? -1L : drsPos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = this.partno - o.partno;
                if (r != 0) {
                    return r;
                }
                r = this.fileno - o.fileno;
                return r != 0 ? r : (int)(this.drsPos - o.drsPos);
            }
        }
    }
}

