/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

public class Grib2Rectilyser {
    private final Grib2Tables tables;
    private final int gdsHash;
    private final List<Grib2Record> records;
    private List<VariableBag> gribvars;
    private final List<TimeCoord> timeCoords = new ArrayList<TimeCoord>();
    private final List<VertCoord> vertCoords = new ArrayList<VertCoord>();
    private final List<EnsCoord> ensCoords = new ArrayList<EnsCoord>();

    public Grib2Rectilyser(List<Grib2Record> records, int gdsHash) {
        this.records = records;
        this.gdsHash = gdsHash;
        Grib2Record first = records.get(0);
        Grib2SectionIdentification ids = first.getId();
        this.tables = Grib2Tables.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version());
    }

    public List<Grib2Record> getRecords() {
        return this.records;
    }

    public List<VariableBag> getGribvars() {
        return this.gribvars;
    }

    public List<TimeCoord> getTimeCoords() {
        return this.timeCoords;
    }

    public List<VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public List<EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public void make(Formatter f, Counter counter) throws IOException {
        HashMap<Integer, VariableBag> vbHash = new HashMap<Integer, VariableBag>(100);
        for (Grib2Record gr : this.records) {
            int cdmHash = gr.cdmVariableHash(this.gdsHash);
            VariableBag bag = (VariableBag)vbHash.get(cdmHash);
            if (bag == null) {
                bag = new VariableBag(gr);
                vbHash.put(cdmHash, bag);
            }
            bag.atomList.add(new Record(gr));
        }
        this.gribvars = new ArrayList(vbHash.values());
        Collections.sort(this.gribvars);
        for (VariableBag vb : this.gribvars) {
            TimeCoord use = null;
            boolean isUniform = this.checkTimeCoordsUniform(vb);
            use = vb.first.getPDS().isInterval() ? this.makeTimeCoordsIntv(vb, isUniform) : this.makeTimeCoords(vb, isUniform);
            vb.timeCoordIndex = TimeCoord.findCoord(this.timeCoords, use);
        }
        for (VariableBag vb : this.gribvars) {
            VertCoord vc = this.makeVertCoord(vb);
            if (!vc.isVertDimensionUsed()) continue;
            vb.vertCoordIndex = VertCoord.findCoord(this.vertCoords, vc);
        }
        for (VariableBag vb : this.gribvars) {
            EnsCoord ec = this.makeEnsCoord(vb);
            if (ec == null) continue;
            vb.ensCoordIndex = EnsCoord.findCoord(this.ensCoords, ec);
        }
        int tot_recordMap = 0;
        int tot_records = 0;
        int tot_dups = 0;
        for (VariableBag vb : this.gribvars) {
            TimeCoord tc = this.timeCoords.get(vb.timeCoordIndex);
            VertCoord vc = vb.vertCoordIndex < 0 ? null : this.vertCoords.get(vb.vertCoordIndex);
            EnsCoord ec = vb.ensCoordIndex < 0 ? null : this.ensCoords.get(vb.ensCoordIndex);
            int ntimes = tc.getSize();
            int nverts = vc == null ? 1 : vc.getSize();
            int nens = ec == null ? 1 : ec.getSize();
            vb.recordMap = new Record[ntimes * nverts * nens];
            int dups = 0;
            for (Record r : vb.atomList) {
                int ensIdx;
                int vertIdx;
                int timeIdx;
                int n = timeIdx = r.tcIntvCoord != null ? tc.findInterval(r.tcIntvCoord) : tc.findIdx(r.tcCoord);
                if (timeIdx < 0) {
                    timeIdx = r.tcIntvCoord != null ? tc.findInterval(r.tcIntvCoord) : tc.findIdx(r.tcCoord);
                    throw new IllegalStateException("Cant find time coord " + r.tcCoord);
                }
                int n2 = vertIdx = vb.vertCoordIndex < 0 ? 0 : vc.findIdx(r.vcCoord);
                if (vertIdx < 0) {
                    vertIdx = vc.findIdx(r.vcCoord);
                    throw new IllegalStateException("Cant find vert coord " + r.vcCoord);
                }
                int n3 = ensIdx = vb.ensCoordIndex < 0 ? 0 : ec.findIdx(r.ecCoord);
                if (ensIdx < 0) {
                    ensIdx = ec.findIdx(r.ecCoord);
                    throw new IllegalStateException("Cant find ens coord " + r.ecCoord);
                }
                int index = GribCollection.calcIndex(timeIdx, ensIdx, vertIdx, nens, nverts);
                if (vb.recordMap[index] != null) {
                    ++dups;
                }
                vb.recordMap[index] = r;
            }
            tot_recordMap += vb.recordMap.length;
            tot_records += vb.atomList.size();
            tot_dups += dups;
        }
        f.format("records unique=%d total=%d dups=%d (%f) %n", tot_recordMap, tot_records, tot_dups, Float.valueOf((float)tot_dups / (float)tot_records));
        counter.recordsUnique += tot_recordMap;
        counter.records += tot_records;
        counter.dups += tot_dups;
        counter.vars += this.gribvars.size();
    }

    private VertCoord makeVertCoord(VariableBag vb) {
        Grib2Pds pdsFirst = vb.first.getPDS();
        VertCoord.VertUnit vertUnit = Grib2Utils.getLevelUnit(pdsFirst.getLevelType1());
        boolean isLayer = Grib2Utils.isLayer(vb.first);
        HashSet<VertCoord.Level> coords = new HashSet<VertCoord.Level>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            r.vcCoord = new VertCoord.Level(pds.getLevelValue1(), pds.getLevelValue2());
            coords.add(r.vcCoord);
        }
        ArrayList<VertCoord.Level> vlist = new ArrayList<VertCoord.Level>(coords);
        Collections.sort(vlist);
        if (!vertUnit.isPositiveUp) {
            Collections.reverse(vlist);
        }
        return new VertCoord(vlist, vertUnit, isLayer);
    }

    private EnsCoord makeEnsCoord(VariableBag vb) {
        if (!vb.first.getPDS().isEnsemble()) {
            return null;
        }
        HashSet<EnsCoord.Coord> coords = new HashSet<EnsCoord.Coord>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            r.ecCoord = new EnsCoord.Coord(pds.getPerturbationType(), pds.getPerturbationNumber());
            coords.add(r.ecCoord);
        }
        ArrayList<EnsCoord.Coord> elist = new ArrayList<EnsCoord.Coord>(coords);
        Collections.sort(elist);
        return new EnsCoord(elist);
    }

    private boolean checkTimeCoordsUniform(VariableBag vb) {
        boolean isUniform = true;
        CalendarDate refDate = null;
        int timeUnit = -1;
        boolean timeUnitOk = true;
        for (Record r : vb.atomList) {
            int offset;
            CalendarDate date2;
            Grib2Pds pds = r.gr.getPDS();
            int unit = pds.getTimeUnit();
            if (timeUnit < 0) {
                timeUnit = unit;
                vb.timeUnit = Grib2Utils.getCalendarPeriod(timeUnit);
            } else if (unit != timeUnit) {
                isUniform = false;
            }
            CalendarDate cd = r.gr.getReferenceDate();
            if (refDate == null) {
                refDate = cd;
            } else if (!cd.equals((Object)refDate)) {
                isUniform = false;
                if (cd.compareTo(refDate) < 0) {
                    refDate = cd;
                }
            }
            int time = pds.getForecastTime();
            CalendarDate date1 = cd.add(Grib2Utils.getCalendarPeriod(unit).multiply(time));
            if (date1.equals((Object)(date2 = refDate.add(vb.timeUnit.multiply(offset = TimeCoord.getOffset(refDate, date1, vb.timeUnit)))))) continue;
            timeUnitOk = false;
        }
        if (!timeUnitOk) {
            timeUnit = 0;
        }
        vb.timeUnit = Grib2Utils.getCalendarPeriod(timeUnit);
        vb.refDate = refDate;
        return isUniform;
    }

    private TimeCoord makeTimeCoords(VariableBag vb, boolean uniform) {
        HashSet<Integer> times = new HashSet<Integer>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            int time = pds.getForecastTime();
            CalendarPeriod duration = pds.getTimeDuration();
            if (uniform) {
                r.tcCoord = time;
            } else {
                CalendarDate refDate = r.gr.getReferenceDate();
                CalendarDate date = refDate.add(duration.multiply(time));
                r.tcCoord = TimeCoord.getOffset(vb.refDate, date, vb.timeUnit);
            }
            times.add(r.tcCoord);
        }
        ArrayList tlist = new ArrayList(times);
        Collections.sort(tlist);
        return new TimeCoord(vb.refDate, vb.timeUnit, tlist);
    }

    private TimeCoord makeTimeCoordsIntv(VariableBag vb, boolean uniform) {
        HashSet<TimeCoord.Tinv> times = new HashSet<TimeCoord.Tinv>();
        for (Record r : vb.atomList) {
            Grib2Pds pds = r.gr.getPDS();
            int[] timeb = this.tables.getForecastTimeInterval(r.gr);
            if (uniform) {
                r.tcIntvCoord = new TimeCoord.Tinv(timeb[0], timeb[1]);
                times.add(r.tcIntvCoord);
                continue;
            }
            TimeCoord.Tinv org = new TimeCoord.Tinv(timeb[0], timeb[1]);
            CalendarPeriod fromUnit = Grib2Utils.getCalendarPeriod(pds.getTimeUnit());
            r.tcIntvCoord = org.convertReferenceDate(r.gr.getReferenceDate(), fromUnit, vb.refDate, vb.timeUnit);
            times.add(r.tcIntvCoord);
        }
        ArrayList tlist = new ArrayList(times);
        Collections.sort(tlist);
        return new TimeCoord(vb.refDate, vb.timeUnit, tlist);
    }

    public void dump(Formatter f, Grib2Tables tables) {
        Object coord;
        int i;
        f.format("%nTime Coordinates%n", new Object[0]);
        for (i = 0; i < this.timeCoords.size(); ++i) {
            TimeCoord time = this.timeCoords.get(i);
            f.format("  %d: (%d) %s%n", i, time.getSize(), time);
        }
        f.format("%nVert Coordinates%n", new Object[0]);
        for (i = 0; i < this.vertCoords.size(); ++i) {
            coord = this.vertCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((VertCoord)coord).getSize(), coord);
        }
        f.format("%nEns Coordinates%n", new Object[0]);
        for (i = 0; i < this.ensCoords.size(); ++i) {
            coord = this.ensCoords.get(i);
            f.format("  %d: (%d) %s%n", i, ((EnsCoord)coord).getSize(), coord);
        }
        f.format("%nVariables%n", new Object[0]);
        f.format("%n  %3s %3s %3s%n", "time", "vert", "ens");
        for (VariableBag vb : this.gribvars) {
            String vname = tables.getVariableName(vb.first);
            f.format("  %3d %3d %3d %s records = %d density = %d/%d", vb.timeCoordIndex, vb.vertCoordIndex, vb.ensCoordIndex, vname, vb.atomList.size(), vb.countDensity(), vb.recordMap.length);
            if (vb.countDensity() != vb.recordMap.length) {
                f.format(" HEY!!", new Object[0]);
            }
            f.format("%n", new Object[0]);
        }
    }

    public class VariableBag
    implements Comparable<VariableBag> {
        Grib2Record first;
        List<Record> atomList = new ArrayList<Record>(100);
        int timeCoordIndex = -1;
        int vertCoordIndex = -1;
        int ensCoordIndex = -1;
        CalendarDate refDate;
        CalendarPeriod timeUnit;
        Record[] recordMap;
        long pos;
        int length;

        private VariableBag(Grib2Record first) {
            this.first = first;
        }

        @Override
        public int compareTo(VariableBag o) {
            return Grib2Utils.getVariableName(this.first).compareTo(Grib2Utils.getVariableName(o.first));
        }

        int countDensity() {
            int count = 0;
            for (Record r : this.recordMap) {
                if (r == null) continue;
                ++count;
            }
            return count;
        }
    }

    public class Record {
        Grib2Record gr;
        int tcCoord;
        TimeCoord.Tinv tcIntvCoord;
        VertCoord.Level vcCoord;
        EnsCoord.Coord ecCoord;

        private Record(Grib2Record gr) {
            this.gr = gr;
        }
    }

    public static class Counter {
        int recordsUnique;
        int records;
        int dups;
        int vars;
    }
}

