/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;

public abstract class LocalTables
extends Grib2Tables {
    protected final Map<Integer, Grib2Tables.TableEntry> local = new HashMap<Integer, Grib2Tables.TableEntry>(100);

    LocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
        this.initLocalTable();
    }

    protected abstract void initLocalTable();

    @Override
    public List getParameters() {
        ArrayList<Grib2Tables.TableEntry> result = new ArrayList<Grib2Tables.TableEntry>();
        for (Grib2Tables.TableEntry p : this.local.values()) {
            result.add(p);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getVariableName(int discipline, int category, int parameter) {
        if (category <= 191 && parameter <= 191) {
            return super.getVariableName(discipline, category, parameter);
        }
        GribTables.Parameter te = this.getParameter(discipline, category, parameter);
        if (te == null) {
            return super.getVariableName(discipline, category, parameter);
        }
        return te.getName();
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return WmoCodeTable.getParameterEntry(discipline, category, number);
        }
        return this.local.get(LocalTables.makeHash(discipline, category, number));
    }
}

