/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

@ThreadSafe
public abstract class GribCollection {
    private static final Logger logger = LoggerFactory.getLogger(GribCollection.class);
    public static final String IDX_EXT = ".ncx";
    public static final long MISSING_RECORD = -1L;
    private static FileCache fileCache;
    private static final FileFactory fileFactory;
    protected final String name;
    public final File directory;
    private Set<String> groupNames = new HashSet<String>(5);
    public int center;
    public int subcenter;
    public int master;
    public int local;
    public int genProcessType;
    public int genProcessId;
    public int backProcessId;
    public List<String> filenames;
    public List<GroupHcs> groups;
    public List<Parameter> params;
    public RandomAccessFile raf;
    public String rafLocation;
    private File indexFile;

    public static void initFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        fileCache = new FileCache("GribCollectionRafCache ", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static FileCache getFileCache() {
        return fileCache;
    }

    public static int calcIndex(int timeIdx, int ensIdx, int vertIdx, int nens, int nverts) {
        if (nens == 0) {
            nens = 1;
        }
        if (nverts == 0) {
            nverts = 1;
        }
        return vertIdx + ensIdx * nverts + timeIdx * nverts * nens;
    }

    public static File getIndexFile(CollectionManager dcm) {
        return new File(new File(dcm.getRoot()), dcm.getCollectionName() + IDX_EXT);
    }

    public String getName() {
        return this.name;
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public File getIndexFile() {
        if (this.indexFile == null) {
            File f = new File(this.directory, this.name + IDX_EXT);
            this.indexFile = DiskCache.getFile((String)f.getPath(), (boolean)false);
        }
        return this.indexFile;
    }

    public List<GroupHcs> getGroups() {
        return this.groups;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public int getCenter() {
        return this.center;
    }

    public int getSubcenter() {
        return this.subcenter;
    }

    public int getMaster() {
        return this.master;
    }

    public int getLocal() {
        return this.local;
    }

    public int getGenProcessType() {
        return this.genProcessType;
    }

    public int getGenProcessId() {
        return this.genProcessId;
    }

    public int getBackProcessId() {
        return this.backProcessId;
    }

    protected GribCollection(String name, File directory) {
        this.name = name;
        this.directory = directory;
    }

    public abstract NetcdfDataset getNetcdfDataset(String var1, String var2) throws IOException;

    public abstract GridDataset getGridDataset(String var1, String var2) throws IOException;

    public GroupHcs getGroup(int index) {
        return this.groups.get(index);
    }

    public GroupHcs findGroup(String name) {
        for (GroupHcs g : this.getGroups()) {
            if (!g.getGroupName().equals(name)) continue;
            return g;
        }
        return null;
    }

    public int findGroupIdx(String name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            GroupHcs g = this.groups.get(i);
            if (!g.getGroupName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public RandomAccessFile getRaf(int fileno) throws IOException {
        String filename = this.filenames.get(fileno);
        RandomAccessFile want = this.getRaf(filename);
        want.order(0);
        return want;
    }

    private RandomAccessFile getRaf(String location) throws IOException {
        if (fileCache != null) {
            return (RandomAccessFile)fileCache.acquire(fileFactory, location, null);
        }
        return new RandomAccessFile(location, "r");
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    public VariableIndex makeVariableIndex(GroupHcs g, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, int ensDerivedType, int probType, String probabilityName, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
        return new VariableIndex(g, tableVersion, discipline, category, parameter, levelType, isLayer, intvType, ensDerivedType, probType, probabilityName, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
    }

    public void showIndex(Formatter f) {
        f.format("Files (%d)%n", this.filenames.size());
        for (String file : this.filenames) {
            f.format("  %s%n", file);
        }
        f.format("%n", new Object[0]);
        for (GroupHcs g : this.groups) {
            f.format("Hcs = %s%n", g.hcs);
            f.format("%nVarIndex (%d)%n", g.varIndex.size());
            for (VariableIndex v : g.varIndex) {
                f.format("  %s%n", v);
            }
            f.format("%nTimeCoords (%d)%n", g.timeCoords.size());
            for (int i = 0; i < g.timeCoords.size(); ++i) {
                TimeCoord tc = g.timeCoords.get(i);
                f.format(" %d: %s%n", i, tc);
            }
        }
    }

    public GroupHcs makeGroup() {
        return new GroupHcs();
    }

    public static void main(String[] args) throws IOException {
        System.out.printf("%d%n", Long.MAX_VALUE);
        System.out.printf("%d%n", Long.MIN_VALUE);
    }

    static {
        fileFactory = new FileFactory(){

            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                return new RandomAccessFile(location, "r");
            }
        };
    }

    protected static class MyNetcdfFile
    extends NetcdfFile {
        public MyNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }

    public static class Record {
        public int fileno;
        public long pos;

        public Record(int fileno, long pos, boolean missing) {
            this.fileno = fileno;
            this.pos = pos;
            if (missing) {
                this.pos = -1L;
            }
        }
    }

    public class VariableIndex
    implements Comparable<VariableIndex> {
        public final int tableVersion;
        public final int discipline;
        public final int category;
        public final int parameter;
        public final int levelType;
        public final int intvType;
        public final int ensDerivedType;
        public final int probType;
        public final String probabilityName;
        public final boolean isLayer;
        public final int cdmHash;
        public final int timeIdx;
        public final int vertIdx;
        public final int ensIdx;
        public final long recordsPos;
        public final int recordsLen;
        public final GroupHcs group;
        public int ntimes;
        public int nverts;
        public int nens;
        public Record[] records;
        int partTimeCoordIdx;

        public VariableIndex(GroupHcs g, int tableVersion, int discipline, int category, int parameter, int levelType, boolean isLayer, int intvType, int ensDerivedType, int probType, String probabilityName, int cdmHash, int timeIdx, int vertIdx, int ensIdx, long recordsPos, int recordsLen) {
            this.group = g;
            this.tableVersion = tableVersion;
            this.discipline = discipline;
            this.category = category;
            this.parameter = parameter;
            this.levelType = levelType;
            this.isLayer = isLayer;
            this.intvType = intvType;
            this.ensDerivedType = ensDerivedType;
            this.probabilityName = probabilityName;
            this.probType = probType;
            this.cdmHash = cdmHash;
            this.timeIdx = timeIdx;
            this.vertIdx = vertIdx;
            this.ensIdx = ensIdx;
            this.recordsPos = recordsPos;
            this.recordsLen = recordsLen;
        }

        public TimeCoord getTimeCoord() {
            return this.timeIdx < 0 ? null : this.group.timeCoords.get(this.timeIdx);
        }

        public VertCoord getVertCoord() {
            return this.vertIdx < 0 ? null : this.group.vertCoords.get(this.vertIdx);
        }

        public EnsCoord getEnsCoord() {
            return this.ensIdx < 0 ? null : this.group.ensCoords.get(this.ensIdx);
        }

        public String toString() {
            return "VariableIndex{group=" + this.group.getGroupName() + ", discipline=" + this.discipline + ", category=" + this.category + ", parameter=" + this.parameter + ", levelType=" + this.levelType + ", intvType=" + this.intvType + ", ensDerivedType=" + this.ensDerivedType + ", probabilityName='" + this.probabilityName + '\'' + ", cdmHash=" + this.cdmHash + ", timeIdx=" + this.timeIdx + ", vertIdx=" + this.vertIdx + ", ensIdx=" + this.ensIdx + '}';
        }

        public String toStringComplete() {
            return "VariableIndex{discipline=" + this.discipline + ", category=" + this.category + ", parameter=" + this.parameter + ", levelType=" + this.levelType + ", intvType=" + this.intvType + ", ensDerivedType=" + this.ensDerivedType + ", probabilityName='" + this.probabilityName + '\'' + ", cdmHash=" + this.cdmHash + ", timeIdx=" + this.timeIdx + ", vertIdx=" + this.vertIdx + ", ensIdx=" + this.ensIdx + ", recordsLen=" + this.recordsLen + ", recordsPos=" + this.recordsPos + ", group=" + this.group + ", ntimes=" + this.ntimes + ", nverts=" + this.nverts + ", nens=" + this.nens + ", records=" + (this.records == null ? null : Arrays.asList(this.records)) + '}';
        }

        public Record[] getRecords() throws IOException {
            this.readRecords();
            return this.records;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readRecords() throws IOException {
            if (this.records != null) {
                return;
            }
            byte[] b = new byte[this.recordsLen];
            Object object = GribCollection.this.raf;
            synchronized (object) {
                GribCollection.this.raf.seek(this.recordsPos);
                GribCollection.this.raf.readFully(b);
            }
            object = this;
            synchronized (object) {
                GribCollectionProto.VariableRecords proto = GribCollectionProto.VariableRecords.parseFrom(b);
                int cdmHash = proto.getCdmHash();
                if (cdmHash != this.cdmHash) {
                    throw new IllegalStateException("Corrupted index");
                }
                int n = proto.getRecordsCount();
                Record[] recordsTemp = new Record[n];
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.Record pr = proto.getRecords(i);
                    recordsTemp[i] = new Record(pr.getFileno(), pr.getPos(), pr.getMissing());
                }
                this.records = recordsTemp;
            }
        }

        @Override
        public int compareTo(VariableIndex o) {
            int r = this.discipline - o.discipline;
            if (r != 0) {
                return r;
            }
            r = this.category - o.category;
            if (r != 0) {
                return r;
            }
            r = this.parameter - o.parameter;
            if (r != 0) {
                return r;
            }
            r = this.levelType - o.levelType;
            if (r != 0) {
                return r;
            }
            r = this.intvType - o.intvType;
            return r;
        }
    }

    public class GroupHcs
    implements Comparable<GroupHcs> {
        private String name;
        public GdsHorizCoordSys hcs;
        public List<VariableIndex> varIndex;
        public List<TimeCoord> timeCoords;
        public List<VertCoord> vertCoords;
        public List<EnsCoord> ensCoords;
        public int[] filenose;
        public List<TimeCoordUnion> timeCoordPartitions;

        public void setHorizCoordSystem(GdsHorizCoordSys hcs) {
            this.hcs = hcs;
            this.setName();
        }

        private void setName() {
            String base;
            String tryit = base = this.hcs.getName() + "-" + this.hcs.nx + "X" + this.hcs.ny;
            int count = 1;
            while (GribCollection.this.groupNames.contains(tryit)) {
                tryit = base + "-" + ++count;
            }
            this.name = tryit;
            GribCollection.this.groupNames.add(this.name);
        }

        public GribCollection getGribCollection() {
            return GribCollection.this;
        }

        public String getGroupName() {
            return this.name;
        }

        @Override
        public int compareTo(GroupHcs o) {
            return this.getGroupName().compareTo(o.getGroupName());
        }

        public List<String> getFilenames() {
            ArrayList<String> result = new ArrayList<String>();
            for (int fileno : this.filenose) {
                result.add(GribCollection.this.filenames.get(fileno));
            }
            Collections.sort(result);
            return result;
        }

        public VariableIndex findAnyVariableWithTime(int usesTimeIndex) {
            for (VariableIndex vi : this.varIndex) {
                if (vi.timeIdx != usesTimeIndex) continue;
                return vi;
            }
            return null;
        }

        public VariableIndex findVariableByHash(int cdmHash) {
            for (VariableIndex vi : this.varIndex) {
                if (vi.cdmHash != cdmHash) continue;
                return vi;
            }
            return null;
        }

        public CalendarDateRange getTimeCoverage() {
            TimeCoord useTc = null;
            for (TimeCoord tc : this.timeCoords) {
                if (useTc != null && useTc.getSize() >= tc.getSize()) continue;
                useTc = tc;
            }
            return useTc == null ? null : useTc.getCalendarRange();
        }
    }
}

