/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import thredds.inventory.CollectionManager;
import thredds.inventory.DatasetCollectionMFiles;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.grib1.Grib1CollectionBuilder;
import ucar.nc2.grib.grib1.Grib1Iosp;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Collection
extends GribCollection {
    public Grib1Collection(String name, File directory) {
        super(name, directory);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String groupName, String filename) throws IOException {
        GribCollection.GroupHcs want = this.findGroup(groupName);
        if (want == null) {
            return null;
        }
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(want);
            GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        for (String file : this.filenames) {
            if (!file.endsWith(filename)) continue;
            Formatter f = new Formatter();
            GribCollection gc = Grib1CollectionBuilder.createFromSingleFile(new File(file), f);
            Grib1Iosp iosp = new Grib1Iosp(gc);
            GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        return null;
    }

    @Override
    public ucar.nc2.dt.GridDataset getGridDataset(String groupName, String filename) throws IOException {
        GribCollection.GroupHcs want = this.findGroup(groupName);
        if (want == null) {
            return null;
        }
        if (filename == null) {
            Grib1Iosp iosp = new Grib1Iosp(want);
            GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        for (String file : this.filenames) {
            if (!file.endsWith(filename)) continue;
            Formatter f = new Formatter();
            GribCollection gc = Grib1CollectionBuilder.createFromSingleFile(new File(file), f);
            Grib1Iosp iosp = new Grib1Iosp(gc);
            GribCollection.MyNetcdfFile ncfile = new GribCollection.MyNetcdfFile((IOServiceProvider)iosp, null, this.getIndexFile().getPath(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    public static void make(String name, String spec) throws IOException {
        long start = System.currentTimeMillis();
        Formatter f = new Formatter();
        DatasetCollectionMFiles dcm = new DatasetCollectionMFiles(name, spec, f);
        File idxFile = new File(dcm.getRoot(), name);
        boolean ok = Grib1CollectionBuilder.writeIndexFile(idxFile, (CollectionManager)dcm, f);
        System.out.printf("GribCollectionBuilder.writeIndexFile ok = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        System.out.printf("%s%n", f);
        System.out.printf("That took %d msecs%n", took);
    }

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-help")) {
                System.out.printf("usage: ucar.nc2.grib.GribCollection [-make name collSpec] [-read filename]%n", new Object[0]);
                break;
            }
            if (arg.equalsIgnoreCase("-make")) {
                Grib1Collection.make(args[i + 1], args[i + 2]);
                break;
            }
            if (!arg.equalsIgnoreCase("-read")) continue;
            File f = new File(args[i + 1]);
            RandomAccessFile raf = new RandomAccessFile(f.getPath(), "r");
            GribCollection gc = Grib1CollectionBuilder.createFromIndex(f.getName(), f.getParentFile(), raf);
            gc.showIndex(new Formatter(System.out));
            break;
        }
    }
}

