/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jsoup.Jsoup;
import org.jsoup.select.Elements;
import ucar.unidata.util.StringUtil2;

public class NcepHtmlScraper {
    private boolean debug = false;
    private boolean show = false;
    private int[] tableVersions = new int[]{2, 0, 128, 129, 130, 131, 133, 140, 0, 0, 141};
    String dirOut = "C:\\dev\\github\\thredds\\grib\\src\\main\\resources\\resources\\grib1\\ncep\\";

    void parseTableA() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/tablea.html";
        String base = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/";
        File input = new File("C:\\dev\\github\\thredds\\grib\\src\\main\\sources\\ncep\\ON388.TableA.htm");
        org.jsoup.nodes.Document doc = Jsoup.parse((File)input, (String)"UTF-8", (String)base);
        System.out.printf("%s%n", doc);
        org.jsoup.nodes.Element table = doc.select("table").first();
        ArrayList<Stuff> stuff = new ArrayList<Stuff>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (this.debug) {
                System.out.printf(" %d=", cols.size());
                for (org.jsoup.nodes.Element col : cols) {
                    System.out.printf("%s:", col.text());
                }
                System.out.printf("%n", new Object[0]);
            }
            if (cols.size() != 2) continue;
            String snum = StringUtil2.cleanup((String)cols.get(0).text()).trim();
            try {
                int pnum = Integer.parseInt(snum);
                String desc = StringUtil2.cleanup((String)cols.get(1).text()).trim();
                if (desc.startsWith("Reserved")) {
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                System.out.printf("%d == %s%n", pnum, desc);
                stuff.add(new Stuff(pnum, desc));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        this.writeTableAXml("NCEP GRIB-1 Table A", source, "ncepTableA.xml", stuff);
    }

    private void writeTableAXml(String name, String source, String filename, List<Stuff> stuff) throws IOException {
        Element rootElem = new Element("tableA");
        Document doc = new Document(rootElem);
        rootElem.addContent((Content)new Element("title").setText(name));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Stuff p : stuff) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.no));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        FileOutputStream fout = new FileOutputStream(this.dirOut + filename);
        fout.write(x.getBytes());
        fout.close();
        if (this.show) {
            System.out.printf("%s%n", x);
        }
    }

    void parseTable2() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/table2.html";
        File input = new File("C:\\dev\\github\\thredds\\grib\\src\\main\\sources\\ncep\\on388.2011-11-18.htm");
        org.jsoup.nodes.Document doc = Jsoup.parse((File)input, (String)"UTF-8", (String)"http://www.nco.ncep.noaa.gov/pmb/docs/on388/");
        int count = 0;
        for (org.jsoup.nodes.Element e : doc.select("big")) {
            System.out.printf("%d == %s%n=%n", count++, e.text());
        }
        org.jsoup.nodes.Element body = doc.select("body").first();
        Elements tables = body.select("table");
        for (int i = 0; i < this.tableVersions.length; ++i) {
            if (this.tableVersions[i] == 0) continue;
            org.jsoup.nodes.Element table = tables.select("table").get(i);
            List<Param> params = this.readTable2(table);
            String name = "NCEP Table Version " + this.tableVersions[i];
            String filename = "ncepGrib1-" + this.tableVersions[i];
            this.writeTable2Wgrib(name, source, filename + ".tab", params);
            this.writeTable2Xml(name, source, filename + ".xml", params);
        }
    }

    private List<Param> readTable2(org.jsoup.nodes.Element table) {
        ArrayList<Param> result = new ArrayList<Param>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (this.debug) {
                System.out.printf(" %d=", cols.size());
                for (org.jsoup.nodes.Element col : cols) {
                    System.out.printf("%s:", col.text());
                }
                System.out.printf("%n", new Object[0]);
            }
            if (cols.size() != 4) continue;
            String snum = StringUtil2.cleanup((String)cols.get(0).text()).trim();
            try {
                int pnum = Integer.parseInt(snum);
                String desc = StringUtil2.cleanup((String)cols.get(1).text()).trim();
                if (desc.startsWith("Reserved")) {
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                result.add(new Param(pnum, desc, cols.get(2).text(), cols.get(3).text()));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        return result;
    }

    private void writeTable2Xml(String name, String source, String filename, List<Param> params) throws IOException {
        Element rootElem = new Element("parameterMap");
        Document doc = new Document(rootElem);
        rootElem.addContent((Content)new Element("title").setText(name));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Param p : params) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.pnum));
            paramElem.addContent((Content)new Element("shortName").setText(p.name));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            paramElem.addContent((Content)new Element("units").setText(p.unit));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        FileOutputStream fout = new FileOutputStream(this.dirOut + filename);
        fout.write(x.getBytes());
        fout.close();
        if (this.show) {
            System.out.printf("%s%n", x);
        }
    }

    private void writeTable2Wgrib(String name, String source, String filename, List<Param> params) throws IOException {
        Formatter f = new Formatter();
        f.format("# %s%n", name);
        f.format("# %s%n", source);
        for (Param p : params) {
            f.format("%3d:%s:%s [%s]%n", p.pnum, p.name, p.desc, p.unit);
        }
        FileOutputStream fout = new FileOutputStream(this.dirOut + filename);
        fout.write(f.toString().getBytes());
        fout.close();
        if (this.show) {
            System.out.printf("%s%n", f);
        }
    }

    public static void main(String[] args) throws IOException {
        NcepHtmlScraper scraper = new NcepHtmlScraper();
        scraper.parseTableA();
    }

    private class Param {
        int pnum;
        String desc;
        String unit;
        String name;

        private Param(int pnum, String desc, String unit, String name) {
            this.pnum = pnum;
            this.desc = desc;
            this.unit = StringUtil2.cleanup((String)unit);
            this.name = StringUtil2.cleanup((String)name);
        }
    }

    private class Stuff {
        int no;
        String desc;

        private Stuff(int no, String desc) {
            this.no = no;
            this.desc = desc;
        }
    }
}

