/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.Formatter;
import ucar.nc2.grib.grib2.Grib2DataReader;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Record {
    private final Grib2SectionIndicator is;
    private final Grib2SectionIdentification id;
    private Grib2SectionLocalUse lus;
    private Grib2SectionGridDefinition gdss;
    private Grib2SectionProductDefinition pdss;
    private Grib2SectionDataRepresentation drs;
    private Grib2SectionBitMap bms;
    private Grib2SectionData dataSection;
    private final byte[] header;
    private int file;
    private Grib2Pds pds2 = null;
    private int hashcode = 0;

    public Grib2Record(byte[] header, Grib2SectionIndicator is, Grib2SectionIdentification id, Grib2SectionLocalUse lus, Grib2SectionGridDefinition gdss, Grib2SectionProductDefinition pdss, Grib2SectionDataRepresentation drs, Grib2SectionBitMap bms, Grib2SectionData dataSection) {
        this.header = header;
        this.is = is;
        this.id = id;
        this.lus = lus;
        this.gdss = gdss;
        this.pdss = pdss;
        this.drs = drs;
        this.bms = bms;
        this.dataSection = dataSection;
    }

    Grib2Record(Grib2Record from) {
        this.header = from.header;
        this.is = from.is;
        this.id = from.id;
        this.lus = from.lus;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.drs = from.drs;
        this.bms = from.bms;
        this.dataSection = from.dataSection;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib2SectionIndicator getIs() {
        return this.is;
    }

    public Grib2SectionIdentification getId() {
        return this.id;
    }

    public boolean hasLocalUseSection() {
        return this.lus != null && this.lus.getRawBytes() != null;
    }

    public Grib2SectionLocalUse getLocalUseSection() {
        return this.lus;
    }

    public Grib2SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib2SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib2SectionDataRepresentation getDataRepresentationSection() {
        return this.drs;
    }

    public Grib2SectionBitMap getBitmapSection() {
        return this.bms;
    }

    public Grib2SectionData getDataSection() {
        return this.dataSection;
    }

    public int getDiscipline() {
        return this.is.getDiscipline();
    }

    public CalendarDate getReferenceDate() {
        return this.id.getReferenceDate();
    }

    public Grib2Pds getPDS() {
        if (this.pds2 == null) {
            try {
                this.pds2 = this.pdss.getPDS();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.pds2;
    }

    public void show(Formatter f) {
        f.format("discipline=%d ", this.is.getDiscipline());
        Grib2Pds pds = this.getPDS();
        pds.show(f);
    }

    public void setLus(Grib2SectionLocalUse lus) {
        this.lus = lus;
    }

    public void setGdss(Grib2SectionGridDefinition gdss) {
        this.gdss = gdss;
    }

    public void setPdss(Grib2SectionProductDefinition pdss) {
        this.pdss = pdss;
    }

    public void setDrs(Grib2SectionDataRepresentation drs) {
        this.drs = drs;
    }

    public void setBms(Grib2SectionBitMap bms) {
        this.bms = bms;
    }

    public void setDataSection(Grib2SectionData dataSection) {
        this.dataSection = dataSection;
    }

    public int cdmVariableHash(int gdsHash) {
        if (this.hashcode == 0 || gdsHash != 0) {
            int result = 17;
            result = gdsHash == 0 ? (result += result * 37 + this.gdss.getGDS().hashCode()) : (result += result * 37 + gdsHash);
            Grib2Pds pds2 = this.getPDS();
            result += result * 37 + this.getDiscipline();
            result += result * 37 + pds2.getLevelType1();
            if (Grib2Utils.isLayer(this)) {
                result += result * 37 + 1;
            }
            result += result * 37 + pds2.getParameterCategory();
            result += result * 37 + pds2.getTemplateNumber();
            if (pds2.isInterval()) {
                result += result * 37 + pds2.getStatisticalProcessType();
            }
            result += result * 37 + pds2.getParameterNumber();
            int ensDerivedType = -1;
            if (pds2.isEnsembleDerived()) {
                Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
                ensDerivedType = pdsDerived.getDerivedForecastType();
                result += result * 37 + ensDerivedType;
            } else if (pds2.isEnsemble()) {
                result += result * 37 + 1;
            }
            int probType = -1;
            if (pds2.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
                probType = pdsProb.getProbabilityType();
                result += result * 37 + pdsProb.getProbabilityHashcode();
            }
            if (pds2.getParameterCategory() > 191 || pds2.getParameterNumber() > 191 || pds2.getLevelType1() > 191 || pds2.isInterval() && pds2.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
                result += result * 37 + this.getId().getCenter_id();
                if (this.getId().getSubcenter_id() > 0) {
                    result += result * 37 + this.getId().getSubcenter_id();
                }
            }
            this.hashcode = result;
        }
        return this.hashcode;
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drs.getDataTemplate(), this.gdss.getNumberPoints(), this.drs.getDataPoints(), gds.scanMode, gds.nx, this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        byte[] bitmap = this.bms.getBitmap(raf);
        Grib2Drs gdrs = this.drs.getDrs(raf);
        return reader.getData(raf, bitmap, gdrs);
    }

    public Grib2Drs.Type40 readDataTest(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drs.getDataTemplate(), this.gdss.getNumberPoints(), this.drs.getDataPoints(), gds.scanMode, gds.nx, this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        byte[] bitmap = this.bms.getBitmap(raf);
        Grib2Drs gdrs = this.drs.getDrs(raf);
        if (gdrs instanceof Grib2Drs.Type40) {
            reader.getData(raf, bitmap, gdrs);
            return (Grib2Drs.Type40)gdrs;
        }
        return null;
    }

    public float[] readData(RandomAccessFile raf, long drsPos) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        Grib2Gds gds = this.gdss.getGDS();
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), this.gdss.getNumberPoints(), drs.getDataPoints(), gds.scanMode, gds.nx, dataSection.getStartingPosition(), dataSection.getMsgLength());
        byte[] bitmap = bms.getBitmap(raf);
        Grib2Drs gdrs = drs.getDrs(raf);
        return reader.getData(raf, bitmap, gdrs);
    }

    public static float[] readData(RandomAccessFile raf, long drsPos, int gdsNumberPoints, int scanMode, int nx) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), gdsNumberPoints, drs.getDataPoints(), scanMode, nx, dataSection.getStartingPosition(), dataSection.getMsgLength());
        byte[] bitmap = bms.getBitmap(raf);
        Grib2Drs gdrs = drs.getDrs(raf);
        return reader.getData(raf, bitmap, gdrs);
    }
}

