/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.CF;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.KmaLocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.grib.grib2.table.NdfdLocalTables;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class Grib2Tables
implements GribTables {
    private static final Logger log = LoggerFactory.getLogger(Grib2Pds.class);
    private static Grib2Tables wmoTables;
    private static Grib2Tables ncepTables;
    private static Grib2Tables ndfdTables;
    private static Grib2Tables kmaTables;
    private static Grib2Tables dssTables;
    protected final int center;
    protected final int subCenter;
    protected final int masterVersion;
    protected final int localVersion;

    public static Grib2Tables factory(int center, int subCenter, int masterVersion, int localVersion) {
        if (center == 7 || center == 9 || center == 54 || center == 59) {
            if (ncepTables == null) {
                ncepTables = new NcepLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return ncepTables;
        }
        if (center == 8 && (subCenter == 0 || subCenter == -9999)) {
            if (ndfdTables == null) {
                ndfdTables = new NdfdLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return ndfdTables;
        }
        if (center == 40) {
            if (kmaTables == null) {
                kmaTables = new KmaLocalTables(center, subCenter, masterVersion, localVersion);
            }
            return kmaTables;
        }
        if (wmoTables == null) {
            wmoTables = new Grib2Tables(center, subCenter, masterVersion, localVersion);
        }
        return wmoTables;
    }

    public static List<GribTableId> getLocalTableIds() {
        ArrayList<GribTableId> result = new ArrayList<GribTableId>();
        result.add(new GribTableId("NCEP", 7, -1, -1, -1));
        result.add(new GribTableId("NDFD", 8, 0, -1, -1));
        result.add(new GribTableId("KMA", 40, -1, -1, -1));
        result.add(new GribTableId("DSS", 7, -1, 2, 1));
        return result;
    }

    protected static int makeHash(int discipline, int category, int number) {
        return (discipline << 16) + (category << 8) + number;
    }

    public static boolean isLocal(GribTables.Parameter p) {
        return p.getCategory() > 191 || p.getNumber() > 191;
    }

    protected Grib2Tables(int center, int subCenter, int masterVersion, int localVersion) {
        this.center = center;
        this.subCenter = subCenter;
        this.masterVersion = masterVersion;
        this.localVersion = localVersion;
    }

    public String getVariableName(Grib2Record gr) {
        return this.getVariableName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
    }

    public String getVariableName(int discipline, int category, int parameter) {
        String s = WmoCodeTable.getParameterName(discipline, category, parameter);
        if (s == null) {
            s = "U" + discipline + "-" + category + "-" + parameter;
        }
        return s;
    }

    public String getTableValue(String tableName, int code) {
        return WmoCodeTable.getTableValue(tableName, code);
    }

    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        return WmoCodeTable.getParameterEntry(discipline, category, number);
    }

    public List getParameters() {
        try {
            WmoCodeTable.WmoTables wmo = WmoCodeTable.getWmoStandard();
            WmoCodeTable params = wmo.map.get("4.2");
            return params.entries;
        }
        catch (IOException e) {
            System.out.printf("Error reading wmo tables = %s%n", e.getMessage());
            return null;
        }
    }

    public CalendarDate getForecastDate(Grib2Record gr) {
        int val;
        Grib2Pds pds = gr.getPDS();
        if (pds.isInterval()) {
            int[] intv = this.getForecastTimeInterval(gr);
            val = intv[1];
        } else {
            val = pds.getForecastTime();
        }
        return gr.getReferenceDate().add(pds.getTimeDuration().multiply(val));
    }

    public int[] getForecastTimeInterval(Grib2Record gr) {
        if (!gr.getPDS().isInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnit = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit != timeUnit || ti.timeIncrementUnit != timeUnit && ti.timeIncrementUnit != 255) {
                log.warn("TimeInterval has different units timeUnit= " + timeUnit + " TimeInterval=" + ti);
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        int[] result = new int[2];
        CalendarDate EI = pdsIntv.getIntervalTimeEnd();
        if (EI == null) {
            result[1] = range;
            result[0] = 0;
        } else {
            int val;
            CalendarPeriod period = Grib2Utils.getCalendarPeriod(timeUnit);
            result[1] = val = period.subtract(gr.getReferenceDate(), EI);
            result[0] = result[1] - range;
        }
        return result;
    }

    public int[] getForecastTimeIntervalOld(Grib2Record gr) {
        if (!gr.getPDS().isInterval()) {
            return null;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)gr.getPDS());
        int timeUnit = gr.getPDS().getTimeUnit();
        int range = 0;
        for (Grib2Pds.TimeInterval ti : pdsIntv.getTimeIntervals()) {
            if (ti.timeRangeUnit != timeUnit || ti.timeIncrementUnit != timeUnit && ti.timeIncrementUnit != 255) {
                log.warn("TimeInterval has different units timeUnit= " + timeUnit + " TimeInterval=" + ti);
            }
            range += ti.timeRangeLength;
            if (ti.timeIncrementUnit == 255) continue;
            range += ti.timeIncrement;
        }
        int[] result = new int[2];
        CalendarDate EI = pdsIntv.getIntervalTimeEnd();
        if (EI == null) {
            result[1] = range;
            result[0] = 0;
        } else {
            int val;
            long msecs = EI.getDifferenceInMsecs(gr.getReferenceDate());
            CalendarPeriod duration = Grib2Utils.getCalendarPeriod(timeUnit);
            result[1] = val = (int)Math.round((double)msecs / duration.getValueInMillisecs());
            result[0] = result[1] - range;
        }
        return result;
    }

    @Override
    public String getLevelNameShort(int id) {
        switch (id) {
            case 1: {
                return "Surface";
            }
            case 2: {
                return "Cloud_base";
            }
            case 3: {
                return "Cloud_tops";
            }
            case 4: {
                return "ZeroDegC_isotherm";
            }
            case 5: {
                return "Adiabatic_condensation_lifted";
            }
            case 6: {
                return "Maximum_wind";
            }
            case 7: {
                return "Tropopause";
            }
            case 8: {
                return "Atmosphere_top";
            }
            case 9: {
                return "Sea_bottom";
            }
            case 10: {
                return "Entire_atmosphere";
            }
            case 11: {
                return "Cumulonimbus_base";
            }
            case 12: {
                return "Cumulonimbus_top";
            }
            case 20: {
                return "Isotherm";
            }
            case 100: {
                return "Pressure";
            }
            case 101: {
                return "Msl";
            }
            case 102: {
                return "Altitude_above_msl";
            }
            case 103: {
                return "Height_above_ground";
            }
            case 104: {
                return "Sigma";
            }
            case 105: {
                return "Hybrid";
            }
            case 106: {
                return "Depth_below_surface";
            }
            case 107: {
                return "Isentrope";
            }
            case 108: {
                return "Pressure_difference";
            }
            case 109: {
                return "Potential_vorticity_surface";
            }
            case 111: {
                return "Eta";
            }
            case 113: {
                return "Log_hybrid";
            }
            case 117: {
                return "Mixed_layer_depth";
            }
            case 118: {
                return "Hybrid_height";
            }
            case 119: {
                return "Hybrid_pressure";
            }
            case 120: {
                return "Pressure_thickness";
            }
            case 160: {
                return "Depth_below_sea";
            }
            case -9999: {
                return "none";
            }
        }
        return "UnknownLevelType-" + id;
    }

    public String getProbabilityNameShort(int id) {
        switch (id) {
            case 0: {
                return "Unweighted_mean";
            }
            case 1: {
                return "Weighted_mean";
            }
            case 2: {
                return "Standard_deviation";
            }
            case 3: {
                return "Standard_deviation_normalized";
            }
            case 4: {
                return "Spread";
            }
            case 5: {
                return "Large_anomaly_index";
            }
            case 6: {
                return "Unweighted_mean_cluster";
            }
            case 7: {
                return "Interquartile_range";
            }
            case 8: {
                return "Minimum_ensemble";
            }
            case 9: {
                return "Maximum_ensemble";
            }
        }
        return "UnknownProbType" + id;
    }

    public String getIntervalNameShort(int id) {
        switch (id) {
            case 0: {
                return "Average";
            }
            case 1: {
                return "Accumulation";
            }
            case 2: {
                return "Maximum";
            }
            case 3: {
                return "Minimum";
            }
            case 4: {
                return "Difference";
            }
            case 5: {
                return "RootMeanSquare";
            }
            case 6: {
                return "StandardDeviation";
            }
            case 7: {
                return "Covariance";
            }
            case 8: {
                return "Difference";
            }
            case 9: {
                return "Ratio";
            }
        }
        return "UnknownIntervalType-" + id;
    }

    public CF.CellMethods convertTable4_10(int code) {
        switch (code) {
            case 0: {
                return CF.CellMethods.mean;
            }
            case 1: {
                return CF.CellMethods.sum;
            }
            case 2: {
                return CF.CellMethods.maximum;
            }
            case 3: {
                return CF.CellMethods.minimum;
            }
            case 6: {
                return CF.CellMethods.standard_deviation;
            }
            case 7: {
                return CF.CellMethods.variance;
            }
        }
        return null;
    }

    public static class TableEntry
    implements GribTables.Parameter,
    Comparable<TableEntry> {
        public int discipline;
        public int category;
        public int number;
        public String name;
        public String unit;
        public String abbrev;

        public TableEntry(int discipline, int category, int number, String name, String unit, String abbrev) {
            this.discipline = discipline;
            this.category = category;
            this.number = number;
            this.name = name.trim();
            this.abbrev = abbrev;
            this.unit = GridParameter.cleanupUnits((String)unit);
        }

        @Override
        public String getId() {
            return this.discipline + "." + this.category + "." + this.number;
        }

        @Override
        public int compareTo(TableEntry o) {
            int c = this.discipline - o.discipline;
            if (c != 0) {
                return c;
            }
            c = this.category - o.category;
            if (c != 0) {
                return c;
            }
            return this.number - o.number;
        }

        @Override
        public int getDiscipline() {
            return this.discipline;
        }

        @Override
        public int getCategory() {
            return this.category;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUnit() {
            return this.unit;
        }

        @Override
        public String getAbbrev() {
            return this.abbrev;
        }

        public String toString() {
            return "TableEntry{discipline=" + this.discipline + ", category=" + this.category + ", number=" + this.number + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", abbrev='" + this.abbrev + '\'' + '}';
        }
    }

    public static class GribTableId {
        public final String name;
        public final int center;
        public final int subCenter;
        public final int masterVersion;
        public final int localVersion;

        GribTableId(String name, int center, int subCenter, int masterVersion, int localVersion) {
            this.name = name;
            this.center = center;
            this.subCenter = subCenter;
            this.masterVersion = masterVersion;
            this.localVersion = localVersion;
        }
    }
}

