/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import ucar.nc2.constants.CF;

public enum GribStatType {
    Average,
    Accumulation,
    Maximum,
    Minimum,
    DifferenceFromEnd,
    RootMeanSquare,
    StandardDeviation,
    Covariance,
    DifferenceFromStart,
    Ratio;


    public static GribStatType getStatTypeFromGrib2(int grib2StatCode) {
        switch (grib2StatCode) {
            case 0: {
                return Average;
            }
            case 1: {
                return Accumulation;
            }
            case 2: {
                return Maximum;
            }
            case 3: {
                return Minimum;
            }
            case 4: {
                return DifferenceFromEnd;
            }
            case 5: {
                return RootMeanSquare;
            }
            case 6: {
                return StandardDeviation;
            }
            case 7: {
                return Covariance;
            }
            case 8: {
                return DifferenceFromStart;
            }
            case 9: {
                return Ratio;
            }
        }
        return null;
    }

    public static String getStatTypeDescription(GribStatType statType) {
        switch (statType) {
            case Average: {
                return "Average";
            }
            case Accumulation: {
                return "Accumulation";
            }
            case Maximum: {
                return "Maximum";
            }
            case Minimum: {
                return "Minimum";
            }
            case DifferenceFromEnd: {
                return "Difference (Value at the end of time range minus value at the beginning)";
            }
            case RootMeanSquare: {
                return "RootMeanSquare";
            }
            case StandardDeviation: {
                return "StandardDeviation";
            }
            case Covariance: {
                return "Covariance (Temporal variance)";
            }
            case DifferenceFromStart: {
                return "Difference (Value at the start of time range minus value at the end)";
            }
            case Ratio: {
                return "Ratio";
            }
        }
        return "UnknownIntervalType-" + (Object)((Object)statType);
    }

    public static CF.CellMethods getCFCellMethod(GribStatType stat) {
        switch (stat) {
            case Average: {
                return CF.CellMethods.mean;
            }
            case Accumulation: {
                return CF.CellMethods.sum;
            }
            case Covariance: {
                return CF.CellMethods.variance;
            }
            case Minimum: {
                return CF.CellMethods.minimum;
            }
            case Maximum: {
                return CF.CellMethods.maximum;
            }
            case StandardDeviation: {
                return CF.CellMethods.standard_deviation;
            }
        }
        return null;
    }
}

