/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.iosp.grid.GridParameter;

@Immutable
public class Grib2Parameter
implements GribTables.Parameter,
Comparable<Grib2Parameter> {
    public int discipline;
    public int category;
    public int number;
    public String name;
    public String unit;
    public String abbrev;
    public String desc;

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = GridParameter.cleanupUnits((String)unit);
        this.desc = desc;
    }

    @Override
    public String getId() {
        return this.discipline + "." + this.category + "." + this.number;
    }

    @Override
    public int compareTo(Grib2Parameter o) {
        int c = this.discipline - o.discipline;
        if (c != 0) {
            return c;
        }
        c = this.category - o.category;
        if (c != 0) {
            return c;
        }
        return this.number - o.number;
    }

    @Override
    public int getDiscipline() {
        return this.discipline;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getAbbrev() {
        return this.abbrev;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "Grib2Parameter{discipline=" + this.discipline + ", category=" + this.category + ", number=" + this.number + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", abbrev='" + this.abbrev + '\'' + ", desc='" + this.desc + '\'' + '}';
    }
}

