/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.KmaLocalTables;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.unidata.util.StringUtil2;

public class DssLocalTables
extends LocalTables {
    private static final String tableName = "resources/grib2/local/cfsr.txt";
    private static boolean debug = false;

    DssLocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
    }

    @Override
    protected void initLocalTable() {
        ClassLoader cl = KmaLocalTables.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(tableName);
        if (is == null) {
            throw new IllegalStateException("Cant find resources/grib2/local/cfsr.txt");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = StringUtil2.splitString((String)line);
                int p1 = Integer.parseInt(flds[0].trim());
                int p2 = Integer.parseInt(flds[1].trim());
                int p3 = Integer.parseInt(flds[2].trim());
                StringBuilder b = new StringBuilder();
                int count = 3;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String abbrev = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String name = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String unit = b.toString().trim();
                Grib2Customizer.TableEntry s = new Grib2Customizer.TableEntry(p1, p2, p3, name, unit, abbrev);
                this.local.put(DssLocalTables.makeHash(p1, p2, p3), s);
                if (!debug) continue;
                System.out.printf(" %s%n", s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] arg) {
        DssLocalTables t = new DssLocalTables(7, 0, 0, 0);
        t.initLocalTable();
    }
}

