/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.util.TableParser;

public class KmaLocalTables
extends LocalTables {
    private static final String tableName = "resources/grib2/local/kma-ver5.txt";
    private static boolean debug = false;

    KmaLocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
    }

    @Override
    protected void initLocalTable() {
        ClassLoader cl = KmaLocalTables.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(tableName);
        if (is == null) {
            throw new IllegalStateException("Cant find resources/grib2/local/kma-ver5.txt");
        }
        try {
            List recs = TableParser.readTable((InputStream)is, (String)"41,112,124i,136i,148i,160", (int)1000);
            for (TableParser.Record record : recs) {
                String name = (String)record.get(0);
                int disc = (Integer)record.get(2);
                int cat = (Integer)record.get(3);
                int param = (Integer)record.get(4);
                String unit = (String)record.get(5);
                Grib2Customizer.TableEntry s = new Grib2Customizer.TableEntry(disc, cat, param, name, unit, null);
                this.local.put(KmaLocalTables.makeHash(disc, cat, param), s);
                if (!debug) continue;
                System.out.printf(" %s%n", s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] arg) {
        KmaLocalTables t = new KmaLocalTables(40, 0, 0, 0);
    }
}

