/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.icc.lut;

import ucar.jpeg.icc.lut.LookUpTable32;

public class LookUpTable32LinearSRGBtoSRGB
extends LookUpTable32 {
    public static LookUpTable32LinearSRGBtoSRGB createInstance(int inMax, int outMax, double shadowCutoff, double shadowSlope, double scaleAfterExp, double exponent, double reduceAfterExp) {
        return new LookUpTable32LinearSRGBtoSRGB(inMax, outMax, shadowCutoff, shadowSlope, scaleAfterExp, exponent, reduceAfterExp);
    }

    protected LookUpTable32LinearSRGBtoSRGB(int inMax, int outMax, double shadowCutoff, double shadowSlope, double scaleAfterExp, double exponent, double reduceAfterExp) {
        super(inMax + 1, outMax);
        int i = -1;
        double normalize = 1.0 / (double)inMax;
        int cutOff = (int)Math.floor(shadowCutoff * (double)inMax);
        shadowSlope *= (double)outMax;
        int shift = (outMax + 1) / 2;
        for (i = 0; i <= cutOff; ++i) {
            this.lut[i] = (int)(Math.floor(shadowSlope * ((double)i * normalize) + 0.5) - (double)shift);
        }
        scaleAfterExp *= (double)outMax;
        reduceAfterExp *= (double)outMax;
        while (i <= inMax) {
            this.lut[i] = (int)(Math.floor(scaleAfterExp * Math.pow((double)i * normalize, exponent) - reduceAfterExp + 0.5) - (double)shift);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable32LinearSRGBtoSRGB:");
        return rep.append("]").toString();
    }
}

