/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.grib1.tables.NcepTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.NcepLocalParams;
import ucar.nc2.grib.grib2.table.NcepLocalParamsOld;
import ucar.nc2.grib.grib2.table.NcepLocalParamsVeryOld;
import ucar.nc2.grib.grib2.table.WmoCodeTable;

public class NcepLocalTables
extends Grib2Customizer {
    private static Map<Integer, String> genProcessMap;
    private Map<String, String> codeMap = new HashMap<String, String>(400);

    NcepLocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
        this.initCodes();
    }

    public TimeCoord.TinvDate getForecastTimeIntervalCfsrMonthly(Grib2Record gr) {
        if (!gr.getPDS().isInterval()) {
            return null;
        }
        Grib2Pds pds = gr.getPDS();
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        int timeUnitOrg = pds.getTimeUnit();
        int statType = pds.getOctet(47);
        int statType2 = pds.getOctet(59);
        int ngrids = GribNumbers.int4(pds.getOctet(50), pds.getOctet(51), pds.getOctet(52), pds.getOctet(53));
        int p2 = GribNumbers.int4(pds.getOctet(55), pds.getOctet(56), pds.getOctet(57), pds.getOctet(58));
        int p2mp1 = GribNumbers.int4(pds.getOctet(62), pds.getOctet(63), pds.getOctet(64), pds.getOctet(65));
        return super.getForecastTimeInterval(gr);
    }

    @Override
    public String getVariableName(int discipline, int category, int parameter) {
        if (category <= 191 && parameter <= 191) {
            return super.getVariableName(discipline, category, parameter);
        }
        GribTables.Parameter te = this.getParameter(discipline, category, parameter);
        if (te == null) {
            return super.getVariableName(discipline, category, parameter);
        }
        return te.getName();
    }

    public GribTables.Parameter getParameterOld(int discipline, int category, int number) {
        WmoCodeTable.TableEntry p;
        if (category <= 191 && number <= 191 && (p = WmoCodeTable.getParameterEntry(discipline, category, number)) != null) {
            return p;
        }
        if (NcepLocalTables.makeHash(discipline, category, number) == NcepLocalTables.makeHash(2, 4, 3)) {
            return this.getParameter(2, 4, 2);
        }
        if (NcepLocalTables.makeHash(discipline, category, number) == NcepLocalTables.makeHash(0, 19, 242)) {
            return this.getParameter(0, 1, 242);
        }
        return NcepLocalParams.getParameter(discipline, category, number);
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        if (NcepLocalTables.makeHash(discipline, category, number) == NcepLocalTables.makeHash(2, 4, 3)) {
            return this.getParameter(2, 4, 2);
        }
        if (NcepLocalTables.makeHash(discipline, category, number) == NcepLocalTables.makeHash(0, 19, 242)) {
            return this.getParameter(0, 1, 242);
        }
        Grib2Parameter plocal = NcepLocalParams.getParameter(discipline, category, number);
        if (category <= 191 && number <= 191) {
            WmoCodeTable.TableEntry pwmo = WmoCodeTable.getParameterEntry(discipline, category, number);
            if (plocal == null) {
                return pwmo;
            }
            plocal.name = pwmo.getName();
            plocal.unit = pwmo.getUnit();
        }
        return plocal;
    }

    @Override
    public String getTableValue(String tableName, int code) {
        if (code < 192 || code > 254 || tableName.equals("4.0")) {
            return WmoCodeTable.getTableValue(tableName, code);
        }
        return this.codeMap.get(tableName + "." + code);
    }

    @Override
    public String getLevelNameShort(int id) {
        if (id < 192) {
            return super.getLevelNameShort(id);
        }
        switch (id) {
            case 200: {
                return "Entire_atmosphere";
            }
            case 201: {
                return "Entire_ocean";
            }
            case 204: {
                return "Highest_tropospheric_freezing";
            }
            case 206: {
                return "Grid_scale_cloud_bottom";
            }
            case 207: {
                return "Grid_scale_cloud_top";
            }
            case 209: {
                return "Boundary_layer_cloud_bottom";
            }
            case 210: {
                return "Boundary_layer_cloud_top";
            }
            case 211: {
                return "Boundary_layer_cloud";
            }
            case 212: {
                return "Low_cloud_bottom";
            }
            case 213: {
                return "Low_cloud_top";
            }
            case 214: {
                return "Low_cloud";
            }
            case 215: {
                return "Cloud_ceiling";
            }
            case 220: {
                return "Planetary_boundary";
            }
            case 221: {
                return "Between_two_hybrids";
            }
            case 222: {
                return "Middle_cloud_bottom";
            }
            case 223: {
                return "Middle_cloud_top";
            }
            case 224: {
                return "Middle_cloud";
            }
            case 232: {
                return "High_cloud_bottom";
            }
            case 233: {
                return "High_cloud_top";
            }
            case 234: {
                return "High_cloud";
            }
            case 235: {
                return "Ocean_isotherm";
            }
            case 236: {
                return "Layer_between_two_depths_below_ocean";
            }
            case 237: {
                return "Bottom_of_ocean_mixed";
            }
            case 238: {
                return "Bottom_of_ocean_isothermal";
            }
            case 239: {
                return "Ocean_surface_and_26C_isothermal";
            }
            case 240: {
                return "Ocean_mixed";
            }
            case 241: {
                return "Ordered_sequence_of_data";
            }
            case 242: {
                return "Convective_cloud_bottom";
            }
            case 243: {
                return "Convective_cloud_top";
            }
            case 244: {
                return "Convective_cloud";
            }
            case 245: {
                return "Lowest_level_of_the_wet_bulb_zero";
            }
            case 246: {
                return "Maximum_equivalent_potential_temperature";
            }
            case 247: {
                return "Equilibrium";
            }
            case 248: {
                return "Shallow_convective_cloud_bottom";
            }
            case 249: {
                return "Shallow_convective_cloud_top";
            }
            case 251: {
                return "Deep_convective_cloud_bottom";
            }
            case 252: {
                return "Deep_convective_cloud_top";
            }
            case 253: {
                return "Lowest_level_water_layer";
            }
            case 254: {
                return "Highest_level_water_layer";
            }
        }
        return super.getLevelNameShort(id);
    }

    @Override
    public String getIntervalNameShort(int id) {
        if (id < 192) {
            return super.getIntervalNameShort(id);
        }
        switch (id) {
            case 192: {
                return "ClimatologicalMeanValue";
            }
            case 193: {
                return "AverageNforecasts";
            }
            case 194: {
                return "AverageNanalysis";
            }
            case 195: {
                return "AverageAccum-24hourIntv";
            }
            case 196: {
                return "AverageForecastSuccessiveAccumulations";
            }
            case 197: {
                return "AverageAvg-24hourIntv";
            }
            case 198: {
                return "AverageForecastSuccessiveAverages";
            }
            case 199: {
                return "ClimatologicalAverageNanalysis";
            }
            case 200: {
                return "ClimatologicalAverageNforecasts";
            }
            case 201: {
                return "ClimatologicalRMSdiffNforecasts";
            }
            case 202: {
                return "ClimatologicalStandardDeviationNforecasts";
            }
            case 203: {
                return "ClimatologicalStandardDeviationNanalyses";
            }
            case 204: {
                return "AverageForecastAccumulations-204";
            }
            case 205: {
                return "AverageForecastAverages-205";
            }
            case 206: {
                return "AverageForecastAccumulations-206";
            }
            case 207: {
                return "AverageForecastAverages-207";
            }
            case 255: {
                return "Interval";
            }
        }
        return super.getIntervalNameShort(id);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        if (genProcessMap == null) {
            genProcessMap = NcepTables.getNcepGenProcess();
        }
        if (genProcessMap == null) {
            return null;
        }
        return genProcessMap.get(genProcess);
    }

    private Map<String, String> initCodes() {
        this.codeMap.put("3.1.204", "Curvilinear_Orthogonal");
        this.codeMap.put("4.3.192", "Forecast Confidence Indicator");
        this.codeMap.put("4.3.193", "Bias Corrected Ensemble Forecast");
        this.codeMap.put("4.5.200", "Entire atmosphere layer");
        this.codeMap.put("4.5.201", "Entire ocean layer");
        this.codeMap.put("4.5.204", "Highest tropospheric freezing level");
        this.codeMap.put("4.5.206", "Grid scale cloud bottom level");
        this.codeMap.put("4.5.207", "Grid scale cloud top level");
        this.codeMap.put("4.5.209", "Boundary layer cloud bottom level");
        this.codeMap.put("4.5.210", "Boundary layer cloud top level");
        this.codeMap.put("4.5.211", "Boundary layer cloud layer");
        this.codeMap.put("4.5.212", "Low cloud bottom level");
        this.codeMap.put("4.5.213", "Low cloud top level");
        this.codeMap.put("4.5.214", "Low cloud layer");
        this.codeMap.put("4.5.215", "Cloud ceiling");
        this.codeMap.put("4.5.220", "Planetary Boundary Layer");
        this.codeMap.put("4.5.221", "Layer Between Two Hybrid Levels");
        this.codeMap.put("4.5.222", "Middle cloud bottom level");
        this.codeMap.put("4.5.223", "Middle cloud top level");
        this.codeMap.put("4.5.224", "Middle cloud layer");
        this.codeMap.put("4.5.232", "High cloud bottom level");
        this.codeMap.put("4.5.233", "High cloud top level");
        this.codeMap.put("4.5.234", "High cloud layer");
        this.codeMap.put("4.5.235", "Ocean isotherm level");
        this.codeMap.put("4.5.236", "Layer between two depths below ocean surface");
        this.codeMap.put("4.5.237", "Bottom of ocean mixed layer");
        this.codeMap.put("4.5.238", "Bottom of ocean isothermal layer");
        this.codeMap.put("4.5.239", "Layer Ocean Surface and 26C Ocean Isothermal Level");
        this.codeMap.put("4.5.240", "Ocean Mixed Layer");
        this.codeMap.put("4.5.241", "Ordered Sequence of Data");
        this.codeMap.put("4.5.242", "Convective cloud bottom level");
        this.codeMap.put("4.5.243", "Convective cloud top level");
        this.codeMap.put("4.5.244", "Convective cloud layer");
        this.codeMap.put("4.5.245", "Lowest level of the wet bulb zero");
        this.codeMap.put("4.5.246", "Maximum equivalent potential temperature level");
        this.codeMap.put("4.5.247", "Equilibrium level");
        this.codeMap.put("4.5.248", "Shallow convective cloud bottom level");
        this.codeMap.put("4.5.249", "Shallow convective cloud top level");
        this.codeMap.put("4.5.251", "Deep convective cloud bottom level");
        this.codeMap.put("4.5.252", "Deep convective cloud top level");
        this.codeMap.put("4.5.253", "Lowest bottom level of supercooled liquid water layer");
        this.codeMap.put("4.5.254", "Highest top level of supercooled liquid water layer");
        this.codeMap.put("4.6.192", "Perturbed Ensemble Member");
        this.codeMap.put("4.7.192", "Unweighted Mode of All Members");
        this.codeMap.put("4.7.193", "Percentile value (10%) of All Members");
        this.codeMap.put("4.7.194", "Percentile value (50%) of All Members");
        this.codeMap.put("4.7.195", "Percentile value (90%) of All Members");
        this.codeMap.put("4.10.192", "Climatological Mean Value");
        this.codeMap.put("4.10.193", "Average of N forecasts");
        this.codeMap.put("4.10.194", "Average of N uninitialized analyses");
        this.codeMap.put("4.10.195", "Average of forecast accumulations");
        this.codeMap.put("4.10.196", "Average of successive forecast accumulations");
        this.codeMap.put("4.10.197", "Average of forecast averages");
        this.codeMap.put("4.10.198", "Average of successive forecast averages");
        this.codeMap.put("4.10.199", "Climatological Average of N analyses, each a year apart");
        this.codeMap.put("4.10.200", "Climatological Average of N forecasts, each a year apart");
        this.codeMap.put("4.10.201", "Climatological Root Mean Square difference between N forecasts and their verifying analyses, each a year apart");
        this.codeMap.put("4.10.202", "Climatological Standard Deviation of N forecasts from the mean of the same N forecasts, for forecasts one year apart");
        this.codeMap.put("4.10.203", "Climatological Standard Deviation of N analyses from the mean of the same N analyses, for analyses one year apart");
        this.codeMap.put("4.10.204", "Average of forecast accumulations");
        this.codeMap.put("4.10.205", "Average of forecast averages");
        this.codeMap.put("4.10.206", "Average of forecast accumulations");
        this.codeMap.put("4.10.207", "Average of forecast averages");
        return this.codeMap;
    }

    public static void main(String[] arg) {
        HashMap<Integer, CompTable> map = new HashMap<Integer, CompTable>(500);
        NcepLocalTables tables = new NcepLocalTables(0, 0, 0, 0);
        NcepLocalParamsOld ncepOld = new NcepLocalParamsOld();
        for (int key : ncepOld.local.keySet()) {
            GribTables.Parameter p = ncepOld.local.get(key);
            map.put(key, new CompTable(key, p, null));
        }
        NcepLocalParamsVeryOld.init();
        Map<String, Grib2Parameter> org = NcepLocalParamsVeryOld.getParamMap();
        for (String skey : org.keySet()) {
            Grib2Parameter p = org.get(skey);
            int key = NcepLocalTables.makeHash(p.discipline, p.category, p.number);
            CompTable ct = (CompTable)map.get(key);
            if (ct == null) {
                map.put(key, new CompTable(key, null, p));
                continue;
            }
            ct.org = p;
        }
        System.out.printf("NcepLocalTables%nNcepLocalParamsOld%n%n", new Object[0]);
        ArrayList<Integer> keys = new ArrayList<Integer>();
        Iterator<Object> i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            keys.add(key);
        }
        Collections.sort(keys);
        i$ = keys.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            CompTable ct = (CompTable)map.get(key);
            System.out.printf("%s%n", ct.local);
            System.out.printf("%s%n%n", ct.org);
        }
    }

    private static class CompTable {
        int key;
        GribTables.Parameter local;
        GribTables.Parameter org;

        private CompTable(int key, GribTables.Parameter local, GribTables.Parameter org) {
            this.key = key;
            this.local = local;
            this.org = org;
        }
    }
}

