/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.WmoCodeTable;

public class NdfdLocalTables
extends Grib2Customizer {
    private final Map<Integer, Grib2Parameter> local = new HashMap<Integer, Grib2Parameter>(100);

    NdfdLocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
        this.init();
    }

    @Override
    public List getParameters() {
        ArrayList<Grib2Parameter> result = new ArrayList<Grib2Parameter>();
        for (Grib2Parameter p : this.local.values()) {
            result.add(p);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getVariableName(int discipline, int category, int parameter) {
        if (category <= 191 && parameter <= 191) {
            return super.getVariableName(discipline, category, parameter);
        }
        GribTables.Parameter p = this.getParameter(discipline, category, parameter);
        return p == null ? null : p.getName();
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return WmoCodeTable.getParameterEntry(discipline, category, number);
        }
        return this.local.get(NdfdLocalTables.makeHash(discipline, category, number));
    }

    private void init() {
        this.add(0, 0, 193, "ApparentT", "Apparent Temperature", "K");
        this.add(0, 1, 192, "Wx", "Weather string", "");
        this.add(0, 10, 8, "PoP12", "Prob of 0.01 In. of Precip", "%");
        this.add(0, 13, 194, "smokes", "Surface level smoke from fires", "log10(g/m^3)");
        this.add(0, 13, 195, "smokec", "Average vertical column smoke from fires", "log10(g/m^3)");
        this.add(0, 14, 192, "O3MR", "Ozone Mixing Ratio", "kg/kg");
        this.add(0, 14, 193, "OZCON", "Ozone Concentration", "PPB");
        this.add(0, 14, 200, "OZMAX1", "Ozone Daily Max from 1-hour Average", "ppbV");
        this.add(0, 14, 201, "OZMAX8", "Ozone Daily Max from 8-hour Average", "ppbV");
        this.add(0, 19, 194, "ConvOutlook", "Convective Hazard Outlook", "0=none; 2=tstm; 4=slight; 6=moderate; 8=high");
        this.add(0, 19, 197, "TornadoProb", "Tornado Probability", "%");
        this.add(0, 19, 198, "HailProb", "Hail Probability", "%");
        this.add(0, 19, 199, "WindProb", "Damaging Thunderstorm Wind Probability", "%");
        this.add(0, 19, 200, "XtrmTornProb", "Extreme Tornado Probability", "%");
        this.add(0, 19, 201, "XtrmHailProb", "Extreme Hail Probability", "%");
        this.add(0, 19, 202, "XtrmWindProb", "Extreme Thunderstorm Wind Probability", "%");
        this.add(0, 19, 215, "TotalSvrProb", "Total Probability of Severe Thunderstorms", "%");
        this.add(0, 19, 216, "TotalXtrmProb", "Total Probability of Extreme Severe Thunderstorms", "%");
        this.add(0, 19, 217, "WWA", "Watch Warning Advisory", "");
        this.add(0, 19, 203, "TotalSvrProb", "Total Probability of Severe Thunderstorms", "%");
        this.add(0, 19, 204, "TotalXtrmProb", "Total Probability of Extreme Severe Thunderstorms", "%");
        this.add(0, 192, 192, "FireWx", "Critical Fire Weather", "%");
        this.add(0, 192, 194, "DryLightning", "Dry Lightning", "%");
        this.add(10, 3, 192, "Surge", "Hurricane Storm Surge", "m");
        this.add(10, 3, 193, "ETSurge", "Extra Tropical Storm Surge", "m");
    }

    private void add(int discipline, int category, int number, String abbrev, String name, String unit) {
        this.local.put(NdfdLocalTables.makeHash(discipline, category, number), new Grib2Parameter(discipline, category, number, name, unit, abbrev, null));
    }
}

