/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribTables;
import ucar.unidata.util.StringUtil2;

public class WmoCodeTable
implements Comparable<WmoCodeTable> {
    private static final Logger logger = LoggerFactory.getLogger(WmoCodeTable.class);
    public static final Version standard = Version.GRIB2_8_0_0;
    private static WmoTables wmoTables = null;
    public String tableName;
    public int m1;
    public int m2;
    public boolean isParameter;
    public int discipline = -1;
    public int category = -1;
    String id;
    public List<TableEntry> entries = new ArrayList<TableEntry>();
    public Map<Integer, TableEntry> entryMap;
    private static int[] badones = new int[]{0, 1, 51, 0, 6, 25, 0, 19, 22, 0, 19, 25, 0, 191, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 2, 2, 0, 0, 2, 0, 31, 10, 191, 0};
    private static int[] truncOnes = new int[]{10, 0, 46, 69, 10, 0, 47, 69, 10, 0, 48, 69};

    public static TableEntry getParameterEntry(int discipline, int category, int value) {
        return WmoCodeTable.getTableEntry(WmoCodeTable.getId(discipline, category), value);
    }

    public static String getParameterName(int discipline, int category, int value) {
        TableEntry te = WmoCodeTable.getTableEntry(WmoCodeTable.getId(discipline, category), value);
        return te == null ? null : te.name;
    }

    private static String getId(int discipline, int category) {
        return "4.2." + discipline + "." + category;
    }

    public static String getTableValue(String tableId, int value) {
        WmoCodeTable table;
        if (wmoTables == null) {
            try {
                WmoCodeTable.getWmoStandard();
            }
            catch (IOException e) {
                throw new IllegalStateException("cant open wmo tables");
            }
        }
        if ((table = WmoCodeTable.wmoTables.map.get(tableId)) == null) {
            return null;
        }
        TableEntry entry = table.get(value);
        if (entry == null) {
            return null;
        }
        return entry.meaning;
    }

    public static TableEntry getTableEntry(String tableId, int value) {
        WmoCodeTable table;
        if (wmoTables == null) {
            try {
                WmoCodeTable.getWmoStandard();
            }
            catch (IOException e) {
                throw new IllegalStateException("cant open wmo tables");
            }
        }
        if ((table = WmoCodeTable.wmoTables.map.get(tableId)) == null) {
            return null;
        }
        return table.get(value);
    }

    public static WmoTables getWmoStandard() throws IOException {
        if (wmoTables == null) {
            wmoTables = WmoCodeTable.readGribCodes(standard);
        }
        return wmoTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WmoTables readGribCodes(Version version) throws IOException {
        InputStream ios = null;
        try {
            Document doc;
            Class<WmoCodeTable> c = WmoCodeTable.class;
            String name = version.getResourceName();
            ios = c.getResourceAsStream(name);
            if (ios == null) {
                logger.error("cant open WmoCodeTable=" + version.getResourceName());
                throw new IOException("cant open WmoCodeTable=" + version.getResourceName());
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(ios);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            Element root = doc.getRootElement();
            HashMap<String, WmoCodeTable> map = new HashMap<String, WmoCodeTable>();
            String[] elems = version.getElemNames();
            List featList = root.getChildren(elems[0]);
            for (Element elem : featList) {
                Element unitElem;
                String line = elem.getChildTextNormalize("No");
                String tableName = elem.getChildTextNormalize(elems[1]);
                String code = elem.getChildTextNormalize("CodeFlag");
                String meaning = elem.getChildTextNormalize(elems[3]);
                WmoCodeTable ct = (WmoCodeTable)map.get(tableName);
                if (ct == null) {
                    ct = new WmoCodeTable(tableName);
                    map.put(tableName, ct);
                }
                String unit = (unitElem = elem.getChild(elems[4])) == null ? null : unitElem.getTextNormalize();
                Element statusElem = elem.getChild("Status");
                String status = statusElem == null ? null : statusElem.getTextNormalize();
                Element subtableElem = elem.getChild(elems[2]);
                if (subtableElem != null) {
                    String subTableName = subtableElem.getTextNormalize();
                    WmoCodeTable cst = (WmoCodeTable)map.get(subTableName);
                    if (cst == null) {
                        cst = new WmoCodeTable(tableName, subTableName);
                        map.put(subTableName, cst);
                    }
                    cst.add(line, code, meaning, unit, status);
                    continue;
                }
                ct.add(line, code, meaning, unit, status);
            }
            ios.close();
            ArrayList tlist = new ArrayList(map.values());
            Collections.sort(tlist);
            for (WmoCodeTable gt : tlist) {
                Collections.sort(gt.entries);
            }
            HashMap<String, WmoCodeTable> map2 = new HashMap<String, WmoCodeTable>(2 * tlist.size());
            for (WmoCodeTable ct : tlist) {
                map2.put(ct.getTableId(), ct);
            }
            WmoTables wmoTables = new WmoTables(version.getResourceName(), tlist, map2);
            return wmoTables;
        }
        finally {
            if (ios != null) {
                ios.close();
            }
        }
    }

    WmoCodeTable() {
    }

    WmoCodeTable(String name) {
        this.tableName = name;
        String[] s = name.split(" ");
        String id = s[2];
        String[] slist2 = id.split("\\.");
        if (slist2.length == 2) {
            this.m1 = Integer.parseInt(slist2[0]);
            this.m2 = Integer.parseInt(slist2[1]);
        } else {
            System.out.println("HEY bad= %s%n" + name);
        }
    }

    WmoCodeTable(String tableName, String subtableName) {
        String[] s = tableName.split(" ");
        String id = s[2];
        String[] slist2 = id.split("\\.");
        if (slist2.length == 2) {
            this.m1 = Integer.parseInt(slist2[0]);
            this.m2 = Integer.parseInt(slist2[1]);
        } else {
            System.out.println("HEY bad= %s%n" + tableName);
        }
        this.tableName = subtableName;
        String[] slist = subtableName.split("[ :]+");
        try {
            for (int i = 0; i < slist.length; ++i) {
                if (slist[i].equalsIgnoreCase("discipline")) {
                    this.discipline = Integer.parseInt(slist[i + 1]);
                }
                if (!slist[i].equalsIgnoreCase("category")) continue;
                this.category = Integer.parseInt(slist[i + 1]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.isParameter = this.discipline >= 0 && this.category >= 0;
    }

    private TableEntry add(String line, String code, String meaning, String unit, String status) {
        TableEntry te = new TableEntry(line, code, meaning, unit, status);
        this.entries.add(te);
        return te;
    }

    TableEntry get(int value) {
        if (this.entryMap == null) {
            this.entryMap = new HashMap<Integer, TableEntry>(2 * this.entries.size());
            for (TableEntry p : this.entries) {
                if (p.start != p.stop) continue;
                this.entryMap.put(p.start, p);
            }
        }
        return this.entryMap.get(value);
    }

    @Override
    public int compareTo(WmoCodeTable o) {
        if (this.m1 != o.m1) {
            return this.m1 - o.m1;
        }
        if (this.m2 != o.m2) {
            return this.m2 - o.m2;
        }
        if (this.discipline != o.discipline) {
            return this.discipline - o.discipline;
        }
        return this.category - o.category;
    }

    public String getTableId() {
        if (this.id == null) {
            this.id = this.makeTableNo();
        }
        return this.id;
    }

    private String makeTableNo() {
        Formatter f = new Formatter();
        f.format("%d.%d", this.m1, this.m2);
        if (this.discipline >= 0) {
            f.format(".%d", this.discipline);
        }
        if (this.category >= 0) {
            f.format(".%d", this.category);
        }
        return f.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return "GribCodeTable{name='" + this.tableName + '\'' + ", m1=" + this.m1 + ", m2=" + this.m2 + ", isParameter=" + this.isParameter + ", discipline=" + this.discipline + ", category=" + this.category + '}';
    }

    private boolean remove(TableEntry entry) {
        for (int i = 0; i < badones.length; i += 3) {
            if (this.discipline != badones[i] || this.category != badones[i + 1] || entry.number != badones[i + 2]) continue;
            return true;
        }
        return false;
    }

    private int truncateAtChar(TableEntry entry) {
        for (int i = 0; i < truncOnes.length; i += 4) {
            if (this.discipline != truncOnes[i] || this.category != truncOnes[i + 1] || entry.number != truncOnes[i + 2]) continue;
            return truncOnes[i + 3];
        }
        return -1;
    }

    public static void showDiff(WmoTables gt1, WmoTables gt2, boolean showDiff) throws IOException {
        int total = 0;
        int nsame = 0;
        int nsameIgn = 0;
        int ndiff = 0;
        int unknown = 0;
        System.out.printf("DIFFERENCES between %s and %s%n", gt1.name, gt2.name);
        for (WmoCodeTable gc1 : gt1.list) {
            WmoCodeTable gc2 = gt2.map.get(gc1.tableName);
            if (gc2 == null) {
                System.out.printf("1 table %s not found in %s%n", gc1.getTableId(), gt2.name);
                continue;
            }
            for (TableEntry p1 : gc1.entries) {
                TableEntry p2 = gc2.get(p1.start);
                if (p2 == null) {
                    System.out.printf("2 code %s not found in %s%n", p1.getId(), gt2.name);
                    continue;
                }
                if (!showDiff || p1.equals(p2)) continue;
                System.out.printf("3 %s not equal%n  %s%n%n", p1, p2);
            }
        }
        System.out.printf("Total=%d same=%d sameIgn=%d dif=%d unknown=%d%n", total, nsame, nsameIgn, ndiff, unknown);
    }

    static String munge(String org) {
        String result = StringUtil2.remove((String)org, (String)"_");
        result = StringUtil2.remove((String)result, (String)"-");
        return result;
    }

    public static void showTable(List<WmoCodeTable> tlist) throws IOException {
        for (WmoCodeTable gt : tlist) {
            System.out.printf("%d.%d (%d,%d) %s %n", gt.m1, gt.m2, gt.discipline, gt.category, gt.tableName);
            for (TableEntry p : gt.entries) {
                System.out.printf("  %s (%d-%d) = %s %n", p.code, p.start, p.stop, p.meaning);
            }
        }
    }

    public static void main(String[] arg) throws IOException {
        WmoCodeTable table = new WmoCodeTable();
        table.isParameter = true;
        String name = "Probability of 0.01 inch of precipitation (POP)";
        TableEntry te = table.add("1", "1-1-1", name, "", "");
        System.out.printf("%s%n", te);
    }

    public class TableEntry
    implements GribTables.Parameter,
    Comparable<TableEntry> {
        public int start;
        public int stop;
        public int line;
        public int number = -1;
        public String code;
        public String meaning;
        public String name;
        public String unit;
        public String status;

        TableEntry(String line, String code, String meaning, String unit, String status) {
            this.line = Integer.parseInt(line);
            this.code = code;
            this.meaning = meaning;
            this.status = status;
            this.unit = unit;
            try {
                int pos = code.indexOf(45);
                if (pos > 0) {
                    this.start = Integer.parseInt(code.substring(0, pos));
                    String stops = code.substring(pos + 1);
                    this.stop = Integer.parseInt(stops);
                } else {
                    this.stop = this.start = Integer.parseInt(code);
                    this.number = this.start;
                }
            }
            catch (Exception e) {
                this.start = -1;
                this.stop = 0;
            }
            if (WmoCodeTable.this.isParameter) {
                this.name = meaning;
                if (unit != null) {
                    if (unit.equalsIgnoreCase("Proportion") || unit.equalsIgnoreCase("Numeric")) {
                        unit = "";
                    } else if (unit.equalsIgnoreCase("-")) {
                        unit = "";
                    } else {
                        if (unit.startsWith("/")) {
                            unit = "1" + unit;
                        }
                        unit = unit.trim();
                        unit = StringUtil2.replace((String)unit, (char)' ', (String)".");
                    }
                }
                this.unit = unit;
            }
        }

        @Override
        public int compareTo(TableEntry o) {
            return this.start - o.start;
        }

        public String toString() {
            return "TableEntry{" + WmoCodeTable.this.getTableId() + ", code='" + this.code + '\'' + ", start=" + this.start + ", stop=" + this.stop + ", number=" + this.number + ", meaning='" + this.meaning + '\'' + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", status='" + this.status + '\'' + '}';
        }

        @Override
        public String getId() {
            return WmoCodeTable.this.getTableId() + "." + this.code;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableEntry that = (TableEntry)o;
            if (this.number != that.number) {
                return false;
            }
            if (this.start != that.start) {
                return false;
            }
            if (this.stop != that.stop) {
                return false;
            }
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
                return false;
            }
            if (this.meaning != null ? !this.meaning.equals(that.meaning) : that.meaning != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.unit != null ? !this.unit.equals(that.unit) : that.unit != null);
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.stop;
            result = 31 * result + this.line;
            result = 31 * result + this.number;
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.meaning != null ? this.meaning.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }

        @Override
        public int getDiscipline() {
            return WmoCodeTable.this.m1;
        }

        @Override
        public int getCategory() {
            return WmoCodeTable.this.m2;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.meaning;
        }

        @Override
        public String getUnit() {
            return this.unit;
        }

        @Override
        public String getAbbrev() {
            return null;
        }
    }

    public static class WmoTables {
        public String name;
        public List<WmoCodeTable> list;
        public Map<String, WmoCodeTable> map;

        private WmoTables(String name, List<WmoCodeTable> list, Map<String, WmoCodeTable> map) {
            this.name = name;
            this.list = list;
            this.map = map;
        }
    }

    public static enum Version {
        GRIB2_5_2_0,
        GRIB2_6_0_1,
        GRIB2_7_0_0,
        GRIB2_8_0_0;


        String getResourceName() {
            if (this == GRIB2_8_0_0) {
                return "/resources/grib2/wmo/" + this.name() + "_CodeFlag_en.xml";
            }
            return "/resources/grib2/wmo/" + this.name() + "_CodeFlag_E.xml";
        }

        String[] getElemNames() {
            if (this == GRIB2_5_2_0) {
                return new String[]{"ForExport_CodeFlag_E", "TableTitle_E", "TableSubTitle_E", "Meaning_E", "AsciiUnit_x002F_Description_E"};
            }
            if (this == GRIB2_6_0_1) {
                return new String[]{"Exp_codeflag_E", "Title_E", "SubTitle_E", "MeaningParameterDescription_E", "AsciiUnitComments_E"};
            }
            if (this == GRIB2_7_0_0) {
                return new String[]{"Exp_CodeFlag_E", "Title_E", "SubTitle_E", "MeaningParameterDescription_E", "UnitComments_E"};
            }
            if (this == GRIB2_8_0_0) {
                return new String[]{"GRIB2_8_0_0_CodeFlag_en", "Title_en", "SubTitle_en", "MeaningParameterDescription_en", "UnitComments_en"};
            }
            return null;
        }
    }
}

