/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.util.StringUtil2;

public class NcepLocalParams {
    private static final Logger log = LoggerFactory.getLogger(NcepLocalParams.class);
    private static boolean debug = false;
    private static Map<Integer, NcepLocalParams> tableMap = new HashMap<Integer, NcepLocalParams>(30);
    private String title;
    private String source;
    private String tableName;
    private int discipline;
    private int category;
    private Map<Integer, Grib2Parameter> paramMap;
    private static final String match = "Table4.2.";

    public static Grib2Parameter getParameter(int discipline, int category, int number) {
        int key = (discipline << 8) + category;
        NcepLocalParams params = tableMap.get(key);
        if (params == null) {
            params = NcepLocalParams.factory(discipline, category);
            if (params == null) {
                return null;
            }
            tableMap.put(key, params);
        }
        return params.getParameter(number);
    }

    static NcepLocalParams factory(String path) {
        NcepLocalParams params = new NcepLocalParams();
        if (!params.readParameterTableXml(path)) {
            return null;
        }
        return params;
    }

    private static NcepLocalParams factory(int discipline, int category) {
        NcepLocalParams params = new NcepLocalParams();
        if (!params.readParameterTableFromResource(NcepLocalParams.getTablePath(discipline, category))) {
            return null;
        }
        return params;
    }

    public static String getTablePath(int discipline, int category) {
        return "/resources/grib2/ncep/Table4.2." + discipline + "." + category + ".xml";
    }

    public List<Grib2Parameter> getParameters() {
        ArrayList<Grib2Parameter> result = new ArrayList<Grib2Parameter>(this.paramMap.values());
        Collections.sort(result);
        return result;
    }

    public Grib2Parameter getParameter(int code) {
        if (this.paramMap == null) {
            return null;
        }
        return this.paramMap.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableXml(String path) {
        boolean bl;
        if (debug) {
            System.out.printf("reading table %s%n", path);
        }
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(path);
            if (is == null) {
                log.warn("Cant read file " + path);
                boolean bl2 = false;
                return bl2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            this.paramMap = this.parseXml(root);
            bl = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableFromResource(String resource) {
        boolean bl;
        if (debug) {
            System.out.printf("reading table from resource %s%n", resource);
        }
        InputStream is = null;
        try {
            Class<WmoCodeTable> c = WmoCodeTable.class;
            is = c.getResourceAsStream(resource);
            if (is == null) {
                log.warn("Cant read resource " + resource);
                boolean bl2 = false;
                return bl2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            this.paramMap = this.parseXml(root);
            bl = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    public HashMap<Integer, Grib2Parameter> parseXml(Element root) {
        this.tableName = root.getChildText("table");
        this.title = root.getChildText("title");
        this.source = root.getChildText("source");
        int pos = this.tableName.indexOf(match);
        String dc = this.tableName.substring(pos + match.length());
        String[] dcs = dc.split("\\.");
        this.discipline = Integer.parseInt(dcs[0]);
        this.category = Integer.parseInt(dcs[1]);
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>();
        List params = root.getChildren("parameter");
        for (Element elem : params) {
            String name;
            int code = Integer.parseInt(elem.getAttributeValue("code"));
            String abbrev = elem.getChildText("shortName");
            String desc = elem.getChildText("description");
            String units = elem.getChildText("units");
            if (units == null) {
                units = "";
            }
            if (desc.length() > 80 && abbrev != null && !abbrev.equalsIgnoreCase("Validation")) {
                name = abbrev;
            } else {
                name = desc;
                desc = null;
            }
            Grib2Parameter parameter = new Grib2Parameter(this.discipline, this.category, code, name, units, abbrev, desc);
            result.put(parameter.getNumber(), parameter);
            if (!debug) continue;
            System.out.printf(" %s%n", parameter);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NcepTable");
        sb.append("{title='").append(this.title).append('\'');
        sb.append(", source='").append(this.source).append('\'');
        sb.append(", tableName='").append(this.tableName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static void compareTables(NcepLocalParams test, Grib2Customizer current) {
        Formatter f = new Formatter();
        int extra = 0;
        int udunits = 0;
        int conflict = 0;
        for (Grib2Parameter p1 : test.getParameters()) {
            boolean isUnitless2;
            String p2n;
            GribTables.Parameter p2 = current.getParameter(p1.getDiscipline(), p1.getCategory(), p1.getNumber());
            if (p2 == null) {
                ++extra;
                if (p1.getNumber() >= 192) continue;
                f.format("  WMO missing %s%n", p1);
                continue;
            }
            String p1n = StringUtil2.substitute((String)GridParameter.cleanupDescription((String)p1.getName()), (String)"-", (String)" ");
            if (!p1n.equalsIgnoreCase(p2n = StringUtil2.substitute((String)GridParameter.cleanupDescription((String)p2.getName()), (String)"-", (String)" ")) || p1.getNumber() >= 192 && !p1.getAbbrev().equals(p2.getAbbrev())) {
                f.format("  p1=%10s %40s %15s  %15s%n", p1.getId(), p1.getName(), p1.getUnit(), p1.getAbbrev());
                f.format("  p2=%10s %40s %15s  %15s%n%n", p2.getId(), p2.getName(), p2.getUnit(), p2.getAbbrev());
                ++conflict;
            }
            if (p1.getUnit().equalsIgnoreCase(p2.getUnit())) continue;
            String cu1 = GridParameter.cleanupUnits((String)p1.getUnit());
            String cu2 = GridParameter.cleanupUnits((String)p2.getUnit());
            boolean isUnitless1 = NcepLocalParams.isUnitless(cu1);
            if (isUnitless1 != (isUnitless2 = NcepLocalParams.isUnitless(cu2))) {
                f.format("  ud=%10s %s != %s for %s (%s)%n%n", p1.getId(), cu1, cu2, p1.getId(), p1.getName());
                ++udunits;
                continue;
            }
            if (isUnitless1) continue;
            try {
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu1);
                if (su1.isCompatible(cu2)) continue;
                f.format("  ud=%10s %s (%s) != %s for %s (%s)%n%n", p1.getId(), cu1, su1, cu2, p1.getId(), p1.getName());
                ++udunits;
            }
            catch (Exception e) {
                f.format("  udunits cant parse=%10s %15s %15s%n", p1.getId(), cu1, cu2);
            }
        }
        f.format("Conflicts=%d extra=%d udunits=%d%n%n", conflict, extra, udunits);
        System.out.printf("%s%n", f);
    }

    static boolean isUnitless(String unit) {
        if (unit == null) {
            return true;
        }
        String munge = unit.toLowerCase().trim();
        return (munge = StringUtil2.remove((String)munge, (int)40)).length() == 0 || munge.startsWith("numeric") || munge.startsWith("non-dim") || munge.startsWith("see") || munge.startsWith("proportion") || munge.startsWith("code") || munge.startsWith("0=") || munge.equals("1");
    }

    public static void main2(String[] args) {
        Grib2Customizer wmo = Grib2Customizer.factory(0, 0, 0, 0);
        File dir = new File("C:\\dev\\github\\thredds\\grib\\src\\main\\resources\\resources\\grib2\\ncep");
        for (File f : dir.listFiles()) {
            if (!f.getName().startsWith(match)) continue;
            NcepLocalParams nt = NcepLocalParams.factory(f.getPath());
            System.out.printf("%s%n", nt);
            NcepLocalParams.compareTables(nt, wmo);
        }
    }

    public static void main3(String[] args) {
        Grib2Parameter p = NcepLocalParams.getParameter(0, 16, 195);
        System.out.printf("%s%n", p);
        Grib2Customizer tables = Grib2Customizer.factory(7, 0, 0, 0);
        GribTables.Parameter p2 = tables.getParameter(0, 16, 195);
        System.out.printf("%s%n", p2);
    }

    public static void main(String[] args) {
        HashMap<String, Grib2Parameter> abbrevSet = new HashMap<String, Grib2Parameter>(5000);
        File dir = new File("C:\\dev\\github\\thredds\\grib\\src\\main\\resources\\resources\\grib2\\ncep");
        for (File f : dir.listFiles()) {
            if (!f.getName().startsWith(match)) continue;
            NcepLocalParams nt = NcepLocalParams.factory(f.getPath());
            System.out.printf("%s%n", nt);
            for (Grib2Parameter p : nt.getParameters()) {
                if (p.getCategory() < 192 && p.getNumber() < 192) continue;
                if (p.getAbbrev() != null && !p.getAbbrev().equals("Validation")) {
                    Grib2Parameter dup = (Grib2Parameter)abbrevSet.get(p.getAbbrev());
                    if (dup != null) {
                        System.out.printf("DUPLICATE %s and %s%n", dup.getId(), p.getId());
                    }
                    abbrevSet.put(p.getAbbrev(), p);
                }
                if (p.getDescription().length() > 60) {
                    System.out.printf("  %d %s = '%s' %s%n", p.getDescription().length(), p.getId(), p.getDescription(), p.getAbbrev());
                    continue;
                }
                if (p.getDescription().length() > 50) {
                    System.out.printf("  50 %s = '%s' %s%n", p.getId(), p.getDescription(), p.getAbbrev());
                    continue;
                }
                if (p.getDescription().length() > 40) {
                    System.out.printf("  40 %s = '%s' %s%n", p.getId(), p.getDescription(), p.getAbbrev());
                    continue;
                }
                if (p.getDescription().length() <= 30) continue;
                System.out.printf("  30 %s = '%s' %s%n", p.getId(), p.getDescription(), p.getAbbrev());
            }
        }
    }
}

