/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerSingleFile;
import thredds.inventory.MFile;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribCollectionBuilder;
import ucar.nc2.grib.GribCollectionProto;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2Collection;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Index;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Rectilyser;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public class Grib2CollectionBuilder
extends GribCollectionBuilder {
    public static final String MAGIC_START = "Grib2CollectionIndex";
    protected static final int minVersionSingle = 11;
    protected static final int version = 12;
    private static final boolean showFiles = false;
    protected GribCollection gc;
    protected Grib2Customizer tables;

    public static boolean update(CollectionManager dcm, Logger logger) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm, logger);
        if (!builder.needsUpdate()) {
            return false;
        }
        builder.readOrCreateIndex(CollectionManager.Force.always);
        builder.gc.close();
        return true;
    }

    public static GribCollection readOrCreateIndexFromSingleFile(MFile file, CollectionManager.Force force, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(file, config, logger);
        builder.readOrCreateIndex(force);
        return builder.gc;
    }

    public static GribCollection factory(CollectionManager dcm, CollectionManager.Force force, Logger logger) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm, logger);
        builder.readOrCreateIndex(force);
        return builder.gc;
    }

    public static GribCollection createFromIndex(String name, File directory, RandomAccessFile raf, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(name, directory, config, logger);
        if (builder.readIndex(raf)) {
            return builder.gc;
        }
        throw new IOException("Reading index failed");
    }

    public static boolean writeIndexFile(File indexFile, CollectionManager dcm, Logger logger) throws IOException {
        Grib2CollectionBuilder builder = new Grib2CollectionBuilder(dcm, logger);
        return builder.createIndex(indexFile);
    }

    private Grib2CollectionBuilder(MFile file, FeatureCollectionConfig.GribConfig config, Logger logger) throws IOException {
        super((CollectionManager)new CollectionManagerSingleFile(file, logger), true, logger);
        try {
            if (config != null) {
                this.dcm.putAuxInfo("gribConfig", (Object)config);
            }
            this.gc = new Grib2Collection(file.getName(), new File(this.dcm.getRoot()), config);
        }
        catch (Exception e) {
            logger.error("Failed to index single file", (Throwable)e);
            throw new IOException(e);
        }
    }

    private Grib2CollectionBuilder(CollectionManager dcm, Logger logger) {
        super(dcm, false, logger);
        FeatureCollectionConfig.GribConfig config = (FeatureCollectionConfig.GribConfig)dcm.getAuxInfo("gribConfig");
        this.gc = new Grib2Collection(dcm.getCollectionName(), new File(dcm.getRoot()), config);
    }

    private Grib2CollectionBuilder(String name, File directory, FeatureCollectionConfig.GribConfig config, Logger logger) {
        super(null, false, logger);
        this.gc = new Grib2Collection(name, directory, config);
    }

    protected Grib2CollectionBuilder(CollectionManager dcm, boolean isSingleFile, Logger logger) {
        super(dcm, isSingleFile, logger);
    }

    private void readOrCreateIndex(CollectionManager.Force ff) throws IOException {
        boolean force = ff == CollectionManager.Force.always || ff == CollectionManager.Force.test && this.needsUpdate();
        File idx = this.gc.getIndexFile();
        if (force || !idx.exists() || !this.readIndex(idx.getPath())) {
            idx = this.gc.makeNewIndexFile(this.logger);
            this.logger.info("{}: createIndex {}", (Object)this.gc.getName(), (Object)idx.getPath());
            this.createIndex(idx);
            RandomAccessFile indexRaf = new RandomAccessFile(idx.getPath(), "r");
            this.gc.setIndexRaf(indexRaf);
            this.readIndex(indexRaf);
        }
    }

    public boolean needsUpdate() {
        if (this.dcm == null) {
            return false;
        }
        File idx = this.gc.getIndexFile();
        return !idx.exists() || this.needsUpdate(idx.lastModified());
    }

    private boolean needsUpdate(long idxLastModified) {
        CollectionManager.ChangeChecker cc = GribIndex.getChangeChecker();
        for (MFile mfile : this.dcm.getFiles()) {
            if (!cc.hasChangedSince(mfile, idxLastModified)) continue;
            return true;
        }
        return false;
    }

    public String getMagicStart() {
        return MAGIC_START;
    }

    public boolean readIndex(String filename) throws IOException {
        return this.readIndex(new RandomAccessFile(filename, "r"));
    }

    protected boolean readIndex(RandomAccessFile raf) {
        this.gc.setIndexRaf(raf);
        try {
            int i;
            boolean versionOk;
            raf.order(0);
            raf.seek(0L);
            if (!NcStream.readAndTest((RandomAccessFile)raf, (byte[])this.getMagicStart().getBytes())) {
                this.logger.error("Grib2Collection {}: invalid index", (Object)this.gc.getName());
                return false;
            }
            this.gc.version = raf.readInt();
            boolean bl = this.isSingleFile ? this.gc.version >= 11 : (versionOk = this.gc.version >= 12);
            if (!versionOk) {
                this.logger.warn("Grib2Collection {}: index found version={}, want version= {} on file {}", new Object[]{this.gc.getName(), this.gc.version, 12, raf.getLocation()});
                return false;
            }
            long skip = raf.readLong();
            raf.skipBytes(skip);
            int size = NcStream.readVInt((RandomAccessFile)raf);
            if (size < 0 || size > 100000000) {
                this.logger.warn("Grib2Collection {}: invalid index ", (Object)this.gc.getName());
                return false;
            }
            byte[] m = new byte[size];
            raf.readFully(m);
            GribCollectionProto.GribCollectionIndex proto = GribCollectionProto.GribCollectionIndex.parseFrom(m);
            this.gc.center = proto.getCenter();
            this.gc.subcenter = proto.getSubcenter();
            this.gc.master = proto.getMaster();
            this.gc.local = proto.getLocal();
            this.gc.genProcessType = proto.getGenProcessType();
            this.gc.genProcessId = proto.getGenProcessId();
            this.gc.backProcessId = proto.getBackProcessId();
            this.gc.local = proto.getLocal();
            File dir = this.gc.getDirectory();
            String dirname = proto.getDirName();
            if (dir != null && !dir.getPath().equals(dirname)) {
                this.logger.debug("Grib2Collection {}: has different directory= {} than index= {} ", new Object[]{this.gc.getName(), dir.getPath(), dirname});
            }
            if (!(this instanceof Grib2TimePartitionBuilder)) {
                int i2;
                ArrayList<MFile> files;
                int n;
                if (this.gc.version < 12) {
                    n = proto.getFilesCount();
                    if (n == 0) {
                        this.logger.warn("Grib2Collection {}: has no files, force recreate ", (Object)this.gc.getName());
                        return false;
                    }
                    files = new ArrayList(proto.getFilesCount());
                    for (i2 = 0; i2 < n; ++i2) {
                        files.add(new GribCollectionBuilder.GcMFile(dir, proto.getFiles(i2), -1L));
                    }
                    this.gc.setFiles(files);
                    if (this.dcm != null) {
                        this.dcm.setFiles(files);
                    }
                } else {
                    n = proto.getMfilesCount();
                    if (n == 0) {
                        this.logger.warn("Grib2Collection {}: has no files, force recreate ", (Object)this.gc.getName());
                        return false;
                    }
                    files = new ArrayList<MFile>(n);
                    for (i2 = 0; i2 < n; ++i2) {
                        files.add(new GribCollectionBuilder.GcMFile(dir, proto.getMfiles(i2)));
                    }
                    this.gc.setFiles(files);
                    if (this.dcm != null) {
                        this.dcm.setFiles(files);
                    }
                }
            }
            this.gc.groups = new ArrayList<GribCollection.GroupHcs>(proto.getGroupsCount());
            for (i = 0; i < proto.getGroupsCount(); ++i) {
                this.gc.groups.add(this.readGroup(proto.getGroups(i), this.gc.makeGroup()));
            }
            this.gc.groups = Collections.unmodifiableList(this.gc.groups);
            this.gc.params = new ArrayList<Parameter>(proto.getParamsCount());
            for (i = 0; i < proto.getParamsCount(); ++i) {
                this.gc.params.add(this.readParam(proto.getParams(i)));
            }
            if (!this.readPartitions(proto, dirname)) {
                this.logger.warn("Time2Partition {}: has no partitions, force recreate ", (Object)this.gc.getName());
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Error reading index " + raf.getLocation(), t);
            return false;
        }
    }

    protected boolean readPartitions(GribCollectionProto.GribCollectionIndex proto, String dirname) {
        return true;
    }

    protected void readTimePartitions(GribCollection.GroupHcs group, GribCollectionProto.Group proto) {
    }

    GribCollection.GroupHcs readGroup(GribCollectionProto.Group p, GribCollection.GroupHcs group) throws IOException {
        int i;
        byte[] rawGds = p.getGds().toByteArray();
        Grib2SectionGridDefinition gdss = new Grib2SectionGridDefinition(rawGds);
        Grib2Gds gds = gdss.getGDS();
        gds.setCenter(this.gc.center);
        int gdsHash = p.getGdsHash() != 0 ? p.getGdsHash() : gds.hashCode();
        group.setHorizCoordSystem(gds.makeHorizCoordSys(), rawGds, gdsHash);
        group.varIndex = new ArrayList<GribCollection.VariableIndex>();
        for (i = 0; i < p.getVariablesCount(); ++i) {
            group.varIndex.add(this.readVariable(p.getVariables(i), group));
        }
        Collections.sort(group.varIndex);
        group.timeCoords = new ArrayList<TimeCoord>(p.getTimeCoordsCount());
        for (i = 0; i < p.getTimeCoordsCount(); ++i) {
            group.timeCoords.add(this.readTimeCoord(p.getTimeCoords(i)));
        }
        group.vertCoords = new ArrayList<VertCoord>(p.getVertCoordsCount());
        for (i = 0; i < p.getVertCoordsCount(); ++i) {
            group.vertCoords.add(this.readVertCoord(p.getVertCoords(i)));
        }
        group.ensCoords = new ArrayList<EnsCoord>(p.getEnsCoordsCount());
        for (i = 0; i < p.getEnsCoordsCount(); ++i) {
            group.ensCoords.add(this.readEnsCoord(p.getEnsCoords(i)));
        }
        group.filenose = new int[p.getFilenoCount()];
        for (i = 0; i < p.getFilenoCount(); ++i) {
            group.filenose[i] = p.getFileno(i);
        }
        this.readTimePartitions(group, p);
        for (GribCollection.VariableIndex vi : group.varIndex) {
            TimeCoord tc = group.timeCoords.get(vi.timeIdx);
            vi.ntimes = tc.getSize();
            VertCoord vc = vi.vertIdx < 0 ? null : group.vertCoords.get(vi.vertIdx);
            vi.nverts = vc == null ? 0 : vc.getSize();
            EnsCoord ec = vi.ensIdx < 0 ? null : group.ensCoords.get(vi.ensIdx);
            vi.nens = ec == null ? 0 : ec.getSize();
        }
        return group;
    }

    private Parameter readParam(GribCollectionProto.Parameter pp) throws IOException {
        if (pp.hasSdata()) {
            return new Parameter(pp.getName(), pp.getSdata());
        }
        int count = 0;
        double[] vals = new double[pp.getDataCount()];
        for (double val : pp.getDataList()) {
            vals[count++] = val;
        }
        return new Parameter(pp.getName(), vals);
    }

    private TimeCoord readTimeCoord(GribCollectionProto.Coord pc) throws IOException {
        if (pc.getBoundCount() > 0) {
            ArrayList<TimeCoord.Tinv> coords = new ArrayList<TimeCoord.Tinv>(pc.getValuesCount());
            for (int i = 0; i < pc.getValuesCount(); ++i) {
                coords.add(new TimeCoord.Tinv((int)pc.getValues(i), (int)pc.getBound(i)));
            }
            TimeCoord tc = new TimeCoord(pc.getCode(), pc.getUnit(), coords);
            return tc.setIndex(pc.getIndex());
        }
        ArrayList<Integer> coords = new ArrayList<Integer>(pc.getValuesCount());
        for (float value : pc.getValuesList()) {
            coords.add((int)value);
        }
        TimeCoord tc = new TimeCoord(pc.getCode(), pc.getUnit(), coords);
        return tc.setIndex(pc.getIndex());
    }

    private VertCoord readVertCoord(GribCollectionProto.Coord pc) throws IOException {
        boolean isLayer = pc.getBoundCount() > 0;
        ArrayList<VertCoord.Level> coords = new ArrayList<VertCoord.Level>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); ++i) {
            coords.add(new VertCoord.Level(pc.getValues(i), isLayer ? (double)pc.getBound(i) : 0.0));
        }
        return new VertCoord(pc.getCode(), coords, isLayer);
    }

    private EnsCoord readEnsCoord(GribCollectionProto.Coord pc) throws IOException {
        ArrayList<EnsCoord.Coord> coords = new ArrayList<EnsCoord.Coord>(pc.getValuesCount());
        for (int i = 0; i < pc.getValuesCount(); i += 2) {
            coords.add(new EnsCoord.Coord((int)pc.getValues(i), (int)pc.getValues(i + 1)));
        }
        return new EnsCoord(coords);
    }

    protected GribCollection.VariableIndex readVariable(GribCollectionProto.Variable pv, GribCollection.GroupHcs group) {
        int discipline = pv.getDiscipline();
        int category = pv.getCategory();
        int param = pv.getParameter();
        int levelType = pv.getLevelType();
        int intvType = pv.getIntervalType();
        String intvName = pv.getIntvName();
        boolean isLayer = pv.getIsLayer();
        int ensDerivedType = pv.getEnsDerivedType();
        int probType = pv.getProbabilityType();
        String probabilityName = pv.getProbabilityName();
        int cdmHash = pv.getCdmHash();
        long recordsPos = pv.getRecordsPos();
        int recordsLen = pv.getRecordsLen();
        int timeIdx = pv.getTimeIdx();
        int vertIdx = pv.getVertIdx();
        int ensIdx = pv.getEnsIdx();
        int tableVersion = pv.getTableVersion();
        int genProcessType = pv.getGenProcessType();
        return this.gc.makeVariableIndex(group, tableVersion, discipline, category, param, levelType, isLayer, intvType, intvName, ensDerivedType, probType, probabilityName, genProcessType, cdmHash, timeIdx, vertIdx, ensIdx, recordsPos, recordsLen);
    }

    private boolean createIndex(File indexFile) throws IOException {
        if (this.dcm == null) {
            this.logger.error("Grib2CollectionBuilder " + this.gc.getName() + " : cannot create new index ");
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        ArrayList<MFile> files = new ArrayList<MFile>();
        List<Group> groups = this.makeAggregatedGroups(files);
        this.createIndex(indexFile, groups, files);
        long took = System.currentTimeMillis() - start;
        this.logger.debug("That took {} msecs", (Object)took);
        return true;
    }

    public List<Group> makeAggregatedGroups(List<MFile> files) throws IOException {
        FeatureCollectionConfig.GribIntvFilter intvMap;
        HashMap<Integer, Group> gdsMap = new HashMap<Integer, Group>();
        Map pdsConvert = null;
        this.logger.debug("GribCollection {}: makeAggregatedGroups", (Object)this.gc.getName());
        int fileno = 0;
        Grib2Rectilyser.Counter stats = new Grib2Rectilyser.Counter();
        this.logger.debug(" dcm={}", (Object)this.dcm);
        FeatureCollectionConfig.GribConfig config = (FeatureCollectionConfig.GribConfig)this.dcm.getAuxInfo("gribConfig");
        Map gdsConvert = config != null ? config.gdsHash : null;
        FeatureCollectionConfig.GribIntvFilter gribIntvFilter = intvMap = config != null ? config.intvFilter : null;
        if (config != null) {
            pdsConvert = config.pdsHash;
        }
        for (MFile mfile : this.dcm.getFiles()) {
            Grib2Index index = null;
            try {
                index = (Grib2Index)GribIndex.readOrCreateIndexFromSingleFile(false, !this.isSingleFile, mfile, config, CollectionManager.Force.test, this.logger);
                files.add(mfile);
            }
            catch (IOException ioe) {
                this.logger.error("Grib2CollectionBuilder " + this.gc.getName() + " : reading/Creating gbx9 index for file " + mfile.getPath() + " failed", (Throwable)ioe);
                continue;
            }
            for (Grib2Record gr : index.getRecords()) {
                Group g;
                if (this.tables == null) {
                    Grib2SectionIdentification ids = gr.getId();
                    this.tables = Grib2Customizer.factory(ids.getCenter_id(), ids.getSubcenter_id(), ids.getMaster_table_version(), ids.getLocal_table_version());
                    if (config != null) {
                        this.tables.setTimeUnitConverter(config.getTimeUnitConverter());
                    }
                }
                if (intvMap != null && this.filterOut(gr, intvMap)) {
                    ++stats.filter;
                    continue;
                }
                gr.setFile(fileno);
                int gdsHash = gr.getGDSsection().getGDS().hashCode();
                if (gdsConvert != null && gdsConvert.get(gdsHash) != null) {
                    gdsHash = (Integer)gdsConvert.get(gdsHash);
                }
                if ((g = (Group)gdsMap.get(gdsHash)) == null) {
                    g = new Group(gr.getGDSsection(), gdsHash);
                    gdsMap.put(gdsHash, g);
                }
                g.records.add(gr);
            }
            ++fileno;
            stats.recordsTotal += index.getRecords().size();
        }
        ArrayList<Group> result = new ArrayList<Group>(gdsMap.values());
        for (Group g : result) {
            g.rect = new Grib2Rectilyser(this.tables, g.records, g.gdsHash, pdsConvert);
            g.rect.make(stats, files);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(stats.show());
        }
        return result;
    }

    private boolean filterOut(Grib2Record gr, FeatureCollectionConfig.GribIntvFilter intvFilter) {
        int[] intv = this.tables.getForecastTimeIntervalOffset(gr);
        if (intv == null) {
            return false;
        }
        int haveLength = intv[1] - intv[0];
        if (haveLength == 0 && intvFilter.isZeroExcluded()) {
            return intv[0] == 0 && intv[1] == 0;
        }
        if (intvFilter.hasFilter()) {
            int discipline = gr.getIs().getDiscipline();
            Grib2Pds pds = gr.getPDS();
            int category = pds.getParameterCategory();
            int number = pds.getParameterNumber();
            int id = (discipline << 16) + (category << 8) + number;
            int prob = Integer.MIN_VALUE;
            if (pds.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
                prob = (int)(1000.0 * pdsProb.getProbabilityUpperLimit());
            }
            return intvFilter.filterOut(id, haveLength, prob);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(File indexFile, List<Group> groups, List<MFile> files) throws IOException {
        Grib2Record first = null;
        boolean deleteOnClose = false;
        if (indexFile.exists() && !indexFile.delete()) {
            this.logger.error("gc2 cant delete index file {}", (Object)indexFile.getPath());
        }
        this.logger.debug(" createIndex for {}", (Object)indexFile.getPath());
        RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "rw");
        raf.order(0);
        try {
            raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
            raf.writeInt(12);
            long lenPos = raf.getFilePointer();
            raf.writeLong(0L);
            long countBytes = 0L;
            int countRecords = 0;
            for (Group g : groups) {
                g.fileSet = new HashSet<Integer>();
                for (Grib2Rectilyser.VariableBag vb : g.rect.getGribvars()) {
                    if (first == null) {
                        first = vb.first;
                    }
                    GribCollectionProto.VariableRecords vr = this.writeRecordsProto(vb, g.fileSet);
                    byte[] b = vr.toByteArray();
                    vb.pos = raf.getFilePointer();
                    vb.length = b.length;
                    raf.write(b);
                    countBytes += (long)b.length;
                    countRecords += vb.recordMap.length;
                }
            }
            long bytesPerRecord = countBytes / (long)(countRecords == 0 ? 1 : countRecords);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  write RecordMaps: bytes = {} record = {} bytesPerRecord={}", new Object[]{countBytes, countRecords, bytesPerRecord});
            }
            if (first == null) {
                deleteOnClose = true;
                this.logger.error("GribCollection {}: has no files", (Object)this.gc.getName());
                throw new IOException("GribCollection " + this.gc.getName() + " has no files");
            }
            long pos = raf.getFilePointer();
            raf.seek(lenPos);
            raf.writeLong(countBytes);
            raf.seek(pos);
            GribCollectionProto.GribCollectionIndex.Builder indexBuilder = GribCollectionProto.GribCollectionIndex.newBuilder();
            indexBuilder.setName(this.gc.getName());
            indexBuilder.setDirName(this.gc.getDirectory().getPath());
            indexBuilder.setDirName(this.gc.getDirectory().getPath());
            List<GribCollectionBuilder.GcMFile> gcmfiles = GribCollectionBuilder.makeFiles(this.gc.getDirectory(), files);
            for (GribCollectionBuilder.GcMFile gcmfile : gcmfiles) {
                indexBuilder.addMfiles(gcmfile.makeProto());
            }
            for (Group g : groups) {
                indexBuilder.addGroups(this.writeGroupProto(g));
            }
            Grib2SectionIdentification ids = first.getId();
            indexBuilder.setCenter(ids.getCenter_id());
            indexBuilder.setSubcenter(ids.getSubcenter_id());
            indexBuilder.setMaster(ids.getMaster_table_version());
            indexBuilder.setLocal(ids.getLocal_table_version());
            Grib2Pds pds = first.getPDS();
            indexBuilder.setGenProcessType(pds.getGenProcessType());
            indexBuilder.setGenProcessId(pds.getGenProcessId());
            indexBuilder.setBackProcessId(pds.getBackProcessId());
            GribCollectionProto.GribCollectionIndex index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((RandomAccessFile)raf, (int)b.length);
            raf.write(b);
            this.logger.debug("  write GribCollectionIndex= {} bytes", (Object)b.length);
        }
        finally {
            this.logger.debug("  file size =  {} bytes", (Object)raf.length());
            if (raf != null) {
                raf.close();
            }
            if (deleteOnClose && !indexFile.delete()) {
                this.logger.error(" gc2 cant deleteOnClose index file {}", (Object)indexFile.getPath());
            }
        }
    }

    private GribCollectionProto.VariableRecords writeRecordsProto(Grib2Rectilyser.VariableBag vb, Set<Integer> fileSet) throws IOException {
        GribCollectionProto.VariableRecords.Builder b = GribCollectionProto.VariableRecords.newBuilder();
        b.setCdmHash(vb.cdmHash);
        for (Grib2Rectilyser.Record ar : vb.recordMap) {
            GribCollectionProto.Record.Builder br = GribCollectionProto.Record.newBuilder();
            if (ar == null || ar.gr == null) {
                br.setFileno(0);
                br.setPos(0L);
            } else {
                br.setFileno(ar.gr.getFile());
                fileSet.add(ar.gr.getFile());
                Grib2SectionDataRepresentation drs = ar.gr.getDataRepresentationSection();
                br.setPos(drs.getStartingPosition());
                if (ar.gr.isBmsReplaced()) {
                    Grib2SectionBitMap bms = ar.gr.getBitmapSection();
                    br.setBmsPos(bms.getStartingPosition());
                }
            }
            b.addRecords(br);
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(Group g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGds(ByteString.copyFrom((byte[])g.gdss.getRawBytes()));
        b.setGdsHash(g.gdsHash);
        for (Grib2Rectilyser.VariableBag vb : g.rect.getGribvars()) {
            b.addVariables(this.writeVariableProto(g.rect, vb));
        }
        List<TimeCoord> timeCoords = g.rect.getTimeCoords();
        for (int i = 0; i < timeCoords.size(); ++i) {
            b.addTimeCoords(this.writeCoordProto(timeCoords.get(i), i));
        }
        List<VertCoord> vertCoords = g.rect.getVertCoords();
        for (int i = 0; i < vertCoords.size(); ++i) {
            b.addVertCoords(this.writeCoordProto(vertCoords.get(i), i));
        }
        List<EnsCoord> ensCoords = g.rect.getEnsCoords();
        for (int i = 0; i < ensCoords.size(); ++i) {
            b.addEnsCoords(this.writeCoordProto(ensCoords.get(i), i));
        }
        for (Integer aFileSet : g.fileSet) {
            b.addFileno(aFileSet);
        }
        if (g.nameOverride != null) {
            b.setName(g.nameOverride);
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(Grib2Rectilyser rect, Grib2Rectilyser.VariableBag vb) throws IOException {
        int genType;
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vb.first.getDiscipline());
        Grib2Pds pds = vb.first.getPDS();
        b.setCategory(pds.getParameterCategory());
        b.setParameter(pds.getParameterNumber());
        b.setLevelType(pds.getLevelType1());
        b.setIsLayer(Grib2Utils.isLayer(vb.first));
        b.setIntervalType(pds.getStatisticalProcessType());
        b.setCdmHash(vb.cdmHash);
        b.setRecordsPos(vb.pos);
        b.setRecordsLen(vb.length);
        b.setTimeIdx(vb.timeCoordIndex);
        if (vb.vertCoordIndex >= 0) {
            b.setVertIdx(vb.vertCoordIndex);
        }
        if (vb.ensCoordIndex >= 0) {
            b.setEnsIdx(vb.ensCoordIndex);
        }
        if (pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds);
            b.setEnsDerivedType(pdsDerived.getDerivedForecastType());
        }
        if (pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds);
            b.setProbabilityName(pdsProb.getProbabilityName());
            b.setProbabilityType(pdsProb.getProbabilityType());
        }
        if (pds.isTimeInterval()) {
            b.setIntvName(rect.getTimeIntervalName(vb.timeCoordIndex));
        }
        if ((genType = pds.getGenProcessType()) != -9999) {
            b.setGenProcessType(pds.getGenProcessType());
        }
        return b.build();
    }

    protected GribCollectionProto.Parameter writeParamProto(Parameter param) throws IOException {
        GribCollectionProto.Parameter.Builder b = GribCollectionProto.Parameter.newBuilder();
        b.setName(param.getName());
        if (param.isString()) {
            b.setSdata(param.getStringValue());
        } else {
            for (int i = 0; i < param.getLength(); ++i) {
                b.addData(param.getNumericValue(i));
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(TimeCoord tc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(tc.getCode());
        b.setUnit(tc.getUnits());
        float scale = (float)tc.getTimeUnitScale();
        if (tc.isInterval()) {
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                b.addValues((float)tinv.getBounds1() * scale);
                b.addBound((float)tinv.getBounds2() * scale);
            }
        } else {
            for (int value : tc.getCoords()) {
                b.addValues((float)value * scale);
            }
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(VertCoord vc, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(vc.getCode());
        String units = vc.getUnits();
        if (units == null) {
            units = "";
        }
        b.setUnit(units);
        for (VertCoord.Level coord : vc.getCoords()) {
            if (vc.isLayer()) {
                b.addValues((float)coord.getValue1());
                b.addBound((float)coord.getValue2());
                continue;
            }
            b.addValues((float)coord.getValue1());
        }
        return b.build();
    }

    protected GribCollectionProto.Coord writeCoordProto(EnsCoord ec, int index) throws IOException {
        GribCollectionProto.Coord.Builder b = GribCollectionProto.Coord.newBuilder();
        b.setIndex(index);
        b.setCode(0);
        b.setUnit("");
        for (EnsCoord.Coord coord : ec.getCoords()) {
            b.addValues(coord.getCode());
            b.addValues(coord.getEnsMember());
        }
        return b.build();
    }

    private class Group {
        public Grib2SectionGridDefinition gdss;
        public int gdsHash;
        public Grib2Rectilyser rect;
        public List<Grib2Record> records = new ArrayList<Grib2Record>();
        public String nameOverride;
        public Set<Integer> fileSet;

        private Group(Grib2SectionGridDefinition gdss, int gdsHash) {
            this.gdss = gdss;
            this.gdsHash = gdsHash;
        }
    }
}

