/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.wmo.Util;
import ucar.unidata.util.StringUtil2;

@Immutable
public class Grib2Parameter
implements GribTables.Parameter,
Comparable<Grib2Parameter> {
    public final int discipline;
    public final int category;
    public final int number;
    public final String name;
    public final String unit;
    public final String abbrev;
    public final String desc;
    public final Float fill;
    public final Float missing;

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc, float fill, float missing) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = Util.cleanUnit((String)unit);
        this.desc = desc;
        this.fill = Float.valueOf(fill);
        this.missing = Float.valueOf(missing);
    }

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = Util.cleanUnit((String)unit);
        this.desc = desc;
        this.fill = null;
        this.missing = Float.valueOf(Float.NaN);
    }

    public Grib2Parameter(Grib2Parameter from, String name, String unit) {
        this.discipline = from.discipline;
        this.category = from.category;
        this.number = from.number;
        this.desc = from.desc;
        this.abbrev = from.abbrev;
        this.name = name.trim();
        this.unit = Util.cleanUnit((String)unit);
        this.fill = null;
        this.missing = Float.valueOf(Float.NaN);
    }

    @Override
    public String getId() {
        return this.discipline + "." + this.category + "." + this.number;
    }

    @Override
    public int compareTo(Grib2Parameter o) {
        int c = this.discipline - o.discipline;
        if (c != 0) {
            return c;
        }
        c = this.category - o.category;
        if (c != 0) {
            return c;
        }
        return this.number - o.number;
    }

    @Override
    public int getDiscipline() {
        return this.discipline;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public int getValue() {
        return -1;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getAbbrev() {
        return this.abbrev;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public Float getMissing() {
        return this.missing;
    }

    @Override
    public Float getFill() {
        return this.fill;
    }

    public String toString() {
        return "Grib2Parameter{discipline=" + this.discipline + ", category=" + this.category + ", number=" + this.number + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", abbrev='" + this.abbrev + '\'' + ", desc='" + this.desc + '\'' + ", fill='" + this.fill + '\'' + ", missing='" + this.missing + '\'' + '}';
    }

    public static void compareTables(String name1, String name2, List<? extends GribTables.Parameter> test, Grib2Customizer reference, Formatter f) {
        int extra = 0;
        int udunits = 0;
        int conflict = 0;
        f.format("Table 1 : %s%n", name1);
        f.format("Table 2 : %s%n", name2);
        for (GribTables.Parameter parameter : test) {
            boolean isUnitless2;
            String p2n;
            GribTables.Parameter parameter2 = reference.getParameter(parameter.getDiscipline(), parameter.getCategory(), parameter.getNumber());
            if (parameter2 == null) {
                if (parameter.getCategory() >= 192 || parameter.getNumber() >= 192) continue;
                ++extra;
                f.format("  WMO missing %s%n", parameter);
                continue;
            }
            String p1n = Util.cleanName((String)parameter.getName());
            if (!p1n.equalsIgnoreCase(p2n = Util.cleanName((String)parameter2.getName()))) {
                f.format("  p1=%10s %40s %15s %15s %s%n", parameter.getId(), parameter.getName(), parameter.getUnit(), parameter.getAbbrev(), parameter.getDescription());
                f.format("  p2=%10s %40s %15s %15s %s%n%n", parameter2.getId(), parameter2.getName(), parameter2.getUnit(), parameter2.getAbbrev(), parameter2.getDescription());
                ++conflict;
            }
            if (parameter.getUnit().equalsIgnoreCase(parameter2.getUnit())) continue;
            String cu1 = Util.cleanUnit((String)parameter.getUnit());
            String cu2 = Util.cleanUnit((String)parameter2.getUnit());
            boolean isUnitless1 = Grib2Parameter.isUnitless(cu1);
            if (isUnitless1 != (isUnitless2 = Grib2Parameter.isUnitless(cu2))) {
                f.format("  ud=%10s %s != %s for %s (%s)%n%n", parameter.getId(), cu1, cu2, parameter.getId(), parameter.getName());
                ++udunits;
                continue;
            }
            if (isUnitless1) continue;
            try {
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)cu1);
                if (su1.isCompatible(cu2)) continue;
                f.format("  ud=%10s %s (%s) != %s for %s (%s)%n%n", parameter.getId(), cu1, su1, cu2, parameter.getId(), parameter.getName());
                ++udunits;
            }
            catch (Exception e) {
                f.format("  udunits cant parse=%10s %15s %15s%n", parameter.getId(), cu1, cu2);
            }
        }
        f.format("Conflicts=%d extra=%d udunits=%d%n%n", conflict, extra, udunits);
        f.format("Parameters in %s not in %s%n", name1, name2);
        int local = 0;
        for (GribTables.Parameter parameter : test) {
            GribTables.Parameter p2 = reference.getParameter(parameter.getDiscipline(), parameter.getCategory(), parameter.getNumber());
            if (p2 != null) continue;
            ++local;
            f.format("  %s%n", parameter);
        }
        f.format(" missing=%d%n%n", local);
    }

    static boolean isUnitless(String unit) {
        if (unit == null) {
            return true;
        }
        String munge = unit.toLowerCase().trim();
        return (munge = StringUtil2.remove((String)munge, (int)40)).length() == 0 || munge.startsWith("numeric") || munge.startsWith("non-dim") || munge.startsWith("see") || munge.startsWith("proportion") || munge.startsWith("code") || munge.startsWith("0=") || munge.equals("1");
    }
}

