/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.GribLevelType;
import ucar.unidata.util.StringUtil2;

public class NcepHtmlScraper {
    private static final boolean debug = false;
    private static final boolean show = false;
    String dirOut;
    private int[] tableVersions = new int[]{2, 0, 128, 129, 130, 131, 133, 140, 0, 0, 141};

    public void setDirOut(String dirOut) {
        this.dirOut = dirOut;
    }

    void parseTable3() throws IOException {
        String url = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/table3.html";
        Document doc = Jsoup.parse((URL)new URL(url), (int)5000);
        System.out.printf("%s%n", doc);
        HashSet abbrevSet = new HashSet();
        org.jsoup.nodes.Element table = (org.jsoup.nodes.Element)doc.select("table").get(2);
        ArrayList<GribLevelType> stuff = new ArrayList<GribLevelType>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (cols.size() != 3) continue;
            String snum = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(0)).text()).trim();
            try {
                int pnum = Integer.parseInt(snum);
                String desc = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(1)).text()).trim();
                String abbrev = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(2)).text()).trim();
                if (desc.startsWith("Reserved")) {
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                System.out.printf("%d == %s, %s%n", pnum, desc, abbrev);
                if (abbrevSet.contains(abbrev)) {
                    System.out.printf("DUPLICATE ABBREV %s%n", abbrev);
                    continue;
                }
                stuff.add(new GribLevelType(pnum, desc, abbrev, null, null, false, false));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        this.writeTable3Xml("NCEP GRIB-1 Table 3", url, "ncepTable3.xml", stuff);
    }

    private void writeTable3Xml(String name, String source, String filename, List<GribLevelType> stuff) throws IOException {
        Element rootElem = new Element("table3");
        org.jdom2.Document doc = new org.jdom2.Document(rootElem);
        rootElem.addContent((Content)new Element("title").setText(name));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (GribLevelType p : stuff) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.getCode()));
            paramElem.addContent((Content)new Element("description").setText(p.getDesc()));
            paramElem.addContent((Content)new Element("abbrev").setText(p.getAbbrev()));
            String units = p.getUnits();
            if (units == null) {
                units = this.handcodedUnits(p.getCode());
            }
            if (units != null) {
                paramElem.addContent((Content)new Element("units").setText(units));
            }
            if (p.getDatum() != null) {
                paramElem.addContent((Content)new Element("datum").setText(p.getDatum()));
            }
            if (p.isPositiveUp()) {
                paramElem.addContent((Content)new Element("isPositiveUp").setText("true"));
            }
            if (p.isLayer()) {
                paramElem.addContent((Content)new Element("isLayer").setText("true"));
            }
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename);){
            fout.write(x.getBytes(CDM.utf8Charset));
        }
    }

    private String handcodedUnits(int code) {
        switch (code) {
            case 216: 
            case 217: 
            case 237: 
            case 238: {
                return "m";
            }
            case 235: {
                return ".1 degC";
            }
        }
        return null;
    }

    void parseTableA() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/tablea.html";
        String base = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/";
        Document doc = Jsoup.parse((URL)new URL(source), (int)10000);
        org.jsoup.nodes.Element table = doc.select("table").first();
        if (table == null) {
            return;
        }
        ArrayList<Stuff> stuff = new ArrayList<Stuff>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (cols.size() != 2) continue;
            String snum = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(0)).text()).trim();
            try {
                int pnum = Integer.parseInt(snum);
                String desc = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(1)).text()).trim();
                if (desc.startsWith("Reserved")) {
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                System.out.printf("%d == %s%n", pnum, desc);
                stuff.add(new Stuff(pnum, desc));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        this.writeTableAXml("NCEP GRIB-1 Table A", source, "ncepTableA.xml", stuff);
    }

    private void writeTableAXml(String name, String source, String filename, List<Stuff> stuff) throws IOException {
        Element rootElem = new Element("tableA");
        org.jdom2.Document doc = new org.jdom2.Document(rootElem);
        rootElem.addContent((Content)new Element("title").setText(name));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Stuff p : stuff) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.no));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename);){
            fout.write(x.getBytes(CDM.utf8Charset));
        }
    }

    void parseTable2() throws IOException {
        String source = "http://www.nco.ncep.noaa.gov/pmb/docs/on388/table2.html";
        Document doc = Jsoup.parse((URL)new URL(source), (int)10000);
        int count = 0;
        for (org.jsoup.nodes.Element e : doc.select("big")) {
            System.out.printf("%d == %s%n=%n", count++, e.text());
        }
        org.jsoup.nodes.Element body = doc.select("body").first();
        if (body == null) {
            return;
        }
        Elements tables = body.select("table");
        for (int i = 0; i < this.tableVersions.length; ++i) {
            if (this.tableVersions[i] == 0) continue;
            org.jsoup.nodes.Element table = (org.jsoup.nodes.Element)tables.select("table").get(i);
            List<Param> params = this.readTable2(table);
            String name = "NCEP Table Version " + this.tableVersions[i];
            String filename = "ncepGrib1-" + this.tableVersions[i];
            this.writeTable2Wgrib(name, source, filename + ".tab", params);
            this.writeTable2Xml(name, source, filename + ".xml", params);
        }
    }

    private List<Param> readTable2(org.jsoup.nodes.Element table) {
        ArrayList<Param> result = new ArrayList<Param>();
        Elements rows = table.select("tr");
        for (org.jsoup.nodes.Element row : rows) {
            Elements cols = row.select("td");
            if (cols.size() != 4) continue;
            String snum = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(0)).text()).trim();
            try {
                int pnum = Integer.parseInt(snum);
                String desc = StringUtil2.cleanup((String)((org.jsoup.nodes.Element)cols.get(1)).text()).trim();
                if (desc.startsWith("Reserved")) {
                    System.out.printf("*** Skip Reserved %s%n", row.text());
                    continue;
                }
                result.add(new Param(pnum, desc, ((org.jsoup.nodes.Element)cols.get(2)).text(), ((org.jsoup.nodes.Element)cols.get(3)).text()));
            }
            catch (NumberFormatException e) {
                System.out.printf("*** Cant parse %s == %s%n", snum, row.text());
            }
        }
        return result;
    }

    private void writeTable2Xml(String name, String source, String filename, List<Param> params) throws IOException {
        Element rootElem = new Element("parameterMap");
        org.jdom2.Document doc = new org.jdom2.Document(rootElem);
        rootElem.addContent((Content)new Element("title").setText(name));
        rootElem.addContent((Content)new Element("source").setText(source));
        for (Param p : params) {
            Element paramElem = new Element("parameter");
            paramElem.setAttribute("code", Integer.toString(p.pnum));
            paramElem.addContent((Content)new Element("shortName").setText(p.name));
            paramElem.addContent((Content)new Element("description").setText(p.desc));
            paramElem.addContent((Content)new Element("units").setText(p.unit));
            rootElem.addContent((Content)paramElem);
        }
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        String x = fmt.outputString(doc);
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename);){
            fout.write(x.getBytes(CDM.utf8Charset));
        }
    }

    private void writeTable2Wgrib(String name, String source, String filename, List<Param> params) throws IOException {
        Formatter f = new Formatter();
        f.format("# %s%n", name);
        f.format("# %s%n", source);
        for (Param p : params) {
            f.format("%3d:%s:%s [%s]%n", p.pnum, p.name, p.desc, p.unit);
        }
        try (FileOutputStream fout = new FileOutputStream(this.dirOut + filename);){
            fout.write(f.toString().getBytes(CDM.utf8Charset));
        }
    }

    public static void main(String[] args) throws IOException {
        NcepHtmlScraper scraper = new NcepHtmlScraper();
        scraper.setDirOut("/Users/sarms/Desktop/ncep/grib1/");
        scraper.parseTable2();
        scraper.parseTableA();
        scraper.parseTable3();
    }

    private static class Param {
        int pnum;
        String desc;
        String unit;
        String name;

        private Param(int pnum, String desc, String unit, String name) {
            this.pnum = pnum;
            this.desc = desc;
            this.unit = StringUtil2.cleanup((String)unit);
            this.name = StringUtil2.cleanup((String)name);
        }
    }

    private static class Stuff {
        int no;
        String desc;

        private Stuff(int no, String desc) {
            this.no = no;
            this.desc = desc;
        }
    }
}

