/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import java.util.Formatter;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.coverage.GribCoverageDataset;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.unidata.util.StringUtil2;

public class Grib2Collection
extends GribCollectionImmutable {
    Grib2Collection(GribCollectionMutable gc) {
        super(gc);
    }

    @Override
    @Nullable
    public NetcdfDataset getNetcdfDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(false, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib2Iosp iosp = new Grib2Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            return new NetcdfDataset((NetcdfFile)ncfile);
        }
        return null;
    }

    @Override
    @Nullable
    public GridDataset getGridDataset(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation() + "#" + group.getId(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(false, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            Grib2Iosp iosp = new Grib2Iosp(gc);
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)iosp, null, this.getLocation(), null);
            NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
            return new GridDataset(ncd);
        }
        return null;
    }

    @Override
    @Nullable
    public CoverageCollection getGridCoverage(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group, String filename, FeatureCollectionConfig gribConfig, Formatter errlog, Logger logger) throws IOException {
        if (filename == null) {
            GribCoverageDataset gribCov = new GribCoverageDataset(this, ds, group);
            return gribCov.createCoverageCollection();
        }
        MFile wantFile = this.findMFileByName(filename);
        if (wantFile != null) {
            GribCollectionImmutable gc = GribCdmIndex.openGribCollectionFromDataFile(false, wantFile, CollectionUpdateType.nocheck, gribConfig, errlog, logger);
            if (gc == null) {
                return null;
            }
            GribCoverageDataset gribCov = new GribCoverageDataset(gc, null, null);
            return gribCov.createCoverageCollection();
        }
        return null;
    }

    @Override
    public void addGlobalAttributes(AttributeContainer result) {
        String val = this.cust.getGeneratingProcessTypeName(this.getGenProcessType());
        if (val != null) {
            result.addAttribute(new Attribute("Type_of_generating_process", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.getGenProcessId())) != null) {
            result.addAttribute(new Attribute("Analysis_or_forecast_generating_process_identifier_defined_by_originating_centre", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.getBackProcessId())) != null) {
            result.addAttribute(new Attribute("Background_generating_process_identifier_defined_by_originating_centre", val));
        }
        result.addAttribute(new Attribute("file_format", DataFormatType.GRIB2.getDescription()));
    }

    @Override
    protected String makeVariableId(GribCollectionImmutable.VariableIndex vindex) {
        return Grib2Collection.makeVariableId(vindex, this);
    }

    private static String makeVariableId(GribCollectionImmutable.VariableIndex vindex, GribCollectionImmutable gc) {
        try (Formatter f = new Formatter();){
            String intvName;
            f.format("VAR_%d-%d-%d", vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter());
            if (vindex.getGenProcessType() == 6 || vindex.getGenProcessType() == 7) {
                f.format("_error", new Object[0]);
            }
            if (vindex.getLevelType() != -9999) {
                f.format("_L%d", vindex.getLevelType());
                if (vindex.isLayer()) {
                    f.format("_layer", new Object[0]);
                }
            }
            if ((intvName = vindex.getIntvName()) != null && !intvName.isEmpty()) {
                if (intvName.equals("Mixed_intervals")) {
                    f.format("_Imixed", new Object[0]);
                } else {
                    f.format("_I%s", intvName);
                }
            }
            if (vindex.getIntvType() >= 0) {
                f.format("_S%s", vindex.getIntvType());
            }
            if (vindex.getEnsDerivedType() >= 0) {
                f.format("_D%d", vindex.getEnsDerivedType());
            } else if (vindex.getProbabilityName() != null && !vindex.getProbabilityName().isEmpty()) {
                String s = StringUtil2.substitute((String)vindex.getProbabilityName(), (String)".", (String)"p");
                f.format("_Prob_%s", s);
            }
            String string = f.toString();
            return string;
        }
    }

    @Override
    public void addVariableAttributes(AttributeContainer v, GribCollectionImmutable.VariableIndex vindex) {
        Grib2Collection.addVariableAttributes(v, vindex, this);
    }

    static void addVariableAttributes(AttributeContainer v, GribCollectionImmutable.VariableIndex vindex, GribCollectionImmutable gc) {
        String statType;
        String ldesc;
        GribTables.Parameter entry;
        String cat;
        Grib2Tables cust2 = (Grib2Tables)gc.cust;
        v.addAttribute(new Attribute("Grib_Variable_Id", gc.makeVariableId(vindex)));
        int[] param = new int[]{vindex.getDiscipline(), vindex.getCategory(), vindex.getParameter()};
        v.addAttribute(new Attribute("Grib2_Parameter", Array.makeFromJavaArray((Object)param, (boolean)false)));
        String disc = cust2.getCodeTableValue("0.0", vindex.getDiscipline());
        if (disc != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Discipline", disc));
        }
        if ((cat = cust2.getCategory(vindex.getDiscipline(), vindex.getCategory())) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Category", cat));
        }
        if ((entry = cust2.getParameter(vindex)) != null) {
            v.addAttribute(new Attribute("Grib2_Parameter_Name", entry.getName()));
        }
        if (vindex.getLevelType() != 255) {
            v.addAttribute(new Attribute("Grib2_Level_Type", (Number)vindex.getLevelType()));
        }
        if ((ldesc = cust2.getLevelName(vindex.getLevelType())) != null) {
            v.addAttribute(new Attribute("Grib2_Level_Desc", ldesc));
        }
        if (vindex.getEnsDerivedType() >= 0) {
            v.addAttribute(new Attribute("Grib2_Ensemble_Derived_Type", (Number)vindex.getEnsDerivedType()));
        } else if (vindex.getProbabilityName() != null && !vindex.getProbabilityName().isEmpty()) {
            v.addAttribute(new Attribute("Grib2_Probability_Type", (Number)vindex.getProbType()));
            v.addAttribute(new Attribute("Grib2_Probability_Name", vindex.getProbabilityName()));
        }
        if (vindex.getGenProcessType() >= 0) {
            String genProcessTypeName = cust2.getGeneratingProcessTypeName(vindex.getGenProcessType());
            if (genProcessTypeName != null) {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", genProcessTypeName));
            } else {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", (Number)vindex.getGenProcessType()));
            }
        }
        if ((statType = cust2.getStatisticName(vindex.getIntvType())) != null) {
            v.addAttribute(new Attribute("Grib2_Statistical_Process_Type", statType));
        }
    }
}

