/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.Grib1Collection;
import ucar.nc2.grib.collection.GribCollectionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1GdsPredefined;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.unidata.io.RandomAccessFile;

public class Grib1CollectionBuilderFromIndex
extends GribCollectionBuilderFromIndex {
    protected Grib1Customizer cust;

    @Nullable
    static Grib1Collection readFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) {
        Grib1CollectionBuilderFromIndex builder = new Grib1CollectionBuilderFromIndex(name, config, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().isEmpty()) {
            logger.warn("Grib1CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return new Grib1Collection(builder.gc);
    }

    @Nullable
    static GribCollectionMutable openMutableGCFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) {
        Grib1CollectionBuilderFromIndex builder = new Grib1CollectionBuilderFromIndex(name, config, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().isEmpty()) {
            logger.warn("Grib1CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return builder.gc;
    }

    Grib1CollectionBuilderFromIndex(String name, FeatureCollectionConfig config, Logger logger) {
        super(new GribCollectionMutable(name, null, config, true), config, logger);
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected int getMinVersion() {
        return 1;
    }

    @Override
    protected String getMagicStart() {
        return "Grib1Collectio2Index";
    }

    @Override
    protected GribTables makeCustomizer() throws IOException {
        Grib1ParamTables ptables = this.config.gribConfig.paramTable != null ? Grib1ParamTables.factory(this.config.gribConfig.paramTable) : Grib1ParamTables.factory(this.config.gribConfig.paramTablePath, this.config.gribConfig.lookupTablePath);
        this.cust = Grib1Customizer.factory(this.gc.center, this.gc.subcenter, this.gc.version, ptables);
        return this.cust;
    }

    @Override
    protected String getLevelNameShort(int levelCode) {
        return this.cust.getLevelNameShort(levelCode);
    }

    @Override
    protected GribHorizCoordSystem readGds(GribCollectionProto.Gds p) {
        Grib1Gds gds;
        byte[] rawGds = null;
        int predefined = -1;
        if (p.getPredefinedGridDefinition() > 0) {
            predefined = p.getPredefinedGridDefinition();
            gds = Grib1GdsPredefined.factory(this.gc.center, predefined);
        } else {
            rawGds = p.getGds().toByteArray();
            Grib1SectionGridDefinition gdss = new Grib1SectionGridDefinition(rawGds);
            gds = gdss.getGDS();
        }
        GdsHorizCoordSys hcs = gds.makeHorizCoordSys();
        String hcsName = hcs == null ? gds.getClass().getName() : this.makeHorizCoordSysName(hcs);
        String desc = null;
        if (this.config.gribConfig.gdsNamer != null) {
            desc = (String)this.config.gribConfig.gdsNamer.get(gds.hashCode());
        }
        if (desc == null) {
            desc = hcs == null ? hcsName : hcs.makeDescription();
        }
        return new GribHorizCoordSystem(hcs, rawGds, gds, hcsName, desc, predefined);
    }
}

