/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.util.List;
import ucar.nc2.grib.coord.TimeCoordIntvValue;

class GribTimeCoordIntervalUtils {
    GribTimeCoordIntervalUtils() {
    }

    public static int generateTimeCoordValuesFromTimeCoordIntervals(List<TimeCoordIntvValue> timeIntervals, double[] timeCoordValues, double[] bounds, int runOffsetIndex, int timeUnitValue, int time2D_Offset) {
        int dataIndex = runOffsetIndex;
        int boundsIndex = runOffsetIndex * 2;
        double[] currentBounds = new double[2];
        double[] prevBounds = new double[2];
        for (TimeCoordIntvValue tinv : timeIntervals) {
            currentBounds[0] = timeUnitValue * tinv.getBounds1() + time2D_Offset;
            currentBounds[1] = timeUnitValue * tinv.getBounds2() + time2D_Offset;
            timeCoordValues[dataIndex] = currentBounds[1];
            if (dataIndex >= runOffsetIndex + 1 && timeCoordValues[dataIndex] <= timeCoordValues[dataIndex - 1]) {
                timeCoordValues[dataIndex - 1] = dataIndex >= runOffsetIndex + 2 ? (timeCoordValues[dataIndex - 2] <= currentBounds[0] ? (currentBounds[1] - currentBounds[0]) / 2.0 + currentBounds[0] : (currentBounds[1] - timeCoordValues[dataIndex - 2]) / 2.0 + timeCoordValues[dataIndex - 2]) : (prevBounds[1] - prevBounds[0]) / 2.0 + prevBounds[0];
            }
            if (bounds != null) {
                bounds[boundsIndex++] = currentBounds[0];
                bounds[boundsIndex++] = currentBounds[1];
            }
            prevBounds[0] = currentBounds[0];
            prevBounds[1] = currentBounds[1];
            ++dataIndex;
        }
        return dataIndex;
    }
}

