/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.StringUtil2;

public class WriterProfileObsDataset {
    private static final String recordDimName = "record";
    private static final String stationDimName = "station";
    private static final String profileDimName = "profile";
    private static final String latName = "latitude";
    private static final String lonName = "longitude";
    private static final String altName = "altitude";
    private static final String timeName = "time";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String firstProfileName = "firstProfile";
    private static final String nextProfileName = "nextProfile";
    private static final String numProfilesName = "numProfiles";
    private static final String numProfilesTotalName = "numProfilesTotal";
    private static final String firstObsName = "firstChild";
    private static final String numObsName = "numChildren";
    private static final String nextObsName = "nextChild";
    private static final String parentStationIndex = "station_index";
    private static final String parentProfileIndex = "profile_index";
    private DateFormatter dateFormatter = new DateFormatter();
    private int name_strlen = 1;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private NetcdfFileWriteable ncfile;
    private String title;
    private Set<Dimension> dimSet = new HashSet<Dimension>();
    private List<Dimension> recordDims = new ArrayList<Dimension>();
    private List<Dimension> stationDims = new ArrayList<Dimension>();
    private List<Dimension> profileDims = new ArrayList<Dimension>();
    private List<Station> stnList;
    private Date minDate = null;
    private Date maxDate = null;
    private int nprofiles;
    private int profileIndex = 0;
    private boolean useAlt = false;
    private boolean useWmoId = false;
    private boolean debug = false;
    private HashMap<String, StationTracker> stationMap;
    private int recno = 0;
    private ArrayObject.D1 timeArray = new ArrayObject.D1(DataType.STRING, String.class, false, 1);
    private ArrayInt.D1 prevArray = new ArrayInt.D1(1, false);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1, false);
    private int[] origin = new int[1];
    private int[] originTime = new int[2];

    public WriterProfileObsDataset(String fileOut, String title) throws IOException {
        this.ncfile = NetcdfFileWriteable.createNew(fileOut, false);
        this.ncfile.setFill(false);
        this.title = title;
    }

    public void setLength(long size) {
        this.ncfile.setLength(size);
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, int nprofiles, String altVarName) throws IOException {
        this.createGlobalAttributes();
        this.createStations(stns);
        this.createProfiles(nprofiles);
        this.ncfile.addGlobalAttribute("zaxis_coordinate", altVarName);
        this.ncfile.addGlobalAttribute("time_coverage_start", this.dateFormatter.toDateTimeStringISO(new Date()));
        this.ncfile.addGlobalAttribute("time_coverage_end", this.dateFormatter.toDateTimeStringISO(new Date()));
        this.createDataVariables(vars);
        this.ncfile.create();
        this.writeStationData(stns);
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createGlobalAttributes() {
        this.ncfile.addGlobalAttribute("Conventions", "Unidata Observation Dataset v1.0");
        this.ncfile.addGlobalAttribute("cdm_datatype", "Profile");
        this.ncfile.addGlobalAttribute("title", this.title);
        this.ncfile.addGlobalAttribute("desc", "Extracted by THREDDS/Netcdf Subset Service");
    }

    private void createStations(List<Station> stnList) throws IOException {
        int i;
        int nstns = stnList.size();
        for (i = 0; i < nstns; ++i) {
            Station stn = stnList.get(i);
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (i = 0; i < nstns; ++i) {
            Station station = stnList.get(i);
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getName().length());
        }
        LatLonRect llbb = this.getBoundingBox(stnList);
        this.ncfile.addGlobalAttribute("geospatial_lat_min", Double.toString(llbb.getLowerLeftPoint().getLatitude()));
        this.ncfile.addGlobalAttribute("geospatial_lat_max", Double.toString(llbb.getUpperRightPoint().getLatitude()));
        this.ncfile.addGlobalAttribute("geospatial_lon_min", Double.toString(llbb.getLowerLeftPoint().getLongitude()));
        this.ncfile.addGlobalAttribute("geospatial_lon_max", Double.toString(llbb.getUpperRightPoint().getLongitude()));
        Dimension recordDim = this.ncfile.addUnlimitedDimension(recordDimName);
        this.recordDims.add(recordDim);
        Dimension stationDim = this.ncfile.addDimension(stationDimName, nstns);
        this.stationDims.add(stationDim);
        Variable v = this.ncfile.addVariable(latName, DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable(lonName, DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            v = this.ncfile.addVariable(altName, DataType.DOUBLE, stationDimName);
            this.ncfile.addVariableAttribute(v, new Attribute("units", "meters"));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station altitude"));
        }
        v = this.ncfile.addStringVariable(idName, this.stationDims, this.name_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station identifier"));
        v = this.ncfile.addStringVariable(descName, this.stationDims, this.desc_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station description"));
        if (this.useWmoId) {
            v = this.ncfile.addStringVariable(wmoName, this.stationDims, this.wmo_strlen);
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station WMO id"));
        }
        v = this.ncfile.addVariable(numProfilesName, DataType.INT, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "number of profiles in linked list for this station"));
        v = this.ncfile.addVariable(firstProfileName, DataType.INT, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "index of first profile in linked list for this station"));
    }

    private void createProfiles(int nprofiles) throws IOException {
        this.nprofiles = nprofiles;
        Dimension profileDim = this.ncfile.addDimension(profileDimName, nprofiles);
        this.profileDims.add(profileDim);
        Variable v = this.ncfile.addVariable(numObsName, DataType.INT, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "number of children in linked list for this profile"));
        v = this.ncfile.addVariable(numProfilesTotalName, DataType.INT, "");
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "number of valid profiles"));
        v = this.ncfile.addVariable(firstObsName, DataType.INT, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of first obs in linked list for this profile"));
        Variable timeVar = this.ncfile.addStringVariable(timeName, this.profileDims, 20);
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "ISO-8601 Date - time of observation"));
        v = this.ncfile.addVariable(parentStationIndex, DataType.INT, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "index of parent station"));
        v = this.ncfile.addVariable(nextProfileName, DataType.INT, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "index of next profile in linked list for this station"));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List dims;
        Variable v = this.ncfile.addVariable(parentProfileIndex, DataType.INT, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "index of parent profile"));
        v = this.ncfile.addVariable(nextObsName, DataType.INT, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of next obs in linked list for this profile"));
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(d.getShortName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder(recordDimName);
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = this.ncfile.addVariable(oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                this.ncfile.addVariableAttribute(newVar, att);
            }
        }
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        this.stnList = stnList;
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        if (this.debug) {
            System.out.println("stationMap created");
        }
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayObject.D1 idArray = new ArrayObject.D1(DataType.STRING, String.class, false, nstns);
        ArrayObject.D1 descArray = new ArrayObject.D1(DataType.STRING, String.class, false, nstns);
        ArrayObject.D1 wmoArray = new ArrayObject.D1(DataType.STRING, String.class, false, nstns);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), new StationTracker(i));
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.set(i, (Object)stn.getName());
            descArray.set(i, (Object)stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.set(i, (Object)stn.getWmoId());
        }
        try {
            this.ncfile.write(latName, (Array)latArray);
            this.ncfile.write(lonName, (Array)lonArray);
            if (this.useAlt) {
                this.ncfile.write(altName, (Array)altArray);
            }
            this.ncfile.writeStringData(idName, (Array)idArray);
            this.ncfile.writeStringData(descName, (Array)descArray);
            if (this.useWmoId) {
                this.ncfile.writeStringData(wmoName, (Array)wmoArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private void writeDataFinish() throws IOException {
        ArrayInt.D0 totalArray = new ArrayInt.D0(false);
        totalArray.set(this.profileIndex);
        try {
            this.ncfile.write(numProfilesTotalName, (Array)totalArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        int nstns = this.stnList.size();
        ArrayInt.D1 firstProfileArray = new ArrayInt.D1(nstns, false);
        ArrayInt.D1 numProfileArray = new ArrayInt.D1(nstns, false);
        ArrayInt.D1 nextProfileArray = new ArrayInt.D1(this.nprofiles, false);
        for (int i = 0; i < this.stnList.size(); ++i) {
            Station stn = this.stnList.get(i);
            StationTracker tracker = this.stationMap.get(stn.getName());
            numProfileArray.set(i, tracker.numChildren);
            int first = tracker.link.size() > 0 ? tracker.link.get(0) : -1;
            firstProfileArray.set(i, first);
            if (tracker.link.size() <= 0) continue;
            List<Integer> nextList = tracker.link;
            for (int j = 0; j < nextList.size() - 1; ++j) {
                Integer curr = nextList.get(j);
                Integer next = nextList.get(j + 1);
                nextProfileArray.set(curr.intValue(), next.intValue());
            }
            Integer curr = nextList.get(nextList.size() - 1);
            nextProfileArray.set(curr.intValue(), -1);
        }
        try {
            this.ncfile.write(firstProfileName, (Array)firstProfileArray);
            this.ncfile.write(numProfilesName, (Array)numProfileArray);
            this.ncfile.write(nextProfileName, (Array)nextProfileArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ArrayInt.D1 nextObsArray = new ArrayInt.D1(this.recno, false);
        ArrayInt.D1 firstObsArray = new ArrayInt.D1(this.nprofiles, false);
        ArrayInt.D1 numObsArray = new ArrayInt.D1(this.nprofiles, false);
        for (int i = 0; i < this.stnList.size(); ++i) {
            Station stn = this.stnList.get(i);
            StationTracker stnTracker = this.stationMap.get(stn.getName());
            Set<Date> dates = stnTracker.profileMap.keySet();
            for (Date date : dates) {
                ProfileTracker proTracker = stnTracker.profileMap.get(date);
                int trackerIndex = proTracker.parent_index;
                numObsArray.set(trackerIndex, proTracker.numChildren);
                int first = proTracker.link.size() > 0 ? proTracker.link.get(0) : -1;
                firstObsArray.set(trackerIndex, first);
                if (proTracker.link.size() <= 0) continue;
                List<Integer> nextList = proTracker.link;
                for (int j = 0; j < nextList.size() - 1; ++j) {
                    Integer curr = nextList.get(j);
                    Integer next = nextList.get(j + 1);
                    nextObsArray.set(curr.intValue(), next.intValue());
                }
                Integer curr = nextList.get(nextList.size() - 1);
                nextObsArray.set(curr.intValue(), -1);
            }
        }
        try {
            this.ncfile.write(firstObsName, (Array)firstObsArray);
            this.ncfile.write(numObsName, (Array)numObsArray);
            this.ncfile.write(nextObsName, (Array)nextObsArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_start", this.dateFormatter.toDateTimeStringISO(this.minDate)));
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_end", this.dateFormatter.toDateTimeStringISO(this.maxDate)));
    }

    public void writeRecord(StationObsDatatype sobs, StructureData sdata) throws IOException {
        if (this.debug) {
            System.out.println("sobs= " + sobs + "; station = " + sobs.getStation());
        }
        this.writeRecord(sobs.getStation().getName(), sobs.getObservationTimeAsDate(), sdata);
    }

    public void writeRecord(String stnName, Date obsDate, StructureData sdata) throws IOException {
        StationTracker stnTracker = this.stationMap.get(stnName);
        ProfileTracker proTracker = stnTracker.profileMap.get(obsDate);
        if (proTracker == null) {
            proTracker = new ProfileTracker(this.profileIndex);
            stnTracker.profileMap.put(obsDate, proTracker);
            stnTracker.link.add(this.profileIndex);
            stnTracker.lastChild = this.profileIndex;
            ++stnTracker.numChildren;
            try {
                this.originTime[0] = this.profileIndex++;
                this.timeArray.set(0, (Object)this.dateFormatter.toDateTimeStringISO(obsDate));
                this.parentArray.set(0, stnTracker.parent_index);
                this.ncfile.writeStringData(timeName, this.originTime, (Array)this.timeArray);
                this.ncfile.write(parentStationIndex, this.originTime, (Array)this.parentArray);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        if (this.minDate == null || this.minDate.after(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.before(obsDate)) {
            this.maxDate = obsDate;
        }
        this.timeArray.set(0, (Object)this.dateFormatter.toDateTimeStringISO(obsDate));
        this.parentArray.set(0, proTracker.parent_index);
        proTracker.link.add(this.recno);
        proTracker.lastChild = this.recno;
        ++proTracker.numChildren;
        this.origin[0] = this.recno;
        this.originTime[0] = this.recno++;
        try {
            this.ncfile.write(recordDimName, this.origin, (Array)sArray);
            this.ncfile.write(parentProfileIndex, this.originTime, (Array)this.parentArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void finish() throws IOException {
        this.writeDataFinish();
        this.ncfile.close();
    }

    private LatLonRect getBoundingBox(List stnList) {
        Station s = (Station)stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect((LatLonPoint)llpt, 0.001, 0.001);
        for (int i = 1; i < stnList.size(); ++i) {
            s = (Station)stnList.get(i);
            llpt.set(s.getLatitude(), s.getLongitude());
            rect.extend((LatLonPoint)llpt);
        }
        return rect;
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<String, Station> staHash = new HashMap<String, Station>();
        String location = "R:/testdata/sounding/netcdf/Upperair_20070401_0000.nc";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)location);
        ncfile.sendIospMessage((Object)"AddRecordStructure");
        StructureMembers sm = new StructureMembers("manLevel");
        Dimension manDim = ncfile.findDimension("manLevel");
        Structure record = (Structure)ncfile.findVariable(recordDimName);
        List allList = record.getVariables();
        ArrayList<VariableSimpleIF> varList = new ArrayList<VariableSimpleIF>();
        for (Variable v : allList) {
            if (v.getRank() != 1 || !v.getDimension(0).equals((Object)manDim)) continue;
            varList.add((VariableSimpleIF)new VariableDS(ncfile, null, null, v.getShortName(), v.getDataType(), "", v.getUnitsString(), v.getDescription()));
            sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), new int[0]);
        }
        ArrayStructureMA manAS = new ArrayStructureMA(sm, new int[]{manDim.getLength()});
        Variable time = ncfile.findVariable("synTime");
        String timeUnits = ncfile.findAttValueIgnoreCase(time, "units", null);
        timeUnits = StringUtil2.remove((String)timeUnits, (int)40);
        timeUnits = StringUtil2.remove((String)timeUnits, (int)41);
        DateUnit timeUnit = new DateUnit(timeUnits);
        int nrecs = 0;
        try (StructureDataIterator iter = record.getStructureIterator();){
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                String name = sdata.getScalarString("staName");
                Object s = (Station)staHash.get(name);
                if (s == null) {
                    float lat = sdata.convertScalarFloat("staLat");
                    float lon = sdata.convertScalarFloat("staLon");
                    float elev = sdata.convertScalarFloat("staElev");
                    s = new StationImpl(name, "", lat, lon, elev);
                    staHash.put(name, (Station)s);
                }
                ++nrecs;
            }
        }
        List<Station> stnList = Arrays.asList(staHash.values().toArray(new Station[staHash.size()]));
        Collections.sort(stnList);
        WriterProfileObsDataset writer = new WriterProfileObsDataset(location + ".out", "rewrite " + location);
        writer.writeHeader(stnList, varList, nrecs, "prMan");
        try (StructureDataIterator iter = record.getStructureIterator();){
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                String name = sdata.getScalarString("staName");
                double timeValue = sdata.convertScalarDouble("synTime");
                Date date = timeUnit.makeDate(timeValue);
                List names = sm.getMemberNames();
                for (String mname : names) {
                    manAS.setMemberArray(mname, sdata.getArray(mname));
                }
                int numMand = sdata.getScalarInt("numMand");
                if (numMand >= manDim.getLength()) continue;
                for (int i = 0; i < numMand; ++i) {
                    StructureData useData = manAS.getStructureData(i);
                    writer.writeRecord(name, date, useData);
                }
            }
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took);
    }

    private class ProfileTracker {
        int numChildren = 0;
        int lastChild = -1;
        int parent_index;
        List<Integer> link = new ArrayList<Integer>();

        ProfileTracker(int parent_index) {
            this.parent_index = parent_index;
        }
    }

    private class StationTracker {
        int numChildren = 0;
        int lastChild = -1;
        int parent_index;
        List<Integer> link = new ArrayList<Integer>();
        HashMap<Date, ProfileTracker> profileMap;

        StationTracker(int parent_index) {
            this.parent_index = parent_index;
            this.profileMap = new HashMap();
        }
    }
}

