/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.ServiceType;

public class InvService {
    public static final InvService cdmremote = new InvService("cdmremote", ServiceType.CdmRemote.toString(), "/thredds/cdmremote/", "", "");
    public static final InvService cdmrfeature = new InvService("cdmrfeature", ServiceType.CdmrFeature.toString(), "/thredds/cdmrfeature/", "", "");
    public static final InvService fileServer = new InvService("fileServer", ServiceType.HTTPServer.toString(), "/thredds/fileServer/", "", "");
    public static final InvService latest = new InvService("latest", ServiceType.RESOLVER.toString(), "", "", "");
    public static final InvService ncssGrid = new InvService("ncssGrid", ServiceType.NetcdfSubset.toString(), "/thredds/ncss/grid/", "", "");
    public static final InvService ncssPoint = new InvService("ncssPoint", ServiceType.NetcdfSubset.toString(), "/thredds/ncss/point/", "", "");
    public static final InvService opendap = new InvService("opendap", ServiceType.OPENDAP.toString(), "/thredds/dodsC/", "", "");
    public static final InvService dap4 = new InvService("dap4", ServiceType.DAP4.toString(), "/thredds/dap4/", "", "");
    public static final InvService wcs = new InvService("wcs", ServiceType.WCS.toString(), "/thredds/wcs/", "", "");
    public static final InvService wms = new InvService("wms", ServiceType.WMS.toString(), "/thredds/wms/", "", "");
    public static final InvService ncml = new InvService("ncml", ServiceType.NCML.toString(), "/thredds/ncml/", "", "");
    public static final InvService uddc = new InvService("uddc", ServiceType.UDDC.toString(), "/thredds/uddc/", "", "");
    public static final InvService iso = new InvService("iso", ServiceType.ISO.toString(), "/thredds/iso/", "", "");
    public static final InvService ncJSON = new InvService("ncjason", ServiceType.ncJSON.toString(), "/thredds/ncjason/", "", "");
    public static final InvService h5Service = new InvService("h5service", ServiceType.H5Service.toString(), "/thredds/h5service/", "", "");
    private String name;
    private String base;
    private String suffix;
    private String desc;
    private ServiceType type = null;
    private URI uri = null;
    private List<InvService> nestedServices = new ArrayList<InvService>();
    private List<InvProperty> properties = new ArrayList<InvProperty>();
    private List<InvProperty> roots = new ArrayList<InvProperty>();
    private StringBuilder log = new StringBuilder();

    public InvService(String name, String serviceTypeName, String base, String suffix, String desc) {
        this.name = name;
        this.type = ServiceType.findType(serviceTypeName);
        this.base = base == null ? "" : base.trim();
        this.suffix = suffix == null ? "" : suffix.trim();
        this.desc = desc;
        if (this.type == null) {
            this.log.append(" ** InvService: non-standard type =(").append(serviceTypeName).append(") for service (").append(name).append(")");
            this.type = ServiceType.getType(serviceTypeName);
        }
        if (name == null) {
            this.log.append(" ** InvService has no name");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getBase() {
        return this.base;
    }

    public ServiceType getServiceType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDescription() {
        return this.desc != null ? this.desc : this.type.toString();
    }

    public List<InvProperty> getProperties() {
        return this.properties;
    }

    public List<InvProperty> getDatasetRoots() {
        return this.roots;
    }

    public String findProperty(String name) {
        InvProperty result = null;
        for (InvProperty p : this.properties) {
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public InvService findNestedService(String name) {
        for (InvService s : this.nestedServices) {
            InvService result;
            if (s.getName().equals(name)) {
                return s;
            }
            if (s.type != ServiceType.COMPOUND || (result = s.findNestedService(name)) == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return "name:(" + this.name + ") type:(" + this.type + ") base:(" + this.base + ") suffix:(" + this.suffix + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvService that = (InvService)o;
        if (!this.base.equals(that.base)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.nestedServices != null ? !this.nestedServices.equals(that.nestedServices) : that.nestedServices != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.suffix != null ? !this.suffix.equals(that.suffix) : that.suffix != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.base.hashCode();
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.nestedServices != null ? this.nestedServices.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String dump() {
        return this.dump(0);
    }

    String dump(int n) {
        StringBuilder buff = new StringBuilder(200);
        buff.setLength(0);
        buff.append(InvDatasetImpl.indent(n)).append("Service ").append(this).append("\n");
        for (InvService s : this.getServices()) {
            buff.append(s.dump(n + 2));
        }
        List<InvProperty> props = this.getProperties();
        if (props.size() > 0) {
            String indent = InvDatasetImpl.indent(n + 2);
            buff.append(indent);
            buff.append("Properties:\n");
            for (InvProperty p : props) {
                buff.append(InvDatasetImpl.indent(n + 4)).append(p).append("\n");
            }
        }
        return buff.toString();
    }

    public void addService(InvService service) {
        this.nestedServices.add(service);
    }

    public void addProperty(InvProperty p) {
        this.properties.add(p);
    }

    public void addDatasetRoot(InvProperty root) {
        this.roots.add(root);
    }

    public List<InvService> getServices() {
        return this.nestedServices;
    }

    public String getFullName() {
        return this.name;
    }

    protected boolean check(StringBuilder out) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            out.append((CharSequence)this.log);
        }
        if (this.getServiceType() == ServiceType.COMPOUND) {
            if (this.getServices().size() < 1) {
                out.append(" ** InvService (").append(this.getName()).append(") type COMPOUND must have a nested service\n");
                isValid = false;
            }
        } else if (this.getServices().size() > 0) {
            out.append(" ** InvService(").append(this.getName()).append(") type ").append(this.getServiceType()).append(" may not have nested services\n");
            isValid = false;
        }
        try {
            this.uri = new URI(this.base);
        }
        catch (URISyntaxException e) {
            out.append(" ** InvService(").append(this.getName()).append(") invalid base URL =(").append(this.base).append(")");
            isValid = false;
        }
        return isValid;
    }

    public boolean isRelativeBase() {
        if (this.getServiceType() == ServiceType.COMPOUND) {
            return true;
        }
        if (this.uri == null) {
            try {
                this.uri = new URI(this.base);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return !this.uri.isAbsolute();
    }
}

