/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class StationDatasetHelper {
    private StationObsDataset obsDataset;
    private Map<String, Station> stationHash;
    private boolean debug = false;
    private LatLonRect rect;

    public StationDatasetHelper(StationObsDataset obsDataset) {
        this.obsDataset = obsDataset;
    }

    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            List<Station> stations;
            try {
                stations = this.obsDataset.getStations();
            }
            catch (IOException e) {
                return null;
            }
            if (stations.size() == 0) {
                return null;
            }
            Station s = stations.get(0);
            LatLonPointImpl llpt = new LatLonPointImpl();
            llpt.set(s.getLatitude(), s.getLongitude());
            this.rect = new LatLonRect((LatLonPoint)llpt, 0.0, 0.0);
            if (this.debug) {
                System.out.println("start=" + s.getLatitude() + " " + s.getLongitude() + " rect= " + this.rect.toString2());
            }
            for (int i = 1; i < stations.size(); ++i) {
                s = stations.get(i);
                llpt.set(s.getLatitude(), s.getLongitude());
                this.rect.extend((LatLonPoint)llpt);
                if (!this.debug) continue;
                System.out.println("add=" + s.getLatitude() + " " + s.getLongitude() + " rect= " + this.rect.toString2());
            }
        }
        if (this.rect.crossDateline() && this.rect.getWidth() > 350.0) {
            double lat_min = this.rect.getLowerLeftPoint().getLatitude();
            double deltaLat = this.rect.getUpperLeftPoint().getLatitude() - lat_min;
            this.rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(lat_min, -180.0), deltaLat, 360.0);
        }
        double newLowerLeftLat = this.rect.getLowerLeftPoint().getLatitude() - 5.0E-4;
        double newLowerLeftLon = this.rect.getLowerLeftPoint().getLongitude() - 5.0E-4;
        LatLonPointImpl newLowerLeftPoint = new LatLonPointImpl(newLowerLeftLat, newLowerLeftLon);
        double newUpperRightLat = this.rect.getUpperRightPoint().getLatitude() + 5.0E-4;
        double newUpperRightLon = this.rect.getUpperRightPoint().getLongitude() + 5.0E-4;
        LatLonPointImpl newUpperRightPoint = new LatLonPointImpl(newUpperRightLat, newUpperRightLon);
        this.rect.extend((LatLonPoint)newLowerLeftPoint);
        this.rect.extend((LatLonPoint)newUpperRightPoint);
        return this.rect;
    }

    public List<Station> getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<Station> result = new ArrayList<Station>();
        List<Station> stations = this.obsDataset.getStations();
        for (Station s : stations) {
            latlonPt.set(s.getLatitude(), s.getLongitude());
            if (boundingBox.contains((LatLonPoint)latlonPt)) {
                result.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public Station getStation(String name) {
        if (this.stationHash == null) {
            List<Station> stations;
            try {
                stations = this.obsDataset.getStations();
            }
            catch (IOException e) {
                return null;
            }
            this.stationHash = new HashMap<String, Station>(2 * stations.size());
            for (Station s : stations) {
                this.stationHash.put(s.getName(), s);
            }
        }
        return this.stationHash.get(name);
    }

    public List getStationObs(Station s, double startTime, double endTime, CancelTask cancel) throws IOException {
        ArrayList<StationObsDatatype> result = new ArrayList<StationObsDatatype>();
        List stationObs = this.obsDataset.getData(s, cancel);
        for (int i = 0; i < stationObs.size(); ++i) {
            StationObsDatatype obs = (StationObsDatatype)stationObs.get(i);
            double timeValue = obs.getObservationTime();
            if (timeValue >= startTime && timeValue <= endTime) {
                result.add(obs);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public List getStationObs(List<Station> stations, CancelTask cancel) throws IOException {
        ArrayList result = new ArrayList();
        for (int i = 0; i < stations.size(); ++i) {
            Station s = stations.get(i);
            result.addAll(this.obsDataset.getData(s, cancel));
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public List getStationObs(List<Station> stations, double startTime, double endTime, CancelTask cancel) throws IOException {
        ArrayList result = new ArrayList();
        for (int i = 0; i < stations.size(); ++i) {
            Station s = stations.get(i);
            result.addAll(this.getStationObs(s, startTime, endTime, cancel));
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public List getStationObs(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        List<Station> stations = this.obsDataset.getStations(boundingBox, cancel);
        if (stations == null) {
            return null;
        }
        return this.getStationObs(stations, cancel);
    }

    public List getStationObs(LatLonRect boundingBox, double startTime, double endTime, CancelTask cancel) throws IOException {
        List<Station> stations = this.obsDataset.getStations(boundingBox);
        if (stations == null) {
            return null;
        }
        return this.getStationObs(stations, startTime, endTime, cancel);
    }

    public void sortByTime(List<StationObsDatatype> stationObs) {
        Collections.sort(stationObs, new StationObsComparator());
    }

    private class StationObsComparator
    implements Comparator {
        private StationObsComparator() {
        }

        public int compare(Object o1, Object o2) {
            StationObsDatatype s1 = (StationObsDatatype)o1;
            StationObsDatatype s2 = (StationObsDatatype)o2;
            return (int)(s1.getObservationTime() - s2.getObservationTime());
        }
    }
}

