/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class ARMTrajectoryObsDataset
extends SingleTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private static String timeDimName = "time";
    private static String timeVarName = "time_offset";
    private static String latVarName = "lat";
    private static String lonVarName = "lon";
    private static String elevVarName = "alt";
    private static String trajId = "trajectory data";

    public static boolean isValidFile(NetcdfDataset ncd) {
        return ARMTrajectoryObsDataset.buildConfig(ncd) != null;
    }

    private static SingleTrajectoryObsDataset.Config buildConfig(NetcdfDataset ncd) {
        Attribute attrib = ncd.findGlobalAttributeIgnoreCase("ingest_software");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        if (attrib.getStringValue().indexOf("sonde_ingest.c") == -1) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("sounding_number");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("serial_number");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("launch_status");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("zeb_platform");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("history");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        if (attrib.getStringValue().indexOf("Zebra DataStore library") == -1 && attrib.getStringValue().indexOf("zebra-zeblib") == -1) {
            return null;
        }
        List list = ncd.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return null;
        }
        Dimension d = (Dimension)list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config();
        trajConfig.setTimeDim(d);
        Variable var = ncd.getRootGroup().findVariableLocal(timeVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        String units = var.findAttribute("units").getStringValue();
        Date date = DateUnit.getStandardDate((String)("0 " + units));
        if (date == null) {
            return null;
        }
        trajConfig.setTimeVar(var);
        var = ncd.getRootGroup().findVariableLocal(latVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"degrees_north")) {
            return null;
        }
        trajConfig.setLatVar(var);
        var = ncd.getRootGroup().findVariableLocal(lonVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible((String)units, (String)"degrees_east")) {
            return null;
        }
        trajConfig.setLonVar(var);
        var = ncd.getRootGroup().findVariableLocal(elevVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = (Dimension)list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (units.indexOf("meters") == -1) {
            return null;
        }
        ((VariableEnhanced)var).setUnitsString("meters");
        trajConfig.setElevVar(var);
        trajConfig.setTrajectoryId(trajId);
        return trajConfig;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return ARMTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new ARMTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public ARMTrajectoryObsDataset() {
    }

    public ARMTrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        SingleTrajectoryObsDataset.Config trajConfig = ARMTrajectoryObsDataset.buildConfig(ncd);
        this.setTrajectoryInfo(trajConfig);
    }
}

