/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.iosp.netcdf3.N3outputStreamWriter;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class WriterCFStationObsDataset {
    private static final String recordDimName = "record";
    private static final String stationDimName = "station";
    private static final String latName = "latitude";
    private static final String lonName = "longitude";
    private static final String altName = "altitude";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String timeName = "time";
    private static final String parentName = "parent_index";
    private DateFormatter dateFormatter = new DateFormatter();
    private int name_strlen;
    private int desc_strlen;
    private int wmo_strlen;
    private NetcdfFileStream ncfile;
    private String title;
    private Set<Dimension> dimSet = new HashSet<Dimension>();
    private List<Station> stnList;
    private List<Variable> recordVars = new ArrayList<Variable>();
    private Date minDate = null;
    private Date maxDate = null;
    private boolean useAlt = false;
    private boolean useWmoId = false;
    private boolean debug = false;
    private ArrayInt.D1 timeArray = new ArrayInt.D1(1, false);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1, false);
    private HashMap<String, StationTracker> stationMap;

    public WriterCFStationObsDataset(DataOutputStream stream, String title) {
        this.ncfile = new NetcdfFileStream(stream);
        this.title = title;
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, int numrec) throws IOException {
        this.createGlobalAttributes();
        this.createStations(stns);
        this.createRecordVariables(vars);
        this.ncfile.finish();
        this.ncfile.writeHeader(numrec);
        this.writeStationData(stns);
    }

    private void createGlobalAttributes() {
        this.ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        this.ncfile.addAttribute(null, new Attribute("cdm_datatype", "Station"));
        this.ncfile.addAttribute(null, new Attribute("title", this.title));
    }

    private void createStations(List<Station> stnList) throws IOException {
        int i;
        int nstns = stnList.size();
        for (i = 0; i < nstns; ++i) {
            Station stn = stnList.get(i);
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (i = 0; i < nstns; ++i) {
            Station station = stnList.get(i);
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getName().length());
        }
        LatLonRect llbb = this.getBoundingBox(stnList);
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", Double.toString(llbb.getLowerLeftPoint().getLatitude())));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", Double.toString(llbb.getUpperRightPoint().getLatitude())));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", Double.toString(llbb.getLowerLeftPoint().getLongitude())));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", Double.toString(llbb.getUpperRightPoint().getLongitude())));
        this.ncfile.addDimension(null, new Dimension(recordDimName, 0, true, true, false));
        this.ncfile.addDimension(null, new Dimension(stationDimName, nstns));
        Variable v = this.ncfile.addVariable(null, latName, DataType.DOUBLE, stationDimName);
        v.addAttribute(new Attribute("units", "degrees_north"));
        v.addAttribute(new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable(null, lonName, DataType.DOUBLE, stationDimName);
        v.addAttribute(new Attribute("units", "degrees_east"));
        v.addAttribute(new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            v = this.ncfile.addVariable(null, altName, DataType.DOUBLE, stationDimName);
            v.addAttribute(new Attribute("units", "meters"));
            v.addAttribute(new Attribute("long_name", "station altitude"));
            v.addAttribute(new Attribute("positive", "up"));
        }
        v = this.ncfile.addStringVariable(null, idName, stationDimName, this.name_strlen);
        v.addAttribute(new Attribute("long_name", "station identifier"));
        v = this.ncfile.addStringVariable(null, descName, stationDimName, this.desc_strlen);
        v.addAttribute(new Attribute("long_name", "station description"));
        if (this.useWmoId) {
            v = this.ncfile.addStringVariable(null, wmoName, stationDimName, this.wmo_strlen);
            v.addAttribute(new Attribute("long_name", "station WMO id"));
        }
    }

    private void createRecordVariables(List<VariableSimpleIF> dataVars) {
        List dims;
        Variable timeVar = this.ncfile.addVariable(null, timeName, DataType.INT, recordDimName);
        timeVar.addAttribute(new Attribute("units", "secs since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "calendar date"));
        this.recordVars.add(timeVar);
        timeVar.setCachedData((Array)this.timeArray, false);
        Variable parentVar = this.ncfile.addVariable(null, parentName, DataType.INT, recordDimName);
        parentVar.addAttribute(new Attribute("long_name", "index of parent station"));
        this.recordVars.add(parentVar);
        parentVar.setCachedData((Array)this.parentArray, false);
        Attribute coordAtt = new Attribute("coordinates", this.useAlt ? "latitude longitude altitude time" : "latitude longitude time");
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(null, new Dimension(d.getShortName(), d.getLength(), d.isShared(), false, d.isVariableLength()));
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder(recordDimName);
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getShortName());
            }
            Variable newVar = this.ncfile.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            this.recordVars.add(newVar);
            newVar.addAll((Iterable)oldVar.attributes());
            newVar.addAttribute(coordAtt);
        }
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        this.stnList = stnList;
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        if (this.debug) {
            System.out.println("stationMap created");
        }
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayChar.D2 idArray = new ArrayChar.D2(nstns, this.name_strlen);
        ArrayChar.D2 descArray = new ArrayChar.D2(nstns, this.desc_strlen);
        ArrayChar.D2 wmoArray = new ArrayChar.D2(nstns, this.wmo_strlen);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), new StationTracker(i));
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.setString(i, stn.getName());
            descArray.setString(i, stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.setString(i, stn.getWmoId());
        }
        try {
            this.ncfile.writeNonRecordData(latName, (Array)latArray);
            this.ncfile.writeNonRecordData(lonName, (Array)lonArray);
            if (this.useAlt) {
                this.ncfile.writeNonRecordData(altName, (Array)altArray);
            }
            this.ncfile.writeNonRecordData(idName, (Array)idArray);
            this.ncfile.writeNonRecordData(descName, (Array)descArray);
            if (this.useWmoId) {
                this.ncfile.writeNonRecordData(wmoName, (Array)wmoArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(StationObsDatatype sobs, StructureData sdata) throws IOException {
        if (this.debug) {
            System.out.println("sobs= " + sobs + "; station = " + sobs.getStation());
        }
        for (Variable v : this.recordVars) {
            if (timeName.equals(v.getShortName())) {
                Date d = sobs.getObservationTimeAsDate();
                int secs = (int)(d.getTime() / 1000L);
                this.timeArray.set(0, secs);
                continue;
            }
            if (parentName.equals(v.getShortName())) {
                int stationIndex = this.stnList.indexOf(sobs.getStation());
                this.parentArray.set(0, stationIndex);
                continue;
            }
            v.setCachedData(sdata.getArray(v.getShortName()), false);
        }
        this.ncfile.writeRecordData(this.recordVars);
    }

    public void finish() throws IOException {
        this.ncfile.close();
    }

    private LatLonRect getBoundingBox(List stnList) {
        Station s = (Station)stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect((LatLonPoint)llpt, 0.001, 0.001);
        for (int i = 1; i < stnList.size(); ++i) {
            s = (Station)stnList.get(i);
            llpt.set(s.getLatitude(), s.getLongitude());
            rect.extend((LatLonPoint)llpt);
        }
        return rect;
    }

    public static void main3(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        String location = "C:/data/metars/Surface_METAR_20070329_0000.nc";
        StringBuilder errlog = new StringBuilder();
        StationObsDataset sobs = (StationObsDataset)TypedDatasetFactory.open(FeatureType.STATION, location, null, errlog);
        String fileOut = "C:/temp/Surface_METAR_20070329_0000.stream.nc";
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(fos);
        System.out.println("Read " + location + " write to " + fileOut);
        WriterCFStationObsDataset writer = new WriterCFStationObsDataset(out, "test");
        List<Station> stns = sobs.getStations();
        ArrayList<Station> stnList = new ArrayList<Station>();
        Station s = stns.get(0);
        stnList.add(s);
        ArrayList<VariableSimpleIF> varList = new ArrayList<VariableSimpleIF>();
        varList.add(sobs.getDataVariable("wind_speed"));
        writer.writeHeader(stnList, varList, -1);
        DataIterator iter = sobs.getDataIterator(s);
        while (iter.hasNext()) {
            StationObsDatatype sobsData = (StationObsDatatype)iter.nextData();
            StructureData data = sobsData.getData();
            writer.writeRecord(sobsData, data);
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took + " msecs");
    }

    public static void rewrite(String fileIn, String fileOut, boolean inMemory, boolean sort) throws IOException {
        System.out.println("Rewrite .nc files from " + fileIn + " to " + fileOut + "inMem= " + inMemory + " sort= " + sort);
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = inMemory ? NetcdfFile.openInMemory((String)fileIn) : NetcdfFile.open((String)fileIn);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        StringBuilder errlog = new StringBuilder();
        StationObsDataset sobs = (StationObsDataset)TypedDatasetFactory.open(FeatureType.STATION, ncd, null, errlog);
        List<Station> stns = sobs.getStations();
        List<VariableSimpleIF> vars = sobs.getDataVariables();
        FileOutputStream fos = new FileOutputStream(fileOut);
        DataOutputStream out = new DataOutputStream(fos);
        WriterCFStationObsDataset writer = new WriterCFStationObsDataset(out, "rewrite " + fileIn);
        writer.writeHeader(stns, vars, -1);
        if (sort) {
            for (Station s : stns) {
                DataIterator iter = sobs.getDataIterator(s);
                while (iter.hasNext()) {
                    StationObsDatatype sobsData = (StationObsDatatype)iter.nextData();
                    StructureData data = sobsData.getData();
                    writer.writeRecord(sobsData, data);
                }
            }
        } else {
            DataIterator iter = sobs.getDataIterator(1000000);
            while (iter.hasNext()) {
                StationObsDatatype sobsData = (StationObsDatatype)iter.nextData();
                StructureData data = sobsData.getData();
                writer.writeRecord(sobsData, data);
            }
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("Rewrite " + fileIn + " to " + fileOut + " took = " + took);
    }

    public static void main(String[] args) throws IOException {
        String location = "C:/data/metars/Surface_METAR_20070329_0000.nc";
        File file = new File(location);
        WriterCFStationObsDataset.rewrite(location, "C:/temp/FU" + file.getName(), false, false);
        WriterCFStationObsDataset.rewrite(location, "C:/temp/FS" + file.getName(), false, true);
        WriterCFStationObsDataset.rewrite(location, "C:/temp/MU" + file.getName(), true, false);
        WriterCFStationObsDataset.rewrite(location, "C:/temp/MS" + file.getName(), true, true);
    }

    public static void main2(String[] args) throws IOException {
        File[] files;
        long start = System.currentTimeMillis();
        String toLocation = "C:/temp2/";
        String fromLocation = "C:/data/metars/";
        if (args.length > 1) {
            fromLocation = args[0];
            toLocation = args[1];
        }
        System.out.println("Rewrite .nc files from " + fromLocation + " to " + toLocation);
        File dir = new File(fromLocation);
        for (File file : files = dir.listFiles()) {
            if (!file.getName().endsWith(".nc")) continue;
            WriterCFStationObsDataset.rewrite(file.getAbsolutePath(), toLocation + file.getName(), true, true);
        }
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took);
    }

    private class StationTracker {
        int numChildren = 0;
        int lastChild = -1;
        int parent_index;
        List<Integer> link = new ArrayList<Integer>();

        StationTracker(int parent_index) {
            this.parent_index = parent_index;
        }
    }

    private class NetcdfFileStream
    extends NetcdfFile {
        N3outputStreamWriter swriter;
        DataOutputStream stream;

        NetcdfFileStream(DataOutputStream stream) {
            this.stream = stream;
            this.swriter = new N3outputStreamWriter((NetcdfFile)this);
        }

        void writeHeader(int numrec) throws IOException {
            this.swriter.writeHeader(this.stream, numrec);
        }

        void writeNonRecordData(String varName, Array data) throws IOException {
            this.swriter.writeNonRecordData(this.findVariable(varName), this.stream, data);
        }

        void writeRecordData(List<Variable> varList) throws IOException {
            this.swriter.writeRecordData(this.stream, varList);
        }
    }
}

