/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class JarMain {
    private static final String USAGE = "usage: java <utility> [options...]";
    private static HashMap<String, String> utilPrefixMap = new HashMap();

    private static String availableUtilities() {
        StringBuffer sbuf = new StringBuffer();
        for (String util : utilPrefixMap.keySet()) {
            sbuf.append(utilPrefixMap.get(util));
            sbuf.append(util);
            sbuf.append("\n");
        }
        return sbuf.toString();
    }

    public static void main(String[] args) {
        try {
            String utilPrefix;
            if (args.length < 1) {
                JarMain.usage("Missing utility name");
            }
            if ((utilPrefix = utilPrefixMap.get(args[0])) == null) {
                System.out.println("Available utilities are: ");
                System.out.println(JarMain.availableUtilities());
                JarMain.usage("No such utility");
            }
            Class<?> cls = Class.forName(utilPrefix + args[0]);
            Method mainMethod = cls.getMethod("main", String[].class);
            String[] mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (InvocationTargetException ITE) {
            if (ITE.getCause() != null) {
                JarMain.usage(ITE.getCause().toString());
            } else {
                System.err.println("Problem invoking main method:");
                ITE.printStackTrace(System.err);
            }
        }
        catch (Throwable e) {
            JarMain.usage(e.toString());
        }
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.err.println(USAGE);
        System.exit(-1);
    }

    static {
        utilPrefixMap.put("DbCacheSize", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbDump", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbLoad", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbPrintLog", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbTruncateLog", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbRunAction", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbScavenger", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbSpace", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbStat", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbVerify", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbVerifyLog", "com.sleepycat.je.util.");
        utilPrefixMap.put("DbEnableReplication", "com.sleepycat.je.rep.util.");
        utilPrefixMap.put("DbGroupAdmin", "com.sleepycat.je.rep.util.");
        utilPrefixMap.put("LDiff", "com.sleepycat.je.rep.util.ldiff.");
        utilPrefixMap.put("DbDumpGroup", "com.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbFeederPrintLog", "com.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbStreamVerify", "com.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbSync", "com.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbRepRunAction", "com.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbNullNode", "com.sleepycat.je.rep.utilint.");
    }
}

