/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DAPNode;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConstructor;
import opendap.dap.DataReadException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;
import opendap.dap.parsers.DDSXMLParser;
import opendap.servers.SDArray;

public class DGrid
extends DConstructor
implements ClientIO {
    public static final int ARRAY = 1;
    public static final int MAPS = 2;
    protected DArray arrayVar;
    protected Vector mapVars = new Vector();

    public DGrid() {
        this(null);
    }

    public DGrid(String n) {
        super(n);
    }

    @Override
    public String getTypeName() {
        return "Grid";
    }

    @Override
    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.mapVars.size() + 1;
        }
        int count = 0;
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            count += bt.elementCount(leaves);
        }
        return count += this.arrayVar.elementCount(leaves);
    }

    @Override
    public void addVariable(BaseType v, int part) {
        if (!(v instanceof DArray)) {
            throw new IllegalArgumentException("Grid `" + this.getEncodedName() + "'s' member `" + this.arrayVar.getEncodedName() + "' must be an array");
        }
        v.setParent(this);
        switch (part) {
            case 1: {
                this.arrayVar = (DArray)v;
                return;
            }
            case 2: {
                this.mapVars.addElement(v);
                return;
            }
        }
        throw new IllegalArgumentException("addVariable(): Unknown Grid part");
    }

    @Override
    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            if (this.arrayVar.getEncodedName().equals(name)) {
                return this.arrayVar;
            }
            Enumeration e = this.mapVars.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DGrid.getVariable() No such variable: '" + name + "'");
    }

    @Override
    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index == 0) {
            return this.arrayVar;
        }
        int i = index - 1;
        if (i < this.mapVars.size()) {
            return (BaseType)this.mapVars.elementAt(i);
        }
        throw new NoSuchVariableException("DGrid.getVariable() No Such variable: " + index + " - 1");
    }

    @Override
    public int getVarCount() {
        return this.mapVars.size() + 1;
    }

    @Override
    public Enumeration getVariables() {
        return new EnumerateDGrid();
    }

    @Override
    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.mapVars, this.getEncodedName(), this.getTypeName());
        if (this.arrayVar == null) {
            throw new BadSemanticsException("DGrid.checkSemantics(): Null grid base array in `" + this.getEncodedName() + "'");
        }
        this.arrayVar.checkSemantics(all);
        if (this.mapVars.size() != this.arrayVar.numDimensions()) {
            throw new BadSemanticsException("DGrid.checkSemantics(): The number of map variables for grid `" + this.getEncodedName() + "' does not match the number of dimensions of `" + this.arrayVar.getEncodedName() + "'");
        }
        Enumeration emap = this.mapVars.elements();
        Enumeration edims = this.arrayVar.getDimensions();
        int dim = 0;
        while (emap.hasMoreElements() && edims.hasMoreElements()) {
            DArray thisMapArray = (DArray)emap.nextElement();
            Enumeration ema = thisMapArray.getDimensions();
            DArrayDimension thisMapDim = (DArrayDimension)ema.nextElement();
            DArrayDimension thisArrayDim = (DArrayDimension)edims.nextElement();
            if (thisMapDim.getSize() != thisArrayDim.getSize()) {
                throw new BadSemanticsException("In grid '" + this.getEncodedName() + " The size of dimension " + dim + " in the array component '" + this.arrayVar.getEncodedName() + "is not equal to the size of the coresponding map vector '" + thisMapArray.getEncodedName() + ".");
            }
            ++dim;
        }
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        os.println(space + " ARRAY:");
        this.arrayVar.printDecl(os, space + "    ", true);
        os.println(space + " MAPS:");
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os, space + "    ", true);
        }
        os.print(space + "} " + this.getEncodedName());
        if (print_semi) {
            os.println(";");
        }
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ARRAY: ");
        this.arrayVar.printVal(os, "", false);
        os.print(" MAPS: ");
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printVal(os, "", false);
            if (!e.hasMoreElements()) continue;
            os.print(", ");
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, DataReadException {
        this.arrayVar.deserialize(source, sv, statusUI);
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("DGrid.deserialize(): User cancelled");
            }
            ClientIO bt = (ClientIO)e.nextElement();
            bt.deserialize(source, sv, statusUI);
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        this.arrayVar.externalize(sink);
        Enumeration e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            ClientIO bt = (ClientIO)e.nextElement();
            bt.externalize(sink);
        }
    }

    @Override
    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<Grid");
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        pw.println(">");
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String aName = (String)e.nextElement();
            Attribute a = this.getAttribute(aName);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        this.arrayVar.printXML(pw, pad + "\t", constrained);
        e = this.mapVars.elements();
        while (e.hasMoreElements()) {
            DArray map = (DArray)e.nextElement();
            map.printAsMapXML(pw, pad + "\t", constrained);
        }
        pw.println(pad + "</Grid>");
    }

    public DArray getArray() {
        return this.arrayVar;
    }

    public Vector<DArrayDimension> getArrayDims() {
        return this.arrayVar.dimVector;
    }

    public int projectedComponents(boolean constrained) {
        int comp;
        if (constrained) {
            comp = this.arrayVar.isProject() ? 1 : 0;
            Enumeration e = this.mapVars.elements();
            while (e.hasMoreElements()) {
                if (!((DArray)e.nextElement()).isProject()) continue;
                ++comp;
            }
        } else {
            comp = 1 + this.mapVars.size();
        }
        return comp;
    }

    public boolean projectionYieldsGrid(boolean constrained) {
        int nmaps;
        if (!constrained) {
            return true;
        }
        boolean valid = true;
        if (!((SDArray)this.arrayVar).isProject()) {
            return false;
        }
        int nadims = this.arrayVar.numDimensions();
        if (nadims != (nmaps = this.getVarCount() - 1)) {
            valid = false;
        } else {
            for (int d = 0; d < nadims; ++d) {
                try {
                    DArrayDimension thisDim = this.arrayVar.getDimension(d);
                    SDArray mapArray = (SDArray)this.getVar(d + 1);
                    DArrayDimension mapDim = mapArray.getFirstDimension();
                    if (thisDim.getSize() > 0) {
                        if (mapArray.isProject()) {
                            valid = valid && mapDim.getStart() == thisDim.getStart();
                            valid = valid && mapDim.getStop() == thisDim.getStop();
                            valid = valid && mapDim.getStride() == thisDim.getStride();
                            continue;
                        }
                        valid = false;
                        continue;
                    }
                    valid = !mapArray.isProject();
                    continue;
                }
                catch (Exception e) {
                    valid = false;
                    break;
                }
            }
        }
        return valid;
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DGrid g = (DGrid)super.cloneDAG(map);
        g.arrayVar = (DArray)DGrid.cloneDAG(map, this.arrayVar);
        g.mapVars = new Vector();
        for (int i = 0; i < this.mapVars.size(); ++i) {
            BaseType bt = (BaseType)this.mapVars.elementAt(i);
            BaseType btclone = (BaseType)DGrid.cloneDAG(map, bt);
            g.mapVars.addElement(btclone);
        }
        return g;
    }

    class EnumerateDGrid
    implements Enumeration {
        boolean array = false;
        Enumeration e;

        EnumerateDGrid() {
            this.e = DGrid.this.mapVars.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return !this.array || this.e.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.array) {
                this.array = true;
                return DGrid.this.arrayVar;
            }
            return this.e.nextElement();
        }
    }
}

