/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetImpl;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointDatasetImpl
extends FeatureDatasetImpl
implements FeatureDatasetPoint {
    protected List<FeatureCollection> collectionList;
    protected FeatureType featureType;

    protected PointDatasetImpl(FeatureType featureType) {
        this.featureType = featureType;
    }

    protected PointDatasetImpl(PointDatasetImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
        super(from);
        this.collectionList = from.collectionList;
        this.featureType = from.featureType;
        if (filter_bb == null) {
            this.boundingBox = from.boundingBox;
        } else {
            LatLonRect latLonRect = this.boundingBox = from.boundingBox == null ? filter_bb : from.boundingBox.intersect(filter_bb);
        }
        this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
    }

    public PointDatasetImpl(NetcdfDataset ds, FeatureType featureType) {
        super(ds);
        this.featureType = featureType;
    }

    protected void setPointFeatureCollection(List<FeatureCollection> collectionList) {
        this.collectionList = collectionList;
    }

    protected void setPointFeatureCollection(FeatureCollection collection) {
        this.collectionList = new ArrayList<FeatureCollection>(1);
        this.collectionList.add(collection);
    }

    @Override
    public FeatureType getFeatureType() {
        return this.featureType;
    }

    protected void setFeatureType(FeatureType ftype) {
        this.featureType = ftype;
    }

    @Override
    public List<FeatureCollection> getPointFeatureCollectionList() {
        return this.collectionList;
    }

    @Override
    public void calcBounds() throws IOException {
        if (this.boundingBox != null && this.dateRange != null) {
            return;
        }
        LatLonRect bb = null;
        CalendarDateRange dates = null;
        for (FeatureCollection fc : this.collectionList) {
            if (fc instanceof PointFeatureCollection) {
                PointFeatureCollection pfc = (PointFeatureCollection)fc;
                pfc.calcBounds();
                if (bb == null) {
                    bb = pfc.getBoundingBox();
                } else {
                    bb.extend(pfc.getBoundingBox());
                }
                if (dates == null) {
                    dates = pfc.getCalendarDateRange();
                    continue;
                }
                dates.extend(pfc.getCalendarDateRange());
                continue;
            }
            if (!(fc instanceof StationTimeSeriesFeatureCollection)) continue;
            StationTimeSeriesFeatureCollection sc = (StationTimeSeriesFeatureCollection)fc;
            if (this.boundingBox == null) {
                if (bb == null) {
                    bb = sc.getBoundingBox();
                } else {
                    bb.extend(sc.getBoundingBox());
                }
            }
            if (this.dateRange != null) continue;
            PointFeatureCollection pfc = sc.flatten(null, (CalendarDateRange)null);
            pfc.calcBounds();
            if (dates == null) {
                dates = pfc.getCalendarDateRange();
                continue;
            }
            dates.extend(pfc.getCalendarDateRange());
        }
        if (this.boundingBox == null) {
            this.boundingBox = bb;
        }
        if (this.dateRange == null) {
            this.dateRange = dates;
        }
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        super.getDetailInfo(sf);
        int count = 0;
        for (FeatureCollection fc : this.collectionList) {
            sf.format("%nFeatureCollection %d %n", count++);
            if (fc instanceof PointFeatureCollection) {
                PointFeatureCollection pfc = (PointFeatureCollection)fc;
                sf.format(" %s %s\n", new Object[]{pfc.getCollectionFeatureType(), pfc.getName()});
                sf.format("   npts = %d %n", pfc.size());
                sf.format("     bb = %s %n", pfc.getBoundingBox() == null ? "" : pfc.getBoundingBox().toString2());
                sf.format("  dates = %s %n", pfc.getDateRange() == null ? "" : pfc.getDateRange().toString());
                continue;
            }
            if (!(fc instanceof StationTimeSeriesFeatureCollection)) continue;
            StationTimeSeriesFeatureCollection npfc = (StationTimeSeriesFeatureCollection)fc;
            sf.format(" %s %s\n", new Object[]{npfc.getCollectionFeatureType(), npfc.getName()});
            sf.format("   npts = %d %n", npfc.size());
            sf.format("     bb = %s %n", npfc.getBoundingBox() == null ? "" : npfc.getBoundingBox().toString2());
        }
    }
}

